/*
 * This file is part of the proxy model test suite.
 *
 * Copyright 2009  Stephen Kelly <steveire@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "selectionpmwidget.h"

#include <QSplitter>
#include <QTreeView>
#include <QHBoxLayout>
#include <QLabel>

#include "dynamictreemodel.h"
#include "dynamictreewidget.h"
#include "kselectionproxymodel.h"

SelectionProxyWidget::SelectionProxyWidget(QWidget* parent): QWidget(parent)
{
  QHBoxLayout *layout = new QHBoxLayout(this);
  QSplitter *vSplitter = new QSplitter( this );
  QSplitter *hSplitter1 = new QSplitter ( Qt::Vertical, vSplitter );
  QSplitter *hSplitter2 = new QSplitter ( Qt::Vertical, vSplitter );
  layout->addWidget(vSplitter);

  m_rootModel = new DynamicTreeModel(this);

  DynamicTreeWidget *dynTreeWidget = new DynamicTreeWidget(m_rootModel, hSplitter1);

  QTreeView *rootView = dynTreeWidget->treeView();

  KSelectionProxyModel *selectedBranchesModel = new KSelectionProxyModel(rootView->selectionModel(), this);
  selectedBranchesModel->setSourceModel(m_rootModel);
  selectedBranchesModel->setFilterBehavior(KSelectionProxyModel::SubTrees);

  QTreeView *selectedBranchesView = createLabelledView("SubTrees", hSplitter2);
  selectedBranchesView->setModel(selectedBranchesModel);

  KSelectionProxyModel *selectedBranchesRootsModel = new KSelectionProxyModel(rootView->selectionModel(), this);
  selectedBranchesRootsModel->setSourceModel(m_rootModel);
  selectedBranchesRootsModel->setFilterBehavior(KSelectionProxyModel::SubTreeRoots);

  QTreeView *selectedBranchesRootsView = createLabelledView("SubTreeRoots", hSplitter2 );
  selectedBranchesRootsView->setModel(selectedBranchesRootsModel);

  KSelectionProxyModel *selectedBranchesChildrenModel = new KSelectionProxyModel(rootView->selectionModel(), this);
  selectedBranchesChildrenModel->setSourceModel(m_rootModel);
  selectedBranchesChildrenModel->setFilterBehavior(KSelectionProxyModel::SubTreesWithoutRoots);

  QTreeView *selectedBranchesChildrenView = createLabelledView("SubTreesWithoutRoots", hSplitter1 );
  selectedBranchesChildrenView->setModel(selectedBranchesChildrenModel);

  KSelectionProxyModel *onlySelectedModel = new KSelectionProxyModel(rootView->selectionModel(), this);
  onlySelectedModel->setSourceModel(m_rootModel);
  onlySelectedModel->setFilterBehavior(KSelectionProxyModel::ExactSelection);

  QTreeView *onlySelectedView = createLabelledView("ExactSelection", hSplitter1 );
  onlySelectedView->setModel(onlySelectedModel);

  KSelectionProxyModel *onlySelectedChildrenModel = new KSelectionProxyModel(rootView->selectionModel(), this);
  onlySelectedChildrenModel->setSourceModel(m_rootModel);
  onlySelectedChildrenModel->setFilterBehavior(KSelectionProxyModel::ChildrenOfExactSelection);

  QTreeView *onlySelectedChildrenView = createLabelledView("ChildrenOfExactSelection", hSplitter2 );
  onlySelectedChildrenView->setModel(onlySelectedChildrenModel);
}

QTreeView* SelectionProxyWidget::createLabelledView(const QString &labelText, QWidget *parent)
{
  QWidget *labelledTreeWidget = new QWidget(parent);
  QVBoxLayout *layout = new QVBoxLayout(labelledTreeWidget);

  QLabel *label = new QLabel(labelText, labelledTreeWidget);
  QTreeView *treeview = new QTreeView( labelledTreeWidget );

  layout->addWidget(label);
  layout->addWidget(treeview);
  return treeview;
}

