//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    /// <remarks>
    ///  Topics:
    ///   - <see cref="#intro"></see>
    ///   - <see cref="#manipulation"></see>
    ///   - <see cref="#compatibility"></see>
    ///  @section intro Introduction
    ///  The class KDateTime combines a date and time with support for an
    ///  associated time zone or UTC offset. When manipulating KDateTime objects,
    ///  their time zones or UTC offsets are automatically taken into account. KDateTime
    ///  can also be set to represent a date-only value with no associated time.
    ///  The class uses QDateTime internally to represent date/time values, and
    ///  therefore uses the Gregorian calendar for dates starting from 15 October 1582,
    ///  and the Julian calendar for dates up to 4 October 1582. The minimum year
    ///  number is -4712 (4713 BC), while the upper limit is more than 11,000,000. The
    ///  actual adoption of the Gregorian calendar after 1582 was slow; the last European
    ///  country to adopt it, Greece, did so only in 1923. See QDateTime Considerations
    ///  section below for further discussion of the date range limitations.
    ///  The time specification types which KDateTime supports are:
    ///  - the UTC time zone
    ///  - a local time with a specified offset from UTC
    ///  - a local time in a specified time zone
    ///  - a local time using the current system time zone (a special case of the
    ///    previous item)
    ///  - local clock time, using whatever the local system clock says on whichever
    ///    computer it happens to be on. In this case, the equivalent UTC time will
    ///    vary depending on system. As a result, calculations involving local clock
    ///    times do not necessarily produce reliable results.
    ///  These characteristics are more fully described in the description of the
    ///  SpecType enumeration. Also see
    ///  <a href="http://www.w3.org/TR/timezone/">W3C: Working with Time Zones</a>
    ///  for a good overview of the different ways of representing times.
    ///  To set the time specification, use one of the setTimeSpec() methods, to get
    ///  the time specification, call timeSpec(), isUtc(), isLocalZone(),
    ///  isOffsetFromUtc() or isClockTime(). To determine whether two KDateTime
    ///  instances have the same time specification, call timeSpec() on each and
    ///  compare the returned values using KDateTime.Spec.Operator==().
    ///  @section manipulation Date and Time Manipulation
    ///  A KDateTime object can be created by passing a date and time in its
    ///  constructor, together with a time specification.
    ///  If both the date and time are null, isNull() returns true. If the date, time
    ///  and time specification are all valid, isValid() returns true.
    ///  A KDateTime object can be converted to a different time specification by
    ///  using toUtc(), toLocalZone() or toClockTime(). It can be converted to a
    ///  specific time zone by toZone(). To return the time as an elapsed time since
    ///  1 January 1970 (as used by time(2)), use toTime_t(). The results of time
    ///  zone conversions are cached to minimize the need for recalculation. Each
    ///  KDateTime object caches its UTC equivalent and the last time zone
    ///  conversion performed.
    ///  The date and time can be set either in the constructor, or afterwards by
    ///  calling setDate(), setTime() or setDateTime(). To return the date and/or
    ///  time components of the KDateTime, use date(), time() and dateTime(). You
    ///  can determine whether the KDateTime represents a date and time, or a date
    ///  only, by isDateOnly(). You can change between a date and time or a date only
    ///  value using setDateOnly().
    ///  You can increment or decrement the date/time using addSecs(), addDays(),
    ///  addMonths() and addYears(). The interval between two date/time values can
    ///  be found using secsTo() or daysTo().
    ///  The comparison operators (operator==(), operator<(), etc.) all take the time
    ///  zone properly into account; if the two KDateTime objects have different time
    ///  zones, they are first converted to UTC before the comparison is
    ///  performed. An alternative to the comparison operators is compare() which will
    ///  in addition tell you if a KDateTime object overlaps with another when one or
    ///  both are date-only values.
    ///  KDateTime values may be converted to and from a string representation using
    ///  the toString() and fromString() methods. These handle a variety of text
    ///  formats including ISO 8601 and RFC 2822.
    ///  KDateTime uses Qt's facilities to implicitly share data. Copying instances
    ///  is very efficient, and copied instances share cached UTC and time zone
    ///  conversions even after the copy is performed. A separate copy of the data is
    ///  created whenever a non-const method is called. If you want to force the
    ///  creation of a separate copy of the data (e.g. if you want two copies to
    ///  cache different time zone conversions), call detach(). 
    ///  @section compatibility QDateTime Considerations
    ///  KDateTime's interface is designed to be as compatible as possible with that
    ///  of QDateTime, but with adjustments to cater for time zone handling. Because
    ///  QDateTime lacks methods, KDateTime is not inherited from QDateTime,
    ///  but instead is implemented using a private QDateTime object.
    ///  The date range restriction due to the use of QDateTime internally may at
    ///  first sight seem a design limitation. However, two factors should be
    ///  considered:
    ///  - there are significant problems in the representation of dates before the
    ///    Gregorian calendar was adopted. The date of adoption of the Gregorian
    ///    calendar varied from place to place, and in the Julian calendar the
    ///    date of the new year varied so that in different places the year number
    ///    could differ by one. So any date/time system which attempted to represent
    ///    dates as actually used in history would be too specialized to belong to
    ///    the core KDE libraries. Date/time systems for scientific applications can
    ///    be much simpler, but may differ from historical records.
    ///  - time zones were not invented until the middle of the 19th century. Before
    ///    that, solar time was used.
    ///  Because of these issues, together with the fact that KDateTime's aim is to
    ///  provide automatic time zone handling for date/time values, QDateTime was
    ///  chosen as the basis for KDateTime. For those who need an extended date
    ///  range, other classes exist.
    /// </remarks>        <author> David Jarvie \<djarvie@kde.org\>.
    ///  </author>
    ///         <short> A class representing a date and time with an associated time zone.</short>
    ///         <see> KTimeZone</see>
    ///         <see> KSystemTimeZones</see>
    ///         <see> QDateTime</see>
    ///         <see> QDate</see>
    ///         <see> QTime</see>
    ///         <see> <a</see>
    ///         <see> href="http://www.w3.org/TR/timezone/">W3C:</see>
    ///         <see> Working</see>
    ///         <see> with</see>
    ///         <see> Time</see>
    ///         <see> Zones</a></see>
    [SmokeClass("KDateTime")]
    public class KDateTime : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KDateTime(Type dummy) {}
        /// <remarks>
        ///  The full time specification of a KDateTime instance.
        ///  This specifies how the date/time component of the KDateTime instance
        ///  should be interpreted, i.e. which time zone (if any) the date/time is
        ///  expressed in.
        ///      </remarks>        <short>    The full time specification of a KDateTime instance.</short>
        [SmokeClass("KDateTime::Spec")]
        public class Spec : Object, IDisposable {
            protected SmokeInvocation interceptor = null;
            private IntPtr smokeObject;
            protected Spec(Type dummy) {}
            protected void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(Spec), this);
            }
            private static SmokeInvocation staticInterceptor = null;
            static Spec() {
                staticInterceptor = new SmokeInvocation(typeof(Spec), null);
            }
            /// <remarks>
            ///  Constructs an invalid time specification.
            ///          </remarks>        <short>    Constructs an invalid time specification.</short>
            public Spec() : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Spec", "Spec()", typeof(void));
            }
            /// <remarks>
            ///  Constructs a time specification for a given time zone.
            ///  If <code>tz</code> is KTimeZone.Utc(), the time specification type is set to <code>UTC.</code>
            /// <param> name="tz" time zone
            ///          </param></remarks>        <short>    Constructs a time specification for a given time zone.</short>
            public Spec(KTimeZone tz) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Spec#", "Spec(const KTimeZone&)", typeof(void), typeof(KTimeZone), tz);
            }
            /// <remarks>
            ///  Constructs a time specification.
            /// <param> name="type" time specification type, which should not be <code>TimeZone</code>
            /// </param><param> name="utcOffset" number of seconds to add to UTC to get the local
            ///                   time. Ignored if <code>type</code> is not <code>OffsetFromUTC.</code>
            ///          </param></remarks>        <short>    Constructs a time specification.</short>
            public Spec(KDateTime.SpecType type, int utcOffset) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Spec$$", "Spec(KDateTime::SpecType, int)", typeof(void), typeof(KDateTime.SpecType), type, typeof(int), utcOffset);
            }
            public Spec(KDateTime.SpecType type) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Spec$", "Spec(KDateTime::SpecType)", typeof(void), typeof(KDateTime.SpecType), type);
            }
            /// <remarks>
            ///  Copy constructor.
            ///          </remarks>        <short>    Copy constructor.</short>
            public Spec(KDateTime.Spec spec) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Spec#", "Spec(const KDateTime::Spec&)", typeof(void), typeof(KDateTime.Spec), spec);
            }
            /// <remarks>
            ///  Returns whether the time specification is valid.
            /// </remarks>        <return> @c true if valid, else @c false
            ///          </return>
            ///         <short>    Returns whether the time specification is valid.</short>
            public bool IsValid() {
                return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
            }
            /// <remarks>
            ///  Returns the time zone for the date/time, according to the time
            ///  specification type as follows:
            ///  - <code>TimeZone</code>  : the specified time zone is returned.
            ///  - <code>UTC</code>       : a UTC time zone is returned.
            ///  - <code>LocalZone</code> : the current local time zone is returned.
            /// </remarks>        <return> time zone as defined above, or invalid in all other cases
            /// </return>
            ///         <short>    Returns the time zone for the date/time, according to the time  specification type as follows:  - @c TimeZone  : the specified time zone is returned.</short>
            ///         <see> isUtc</see>
            ///         <see> isLocal</see>
            public KTimeZone TimeZone() {
                return (KTimeZone) interceptor.Invoke("timeZone", "timeZone() const", typeof(KTimeZone));
            }
            /// <remarks>
            ///  Returns the time specification type, i.e. whether it is
            ///  UTC, has a time zone, etc. If the type is the local time zone,
            ///  <code>TimeZone</code> is returned; use isLocalZone() to check for the
            ///  local time zone.
            /// </remarks>        <return> specification type
            /// </return>
            ///         <short>    Returns the time specification type, i.</short>
            ///         <see> isLocalZone</see>
            ///         <see> isClockTime</see>
            ///         <see> isUtc</see>
            ///         <see> timeZone</see>
            public KDateTime.SpecType type() {
                return (KDateTime.SpecType) interceptor.Invoke("type", "type() const", typeof(KDateTime.SpecType));
            }
            /// <remarks>
            ///  Returns whether the time specification is the current local
            ///  system time zone.
            /// </remarks>        <return> @c true if local system time zone
            /// </return>
            ///         <short>    Returns whether the time specification is the current local  system time zone.</short>
            ///         <see> isUtc</see>
            ///         <see> isOffsetFromUtc</see>
            ///         <see> timeZone</see>
            public bool IsLocalZone() {
                return (bool) interceptor.Invoke("isLocalZone", "isLocalZone() const", typeof(bool));
            }
            /// <remarks>
            ///  Returns whether the time specification is a local clock time.
            /// </remarks>        <return> @c true if local clock time
            /// </return>
            ///         <short>    Returns whether the time specification is a local clock time.</short>
            ///         <see> isUtc</see>
            ///         <see> timeZone</see>
            public bool IsClockTime() {
                return (bool) interceptor.Invoke("isClockTime", "isClockTime() const", typeof(bool));
            }
            /// <remarks>
            ///  Returns whether the time specification is a UTC time.
            ///  It is considered to be a UTC time if it is either type <code>UTC</code>,
            ///  or is type <code>OffsetFromUTC</code> with a zero UTC offset.
            /// </remarks>        <return> @c true if UTC
            /// </return>
            ///         <short>    Returns whether the time specification is a UTC time.</short>
            ///         <see> isLocal</see>
            ///         <see> isOffsetFromUtc</see>
            ///         <see> timeZone</see>
            public bool IsUtc() {
                return (bool) interceptor.Invoke("isUtc", "isUtc() const", typeof(bool));
            }
            /// <remarks>
            ///  Returns whether the time specification is a local time at a fixed
            ///  offset from UTC.
            /// </remarks>        <return> @c true if local time at fixed offset from UTC
            /// </return>
            ///         <short>    Returns whether the time specification is a local time at a fixed  offset from UTC.</short>
            ///         <see> isLocal</see>
            ///         <see> isUtc</see>
            ///         <see> utcOffset</see>
            public bool IsOffsetFromUtc() {
                return (bool) interceptor.Invoke("isOffsetFromUtc", "isOffsetFromUtc() const", typeof(bool));
            }
            /// <remarks>
            ///  Returns the UTC offset associated with the time specification. The
            ///  UTC offset is the number of seconds to add to UTC to get the local time.
            /// </remarks>        <return> UTC offset in seconds if type is @c OffsetFromUTC, else 0
            /// </return>
            ///         <short>    Returns the UTC offset associated with the time specification.</short>
            ///         <see> isOffsetFromUtc</see>
            public int UtcOffset() {
                return (int) interceptor.Invoke("utcOffset", "utcOffset() const", typeof(int));
            }
            /// <remarks>
            ///  Initialises the time specification.
            /// <param> name="type" the time specification type. Note that <code>TimeZone</code>
            ///                   is invalid here.
            /// </param><param> name="utcOffset" number of seconds to add to UTC to get the local
            ///                   time. Ignored if <code>spec</code> is not <code>OffsetFromUTC.</code>
            /// </param></remarks>        <short>    Initialises the time specification.</short>
            ///         <see> type</see>
            ///         <see> setType(const</see>
            ///         <see> KTimeZone&)</see>
            public void SetType(KDateTime.SpecType type, int utcOffset) {
                interceptor.Invoke("setType$$", "setType(KDateTime::SpecType, int)", typeof(void), typeof(KDateTime.SpecType), type, typeof(int), utcOffset);
            }
            public void SetType(KDateTime.SpecType type) {
                interceptor.Invoke("setType$", "setType(KDateTime::SpecType)", typeof(void), typeof(KDateTime.SpecType), type);
            }
            /// <remarks>
            ///  Sets the time zone for the time specification.
            ///  To set the time zone to the current local system time zone,
            ///  setType(LocalZone) may optionally be used instead.
            /// <param> name="tz" new time zone
            /// </param></remarks>        <short>    Sets the time zone for the time specification.</short>
            ///         <see> timeZone</see>
            ///         <see> setType(SpecType)</see>
            public void SetType(KTimeZone tz) {
                interceptor.Invoke("setType#", "setType(const KTimeZone&)", typeof(void), typeof(KTimeZone), tz);
            }
            /// <remarks>
            ///  Comparison operator.
            /// </remarks>        <return> @c true if the two instances are identical, @c false otherwise
            /// </return>
            ///         <short>    Comparison operator.</short>
            ///         <see> equivalentTo</see>
            public override bool Equals(object o) {
                if (!(o is Spec)) { return false; }
                return this == (Spec) o;
            }
            public override int GetHashCode() {
                return interceptor.GetHashCode();
            }
            /// <remarks>
            ///  Checks whether this instance is equivalent to another.
            ///  The two instances are considered to be equivalent if any of the following
            ///  conditions apply:
            ///  - both instances are type <code>ClockTime.</code>
            ///  - both instances are type <code>OffsetFromUTC</code> and their offsets from UTC are equal.
            ///  - both instances are type <code>TimeZone</code> and their time zones are equal.
            ///  - both instances are UTC. An instance is considered to be UTC if it is
            ///    either type <code>UTC</code>, or is type <code>OffsetFromUTC</code> with a zero UTC offset.
            /// </remarks>        <return> @c true if the two instances are equivalent, @c false otherwise
            /// </return>
            ///         <short>    Checks whether this instance is equivalent to another.</short>
            ///         <see> operator==</see>
            public bool EquivalentTo(KDateTime.Spec other) {
                return (bool) interceptor.Invoke("equivalentTo#", "equivalentTo(const KDateTime::Spec&) const", typeof(bool), typeof(KDateTime.Spec), other);
            }
            ~Spec() {
                interceptor.Invoke("~Spec", "~Spec()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~Spec", "~Spec()", typeof(void));
            }
            public static bool operator==(Spec lhs, KDateTime.Spec other) {
                return (bool) staticInterceptor.Invoke("operator==#", "operator==(const KDateTime::Spec&) const", typeof(bool), typeof(Spec), lhs, typeof(KDateTime.Spec), other);
            }
            public static bool operator!=(Spec lhs, KDateTime.Spec other) {
                return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const KDateTime::Spec&) const", typeof(bool), typeof(Spec), lhs, typeof(KDateTime.Spec), other);
            }
            /// <remarks>
            ///  The UTC time specification.
            ///  Provided as a shorthand for KDateTime.Spec(KDateTime.UTC).
            ///          </remarks>        <short>    The UTC time specification.</short>
            public static KDateTime.Spec UTC() {
                return (KDateTime.Spec) staticInterceptor.Invoke("UTC", "UTC()", typeof(KDateTime.Spec));
            }
            /// <remarks>
            ///  The ClockTime time specification.
            ///  Provided as a shorthand for KDateTime.Spec(KDateTime.ClockTime).
            ///          </remarks>        <short>    The ClockTime time specification.</short>
            public static KDateTime.Spec ClockTime() {
                return (KDateTime.Spec) staticInterceptor.Invoke("ClockTime", "ClockTime()", typeof(KDateTime.Spec));
            }
            /// <remarks>
            ///  Returns a UTC offset time specification.
            ///  Provided as a shorthand for KDateTime.Spec(KDateTime.OffsetFromUTC, utcOffset).
            /// <param> name="utcOffset" number of seconds to add to UTC to get the local time
            /// </param></remarks>        <return> UTC offset time specification
            ///          </return>
            ///         <short>    Returns a UTC offset time specification.</short>
            public static KDateTime.Spec OffsetFromUTC(int utcOffset) {
                return (KDateTime.Spec) staticInterceptor.Invoke("OffsetFromUTC$", "OffsetFromUTC(int)", typeof(KDateTime.Spec), typeof(int), utcOffset);
            }
            /// <remarks>
            ///  Returns a local time zone time specification.
            ///  Provided as a shorthand for KDateTime.Spec(KDateTime.LocalZone).
            /// </remarks>        <return> Local zone time specification
            ///          </return>
            ///         <short>    Returns a local time zone time specification.</short>
            public static KDateTime.Spec LocalZone() {
                return (KDateTime.Spec) staticInterceptor.Invoke("LocalZone", "LocalZone()", typeof(KDateTime.Spec));
            }
        }
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KDateTime), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KDateTime() {
            staticInterceptor = new SmokeInvocation(typeof(KDateTime), null);
        }
        /// <remarks>
        ///  The time specification type of a KDateTime instance.
        ///  This specifies how the date/time component of the KDateTime instance
        ///  should be interpreted, i.e. what type of time zone (if any) the date/time
        ///  is expressed in. For the full time specification (including time zone
        ///  details), see KDateTime.Spec.
        ///      </remarks>        <short>    The time specification type of a KDateTime instance.</short>
        public enum SpecType {
            Invalid = 0,
            UTC = 1,
            OffsetFromUTC = 2,
            TimeZone = 3,
            LocalZone = 4,
            ClockTime = 5,
        }
        /// <remarks> Format for strings representing date/time values. </remarks>        <short>   Format for strings representing date/time values.</short>
        public enum TimeFormat {
            ISODate = 0,
            RFCDate = 1,
            RFCDateDay = 2,
            QtTextDate = 3,
            LocalDate = 4,
        }
        /// <remarks>
        ///  How this KDateTime compares with another.
        ///  If any date-only value is involved, comparison of KDateTime values
        ///  requires them to be considered as representing time periods. A date-only
        ///  instance represents a time period from 00:00:00 to 23:59:59.999 on a given
        ///  date, while a date/time instance can be considered to represent a time
        ///  period whose start and end times are the same. They may therefore be
        ///  earlier or later, or may overlap or be contained one within the other.
        ///  Values may be OR'ed with each other in any combination of 'consecutive'
        ///  intervals to represent different types of relationship.
        ///  In the descriptions of the values below,
        ///  - s1 = start time of this instance
        ///  - e1 = end time of this instance
        ///  - s2 = start time of other instance
        ///  - e2 = end time of other instance.
        ///      </remarks>        <short>    How this KDateTime compares with another.</short>
        public enum Comparison {
            Before = 0x01,
            AtStart = 0x02,
            Inside = 0x04,
            AtEnd = 0x08,
            After = 0x10,
            Equal = AtStart|Inside|AtEnd,
            Outside = Before|AtStart|Inside|AtEnd|After,
            StartsAt = AtStart|Inside|AtEnd|After,
            EndsAt = Before|AtStart|Inside|AtEnd,
        }
        /// <remarks>
        ///  Constructs an invalid date/time.
        ///      </remarks>        <short>    Constructs an invalid date/time.</short>
        public KDateTime() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime", "KDateTime()", typeof(void));
        }
        /// <remarks>
        ///  Constructs a date-only value expressed in a given time specification. The
        ///  time is set to 00:00:00.
        ///  The instance is initialised according to the time specification type of
        ///  <code>spec</code> as follows:
        ///  - <code>UTC</code>           : date is stored as UTC.
        ///  - <code>OffsetFromUTC</code> : date is a local time at the specified offset
        ///                       from UTC.
        ///  - <code>TimeZone</code>      : date is a local time in the specified time zone.
        ///  - <code>LocalZone</code>     : date is a local date in the current system time
        ///                       zone.
        ///  - <code>ClockTime</code>     : time zones are ignored.
        /// <param> name="date" date in the time zone indicated by <code>spec</code>
        /// </param><param> name="spec" time specification
        ///      </param></remarks>        <short>    Constructs a date-only value expressed in a given time specification.</short>
        public KDateTime(QDate date, KDateTime.Spec spec) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime##", "KDateTime(const QDate&, const KDateTime::Spec&)", typeof(void), typeof(QDate), date, typeof(KDateTime.Spec), spec);
        }
        public KDateTime(QDate date) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime#", "KDateTime(const QDate&)", typeof(void), typeof(QDate), date);
        }
        /// <remarks>
        ///  Constructs a date/time expressed as specified by <code>spec.</code>
        ///  <code>date</code> and <code>time</code> are interpreted and stored according to the value of
        ///  <code>spec</code> as follows:
        ///  - <code>UTC</code>           : <code>date</code> and <code>time</code> are in UTC.
        ///  - <code>OffsetFromUTC</code> : date/time is a local time at the specified offset
        ///                       from UTC.
        ///  - <code>TimeZone</code>      : date/time is a local time in the specified time zone.
        ///  - <code>LocalZone</code>     : <code>date</code> and <code>time</code> are local times in the current
        ///                       system time zone.
        ///  - <code>ClockTime</code>     : time zones are ignored.
        /// <param> name="date" date in the time zone indicated by <code>spec</code>
        /// </param><param> name="time" time in the time zone indicated by <code>spec</code>
        /// </param><param> name="spec" time specification
        ///      </param></remarks>        <short>    Constructs a date/time expressed as specified by <code>spec.</code></short>
        public KDateTime(QDate date, QTime time, KDateTime.Spec spec) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime###", "KDateTime(const QDate&, const QTime&, const KDateTime::Spec&)", typeof(void), typeof(QDate), date, typeof(QTime), time, typeof(KDateTime.Spec), spec);
        }
        public KDateTime(QDate date, QTime time) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime##", "KDateTime(const QDate&, const QTime&)", typeof(void), typeof(QDate), date, typeof(QTime), time);
        }
        /// <remarks>
        ///  Constructs a date/time expressed in a given time specification.
        ///  <code>dt</code> is interpreted and stored according to the time specification type
        ///  of <code>spec</code> as follows:
        ///  - <code>UTC</code>           : <code>dt</code> is stored as a UTC value. If
        ///                       <code>dt.timeSpec</code>() is <code>Qt</code>.LocalTime, <code>dt</code> is first
        ///                       converted from the current system time zone to UTC
        ///                       before storage.
        ///  - <code>OffsetFromUTC</code> : date/time is stored as a local time at the specified
        ///                       offset from UTC. If <code>dt.timeSpec</code>() is <code>Qt</code>.UTC,
        ///                       the time is adjusted by the UTC offset before
        ///                       storage. If <code>dt.timeSpec</code>() is <code>Qt</code>.LocalTime,
        ///                       it is assumed to be a local time at the specified
        ///                       offset from UTC, and is stored without adjustment.
        ///  - <code>TimeZone</code>      : if <code>dt</code> is specified as a UTC time (i.e. <code>dt.timeSpec</code>()
        ///                       is <code>Qt</code>.UTC), it is first converted to local time in
        ///                       specified time zone before being stored.
        ///  - <code>LocalZone</code>     : <code>dt</code> is stored as a local time in the current system
        ///                       time zone. If <code>dt.timeSpec</code>() is <code>Qt</code>.UTC, <code>dt</code> is
        ///                       first converted to local time before storage.
        ///  - <code>ClockTime</code>     : If <code>dt.timeSpec</code>() is <code>Qt</code>.UTC, <code>dt</code> is first
        ///                       converted to local time in the current system time zone
        ///                       before storage. After storage, the time is treated as a
        ///                       simple clock time, ignoring time zones.
        /// <param> name="dt" date and time
        /// </param><param> name="spec" time specification
        ///      </param></remarks>        <short>    Constructs a date/time expressed in a given time specification.</short>
        public KDateTime(QDateTime dt, KDateTime.Spec spec) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime##", "KDateTime(const QDateTime&, const KDateTime::Spec&)", typeof(void), typeof(QDateTime), dt, typeof(KDateTime.Spec), spec);
        }
        /// <remarks>
        ///  Constructs a date/time from a QDateTime.
        ///  The KDateTime is expressed in either UTC or the local system time zone,
        ///  according to <code>dt.timeSpec</code>().
        /// <param> name="dt" date and time
        ///      </param></remarks>        <short>    Constructs a date/time from a QDateTime.</short>
        public KDateTime(QDateTime dt) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime#", "KDateTime(const QDateTime&)", typeof(void), typeof(QDateTime), dt);
        }
        public KDateTime(KDateTime other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDateTime#", "KDateTime(const KDateTime&)", typeof(void), typeof(KDateTime), other);
        }
        /// <remarks>
        ///  Returns whether the date/time is null.
        /// </remarks>        <return> @c true if both date and time are null, else @c false
        /// </return>
        ///         <short>    Returns whether the date/time is null.</short>
        ///         <see> isValid</see>
        ///         <see> QDateTime.IsNull</see>
        public bool IsNull() {
            return (bool) interceptor.Invoke("isNull", "isNull() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether the date/time is valid.
        /// </remarks>        <return> @c true if both date and time are valid, else @c false
        /// </return>
        ///         <short>    Returns whether the date/time is valid.</short>
        ///         <see> isNull</see>
        ///         <see> QDateTime.IsValid</see>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether the instance represents a date/time or a date-only value.
        /// </remarks>        <return> @c true if date-only, @c false if date and time
        ///      </return>
        ///         <short>    Returns whether the instance represents a date/time or a date-only value.</short>
        public bool IsDateOnly() {
            return (bool) interceptor.Invoke("isDateOnly", "isDateOnly() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the date part of the date/time. The value returned should be
        ///  interpreted in terms of the instance's time zone or UTC offset.
        /// </remarks>        <return> date value
        /// </return>
        ///         <short>    Returns the date part of the date/time.</short>
        ///         <see> time</see>
        ///         <see> dateTime</see>
        public QDate Date() {
            return (QDate) interceptor.Invoke("date", "date() const", typeof(QDate));
        }
        /// <remarks>
        ///  Returns the time part of the date/time. The value returned should be
        ///  interpreted in terms of the instance's time zone or UTC offset. If
        ///  the instance is date-only, the time returned is 00:00:00.
        /// </remarks>        <return> time value
        /// </return>
        ///         <short>    Returns the time part of the date/time.</short>
        ///         <see> date</see>
        ///         <see> dateTime</see>
        ///         <see> isDateOnly</see>
        public QTime Time() {
            return (QTime) interceptor.Invoke("time", "time() const", typeof(QTime));
        }
        /// <remarks>
        ///  Returns the date/time component of the instance, ignoring the time
        ///  zone. The value returned should be interpreted in terms of the
        ///  instance's time zone or UTC offset. The returned value's <code>timeSpec</code>()
        ///  value will be <code>Qt</code>.UTC if the instance is a UTC time, else
        ///  <code>Qt</code>.LocalTime. If the instance is date-only, the time value is set to
        ///  00:00:00.
        /// </remarks>        <return> date/time
        /// </return>
        ///         <short>    Returns the date/time component of the instance, ignoring the time  zone.</short>
        ///         <see> date</see>
        ///         <see> time</see>
        public QDateTime DateTime() {
            return (QDateTime) interceptor.Invoke("dateTime", "dateTime() const", typeof(QDateTime));
        }
        /// <remarks>
        ///  Returns the time zone for the date/time. If the date/time is specified
        ///  as a UTC time, a UTC time zone is always returned.
        /// </remarks>        <return> time zone, or invalid if a local time at a fixed UTC offset or a
        ///          local clock time
        /// </return>
        ///         <short>    Returns the time zone for the date/time.</short>
        ///         <see> isUtc</see>
        ///         <see> isLocal</see>
        public KTimeZone TimeZone() {
            return (KTimeZone) interceptor.Invoke("timeZone", "timeZone() const", typeof(KTimeZone));
        }
        /// <remarks>
        ///  Returns the time specification of the date/time, i.e. whether it is
        ///  UTC, what time zone it is, etc.
        /// </remarks>        <return> time specification
        /// </return>
        ///         <short>    Returns the time specification of the date/time, i.</short>
        ///         <see> isLocalZone</see>
        ///         <see> isClockTime</see>
        ///         <see> isUtc</see>
        ///         <see> timeZone</see>
        public KDateTime.Spec TimeSpec() {
            return (KDateTime.Spec) interceptor.Invoke("timeSpec", "timeSpec() const", typeof(KDateTime.Spec));
        }
        /// <remarks>
        ///  Returns the time specification type of the date/time, i.e. whether it is
        ///  UTC, has a time zone, etc. If the type is the local time zone,
        ///  <code>TimeZone</code> is returned; use isLocalZone() to check for the local time
        ///  zone.
        /// </remarks>        <return> specification type
        /// </return>
        ///         <short>    Returns the time specification type of the date/time, i.</short>
        ///         <see> timeSpec</see>
        ///         <see> isLocalZone</see>
        ///         <see> isClockTime</see>
        ///         <see> isUtc</see>
        ///         <see> timeZone</see>
        public KDateTime.SpecType TimeType() {
            return (KDateTime.SpecType) interceptor.Invoke("timeType", "timeType() const", typeof(KDateTime.SpecType));
        }
        /// <remarks>
        ///  Returns whether the time zone for the date/time is the current local
        ///  system time zone.
        /// </remarks>        <return> @c true if local system time zone
        /// </return>
        ///         <short>    Returns whether the time zone for the date/time is the current local  system time zone.</short>
        ///         <see> isUtc</see>
        ///         <see> isOffsetFromUtc</see>
        ///         <see> timeZone</see>
        public bool IsLocalZone() {
            return (bool) interceptor.Invoke("isLocalZone", "isLocalZone() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether the date/time is a local clock time.
        /// </remarks>        <return> @c true if local clock time
        /// </return>
        ///         <short>    Returns whether the date/time is a local clock time.</short>
        ///         <see> isUtc</see>
        ///         <see> timeZone</see>
        public bool IsClockTime() {
            return (bool) interceptor.Invoke("isClockTime", "isClockTime() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether the date/time is a UTC time.
        ///  It is considered to be a UTC time if it either has a UTC time
        ///  specification (SpecType == UTC), or has a zero offset from UTC
        ///  (SpecType == OffsetFromUTC with zero UTC offset).
        /// </remarks>        <return> @c true if UTC
        /// </return>
        ///         <short>    Returns whether the date/time is a UTC time.</short>
        ///         <see> isLocal</see>
        ///         <see> isOffsetFromUtc</see>
        ///         <see> timeZone</see>
        public bool IsUtc() {
            return (bool) interceptor.Invoke("isUtc", "isUtc() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether the date/time is a local time at a fixed offset from
        ///  UTC.
        /// </remarks>        <return> @c true if local time at fixed offset from UTC
        /// </return>
        ///         <short>    Returns whether the date/time is a local time at a fixed offset from  UTC.</short>
        ///         <see> isLocal</see>
        ///         <see> isUtc</see>
        ///         <see> utcOffset</see>
        public bool IsOffsetFromUtc() {
            return (bool) interceptor.Invoke("isOffsetFromUtc", "isOffsetFromUtc() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the UTC offset associated with the date/time. The UTC offset is
        ///  the number of seconds to add to UTC to get the local time.
        /// </remarks>        <return> UTC offset in seconds, or 0 if local clock time
        /// </return>
        ///         <short>    Returns the UTC offset associated with the date/time.</short>
        ///         <see> isClockTime</see>
        public int UtcOffset() {
            return (int) interceptor.Invoke("utcOffset", "utcOffset() const", typeof(int));
        }
        /// <remarks>
        ///  Returns whether the date/time is the second occurrence of this time. This
        ///  is only applicable to a date/time expressed in terms of a time zone (type
        ///  <code>TimeZone</code> or <code>LocalZone</code>), around the time of change from daylight
        ///  savings to standard time.
        ///  When a shift from daylight savings time to standard time occurs, the local
        ///  times (typically the previous hour) immediately preceding the shift occur
        ///  twice. For example, if a time shift of 1 hour happens at 03:00, the clock
        ///  jumps backwards to 02:00, so the local times between 02:00:00 and 02:59:59
        ///  occur once before the shift, and again after the shift.
        ///  For instances which are not of type <code>TimeZone</code>, or when the date/time is
        ///  not near to a time shift, <code>false</code> is returned.
        /// </remarks>        <return> @c true if the time is the second occurrence, @c false otherwise
        /// </return>
        ///         <short>    Returns whether the date/time is the second occurrence of this time.</short>
        ///         <see> setSecondOccurrence</see>
        public bool IsSecondOccurrence() {
            return (bool) interceptor.Invoke("isSecondOccurrence", "isSecondOccurrence() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the time converted to UTC. The converted time has a UTC offset
        ///  of zero.
        ///  If the instance is a local clock time, it is first set to the local time
        ///  zone, and then converted to UTC.
        ///  If the instance is a date-only value, a date-only UTC value is returned,
        ///  with the date unchanged.
        /// </remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time converted to UTC.</short>
        ///         <see> toOffsetFromUtc</see>
        ///         <see> toLocalZone</see>
        ///         <see> toZone</see>
        ///         <see> toTimeSpec</see>
        ///         <see> toTime_t</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToUtc() {
            return (KDateTime) interceptor.Invoke("toUtc", "toUtc() const", typeof(KDateTime));
        }
        /// <remarks>
        ///  Returns the time expressed as an offset from UTC, using the UTC offset
        ///  associated with this instance's date/time. The date and time
        ///  components are unchanged. For example, 14:15 on 12 Jan 2001, US Eastern
        ///  time zone would return a KDateTime value of 14:15 on 12 Jan 2001 with a
        ///  UTC offset of -18000 seconds (i.e. -5 hours).
        ///  If the instance is a local clock time, the offset is set to that of the
        ///  local time zone.
        ///  If the instance is a date-only value, the offset is set to that at the
        ///  start of the day.
        /// </remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time expressed as an offset from UTC, using the UTC offset  associated with this instance's date/time.</short>
        ///         <see> toUtc</see>
        ///         <see> toOffsetFromUtc(int)</see>
        ///         <see> toLocalZone</see>
        ///         <see> toZone</see>
        ///         <see> toTimeSpec</see>
        ///         <see> toTime_t</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToOffsetFromUtc() {
            return (KDateTime) interceptor.Invoke("toOffsetFromUtc", "toOffsetFromUtc() const", typeof(KDateTime));
        }
        /// <remarks>
        ///  Returns the time expressed as a specified offset from UTC.
        ///  If the instance is a local clock time, it is first set to the local time
        ///  zone, and then converted to the UTC offset.
        ///  If the instance is a date-only value, a date-only clock time value is
        ///  returned, with the date unchanged.
        /// <param> name="utcOffset" number of seconds to add to UTC to get the local time.
        /// </param></remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time expressed as a specified offset from UTC.</short>
        ///         <see> toUtc</see>
        ///         <see> toOffsetFromUtc</see>
        ///         <see> toLocalZone</see>
        ///         <see> toZone</see>
        ///         <see> toTimeSpec</see>
        ///         <see> toTime_t</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToOffsetFromUtc(int utcOffset) {
            return (KDateTime) interceptor.Invoke("toOffsetFromUtc$", "toOffsetFromUtc(int) const", typeof(KDateTime), typeof(int), utcOffset);
        }
        /// <remarks>
        ///  Returns the time converted to the current local system time zone.
        ///  If the instance is a date-only value, a date-only local time zone value
        ///  is returned, with the date unchanged.
        /// </remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time converted to the current local system time zone.</short>
        ///         <see> toUtc</see>
        ///         <see> toOffsetFromUtc</see>
        ///         <see> toZone</see>
        ///         <see> toTimeSpec</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToLocalZone() {
            return (KDateTime) interceptor.Invoke("toLocalZone", "toLocalZone() const", typeof(KDateTime));
        }
        /// <remarks>
        ///  Returns the time converted to the local clock time. The time is first
        ///  converted to the local system time zone before setting its type to
        ///  ClockTime, i.e. no associated time zone.
        ///  If the instance is a date-only value, a date-only clock time value is
        ///  returned, with the date unchanged.
        /// </remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time converted to the local clock time.</short>
        ///         <see> toLocalZone</see>
        ///         <see> toTimeSpec</see>
        public KDateTime ToClockTime() {
            return (KDateTime) interceptor.Invoke("toClockTime", "toClockTime() const", typeof(KDateTime));
        }
        /// <remarks>
        ///  Returns the time converted to a specified time zone.
        ///  If the instance is a local clock time, it is first set to the local time
        ///  zone, and then converted to <code>zone.</code>
        ///  If the instance is a date-only value, a date-only value in <code>zone</code> is
        ///  returned, with the date unchanged.
        /// <param> name="zone" time zone to convert to
        /// </param></remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time converted to a specified time zone.</short>
        ///         <see> toUtc</see>
        ///         <see> toOffsetFromUtc</see>
        ///         <see> toLocalZone</see>
        ///         <see> toTimeSpec</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToZone(KTimeZone zone) {
            return (KDateTime) interceptor.Invoke("toZone#", "toZone(const KTimeZone&) const", typeof(KDateTime), typeof(KTimeZone), zone);
        }
        /// <remarks>
        ///  Returns the time converted to a new time specification.
        ///  If the instance is a local clock time, it is first set to the local time
        ///  zone, and then converted to the <code>spec</code> time specification.
        ///  If the instance is a date-only value, a date-only value is returned,
        ///  with the date unchanged.
        /// <param> name="spec" new time specification
        /// </param></remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time converted to a new time specification.</short>
        ///         <see> toLocalZone</see>
        ///         <see> toUtc</see>
        ///         <see> toOffsetFromUtc</see>
        ///         <see> toZone</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToTimeSpec(KDateTime.Spec spec) {
            return (KDateTime) interceptor.Invoke("toTimeSpec#", "toTimeSpec(const KDateTime::Spec&) const", typeof(KDateTime), typeof(KDateTime.Spec), spec);
        }
        /// <remarks>
        ///  Returns the time converted to the time specification of another instance.
        ///  If this instance is a local clock time, it is first set to the local time
        ///  zone, and then converted to the <code>spec</code> time specification.
        ///  If this instance is a date-only value, a date-only value is returned,
        ///  with the date unchanged.
        /// <param> name="dt" instance providing the new time specification
        /// </param></remarks>        <return> converted time
        /// </return>
        ///         <short>    Returns the time converted to the time specification of another instance.</short>
        ///         <see> toLocalZone</see>
        ///         <see> toUtc</see>
        ///         <see> toOffsetFromUtc</see>
        ///         <see> toZone</see>
        ///         <see> KTimeZone.Convert</see>
        public KDateTime ToTimeSpec(KDateTime dt) {
            return (KDateTime) interceptor.Invoke("toTimeSpec#", "toTimeSpec(const KDateTime&) const", typeof(KDateTime), typeof(KDateTime), dt);
        }
        /// <remarks>
        ///  Converts the time to a UTC time, measured in seconds since 00:00:00 UTC
        ///  1st January 1970 (as returned by time(2)).
        /// </remarks>        <return> converted time, or @c uint(-1) if the date is out of range or invalid
        /// </return>
        ///         <short>    Converts the time to a UTC time, measured in seconds since 00:00:00 UTC  1st January 1970 (as returned by time(2)).</short>
        ///         <see> setTime_t</see>
        public uint ToTime_t() {
            return (uint) interceptor.Invoke("toTime_t", "toTime_t() const", typeof(uint));
        }
        /// <remarks>
        ///  Sets the time to a UTC time, specified as seconds since 00:00:00 UTC
        ///  1st January 1970 (as returned by time(2)).
        /// <param> name="seconds" number of seconds since 00:00:00 UTC 1st January 1970
        /// </param></remarks>        <short>    Sets the time to a UTC time, specified as seconds since 00:00:00 UTC  1st January 1970 (as returned by time(2)).</short>
        ///         <see> toTime_t</see>
        public void SetTime_t(long seconds) {
            interceptor.Invoke("setTime_t$", "setTime_t(qint64)", typeof(void), typeof(long), seconds);
        }
        /// <remarks>
        ///  Sets the instance either to being a date and time value, or a date-only
        ///  value. If its status is changed to date-only, its time is set to
        ///  00:00:00.
        /// <param> name="dateOnly" <code>true</code> to set to date-only, <code>false</code> to set to date
        ///                  and time.
        /// </param></remarks>        <short>    Sets the instance either to being a date and time value, or a date-only  value.</short>
        ///         <see> isDateOnly</see>
        ///         <see> setTime</see>
        public void SetDateOnly(bool dateOnly) {
            interceptor.Invoke("setDateOnly$", "setDateOnly(bool)", typeof(void), typeof(bool), dateOnly);
        }
        /// <remarks>
        ///  Sets the date part of the date/time.
        /// <param> name="date" new date value
        /// </param></remarks>        <short>    Sets the date part of the date/time.</short>
        ///         <see> date</see>
        ///         <see> setTime</see>
        ///         <see> setTimeSpec</see>
        ///         <see> setTime_t</see>
        ///         <see> setDateOnly</see>
        public void SetDate(QDate date) {
            interceptor.Invoke("setDate#", "setDate(const QDate&)", typeof(void), typeof(QDate), date);
        }
        /// <remarks>
        ///  Sets the time part of the date/time. If the instance was date-only, it
        ///  is changed to being a date and time value.
        /// <param> name="time" new time value
        /// </param></remarks>        <short>    Sets the time part of the date/time.</short>
        ///         <see> time</see>
        ///         <see> setDate</see>
        ///         <see> setTimeSpec</see>
        ///         <see> setTime_t</see>
        public void SetTime(QTime time) {
            interceptor.Invoke("setTime#", "setTime(const QTime&)", typeof(void), typeof(QTime), time);
        }
        /// <remarks>
        ///  Sets the date/time part of the instance, leaving the time specification
        ///  unaffected.
        ///  If <code>dt</code> is a local time (<pre> dt.timeSpec() == Qt.LocalTime </pre>)
        ///  and the instance is UTC, <code>dt</code> is first converted from the current
        ///  system time zone to UTC before being stored.
        ///  If the instance was date-only, it is changed to being a date and time
        ///  value.
        /// <param> name="dt" date and time
        /// </param></remarks>        <short>    Sets the date/time part of the instance, leaving the time specification  unaffected.</short>
        ///         <see> dateTime</see>
        ///         <see> setDate</see>
        ///         <see> setTime</see>
        ///         <see> setTimeSpec</see>
        public void SetDateTime(QDateTime dt) {
            interceptor.Invoke("setDateTime#", "setDateTime(const QDateTime&)", typeof(void), typeof(QDateTime), dt);
        }
        /// <remarks>
        ///  Changes the time specification of the instance.
        ///  Any previous time zone is forgotten. The stored date/time component of
        ///  the instance is left unchanged (except that its UTC/local time setting
        ///  is set to correspond with <code>spec</code>). Usually this method will change the
        ///  absolute time which this instance represents.
        /// <param> name="spec" new time specification
        /// </param></remarks>        <short>    Changes the time specification of the instance.</short>
        ///         <see> timeSpec</see>
        ///         <see> timeZone</see>
        public void SetTimeSpec(KDateTime.Spec spec) {
            interceptor.Invoke("setTimeSpec#", "setTimeSpec(const KDateTime::Spec&)", typeof(void), typeof(KDateTime.Spec), spec);
        }
        /// <remarks>
        ///  Sets whether the date/time is the second occurrence of this time. This
        ///  is only applicable to a date/time expressed in terms of a time zone (type
        ///  <code>TimeZone</code> or <code>LocalZone</code>), around the time of change from daylight
        ///  savings to standard time.
        ///  When a shift from daylight savings time to standard time occurs, the local
        ///  times (typically the previous hour) immediately preceding the shift occur
        ///  twice. For example, if a time shift of 1 hour happens at 03:00, the clock
        ///  jumps backwards to 02:00, so the local times between 02:00:00 and 02:59:59
        ///  occur once before the shift, and again after the shift.
        ///  For instances which are not of type <code>TimeZone</code>, or when the date/time is
        ///  not near to a time shift, calling this method has no effect.
        ///  Note that most other setting methods clear the second occurrence indicator,
        ///  so if you want to retain its setting, you must call setSecondOccurrence()
        ///  again after changing the instance's value.
        /// <param> name="second" <code>true</code> to set as the second occurrence, <code>false</code> to set as
        ///                the first occurrence
        /// </param></remarks>        <short>    Sets whether the date/time is the second occurrence of this time.</short>
        ///         <see> isSecondOccurrence</see>
        public void SetSecondOccurrence(bool second) {
            interceptor.Invoke("setSecondOccurrence$", "setSecondOccurrence(bool)", typeof(void), typeof(bool), second);
        }
        /// <remarks>
        ///  Returns a date/time <code>msecs</code> milliseconds later than the stored date/time.
        ///  Except when the instance is a local clock time (type <code>ClockTime</code>), the
        ///  calculation is done in UTC to ensure that the result takes proper account
        ///  of clock changes (e.g. daylight savings) in the time zone. The result is
        ///  expressed using the same time specification as the original instance.
        ///  Note that if the instance is a local clock time (type <code>ClockTime</code>), any
        ///  daylight savings changes or time zone changes during the period will
        ///  render the result inaccurate.
        ///  If the instance is date-only, <code>msecs</code> is rounded down to a whole number
        ///  of days and that value is added to the date to find the result.
        /// </remarks>        <return> resultant date/time
        /// </return>
        ///         <short>    Returns a date/time <code>msecs</code> milliseconds later than the stored date/time.</short>
        ///         <see> addSecs</see>
        ///         <see> addDays</see>
        ///         <see> addMonths</see>
        ///         <see> addYears</see>
        ///         <see> secsTo</see>
        public KDateTime AddMSecs(long msecs) {
            return (KDateTime) interceptor.Invoke("addMSecs$", "addMSecs(qint64) const", typeof(KDateTime), typeof(long), msecs);
        }
        /// <remarks>
        ///  Returns a date/time <code>secs</code> seconds later than the stored date/time.
        ///  Except when the instance is a local clock time (type <code>ClockTime</code>), the
        ///  calculation is done in UTC to ensure that the result takes proper account
        ///  of clock changes (e.g. daylight savings) in the time zone. The result is
        ///  expressed using the same time specification as the original instance.
        ///  Note that if the instance is a local clock time (type <code>ClockTime</code>), any
        ///  daylight savings changes or time zone changes during the period will
        ///  render the result inaccurate.
        ///  If the instance is date-only, <code>secs</code> is rounded down to a whole number
        ///  of days and that value is added to the date to find the result.
        /// </remarks>        <return> resultant date/time
        /// </return>
        ///         <short>    Returns a date/time <code>secs</code> seconds later than the stored date/time.</short>
        ///         <see> addMSecs</see>
        ///         <see> addDays</see>
        ///         <see> addMonths</see>
        ///         <see> addYears</see>
        ///         <see> secsTo</see>
        public KDateTime AddSecs(long secs) {
            return (KDateTime) interceptor.Invoke("addSecs$", "addSecs(qint64) const", typeof(KDateTime), typeof(long), secs);
        }
        /// <remarks>
        ///  Returns a date/time <code>days</code> days later than the stored date/time.
        ///  The result is expressed using the same time specification as the
        ///  original instance.
        ///  Note that if the instance is a local clock time (type <code>ClockTime</code>), any
        ///  daylight savings changes or time zone changes during the period may
        ///  render the result inaccurate.
        /// </remarks>        <return> resultant date/time
        /// </return>
        ///         <short>    Returns a date/time <code>days</code> days later than the stored date/time.</short>
        ///         <see> addSecs</see>
        ///         <see> addMonths</see>
        ///         <see> addYears</see>
        ///         <see> daysTo</see>
        public KDateTime AddDays(int days) {
            return (KDateTime) interceptor.Invoke("addDays$", "addDays(int) const", typeof(KDateTime), typeof(int), days);
        }
        /// <remarks>
        ///  Returns a date/time <code>months</code> months later than the stored date/time.
        ///  The result is expressed using the same time specification as the
        ///  original instance.
        ///  Note that if the instance is a local clock time (type <code>ClockTime</code>), any
        ///  daylight savings changes or time zone changes during the period may
        ///  render the result inaccurate.
        /// </remarks>        <return> resultant date/time
        /// </return>
        ///         <short>    Returns a date/time <code>months</code> months later than the stored date/time.</short>
        ///         <see> addSecs</see>
        ///         <see> addDays</see>
        ///         <see> addYears</see>
        ///         <see> daysTo</see>
        public KDateTime AddMonths(int months) {
            return (KDateTime) interceptor.Invoke("addMonths$", "addMonths(int) const", typeof(KDateTime), typeof(int), months);
        }
        /// <remarks>
        ///  Returns a date/time <code>years</code> years later than the stored date/time.
        ///  The result is expressed using the same time specification as the
        ///  original instance.
        ///  Note that if the instance is a local clock time (type <code>ClockTime</code>), any
        ///  daylight savings changes or time zone changes during the period may
        ///  render the result inaccurate.
        /// </remarks>        <return> resultant date/time
        /// </return>
        ///         <short>    Returns a date/time <code>years</code> years later than the stored date/time.</short>
        ///         <see> addSecs</see>
        ///         <see> addDays</see>
        ///         <see> addMonths</see>
        ///         <see> daysTo</see>
        public KDateTime AddYears(int years) {
            return (KDateTime) interceptor.Invoke("addYears$", "addYears(int) const", typeof(KDateTime), typeof(int), years);
        }
        /// <remarks>
        ///  Returns the number of seconds from this date/time to the <code>other</code> date/time.
        ///  Before performing the comparison, the two date/times are converted to UTC
        ///  to ensure that the result is correct if one of the two date/times has
        ///  daylight saving time (DST) and the other doesn't. The exception is when
        ///  both instances are local clock time, in which case no conversion to UTC
        ///  is done.
        ///  Note that if either instance is a local clock time (type <code>ClockTime</code>),
        ///  the result cannot be guaranteed to be accurate, since by definition they
        ///  contain no information about time zones or daylight savings changes.
        ///  If one instance is date-only and the other is date-time, the date-time
        ///  value is first converted to the same time specification as the date-only
        ///  value, and the result is the difference in days between the resultant
        ///  date and the date-only date.
        ///  If both instances are date-only, the result is the difference in days
        ///  between the two dates, ignoring time zones.
        /// <param> name="other" other date/time
        /// </param></remarks>        <return> number of seconds difference
        /// </return>
        ///         <short>    Returns the number of seconds from this date/time to the <code>other</code> date/time.</short>
        ///         <see> secsTo_long</see>
        ///         <see> addSecs</see>
        ///         <see> daysTo</see>
        public int SecsTo(KDateTime other) {
            return (int) interceptor.Invoke("secsTo#", "secsTo(const KDateTime&) const", typeof(int), typeof(KDateTime), other);
        }
        /// <remarks>
        ///  Returns the number of seconds from this date/time to the <code>other</code> date/time.
        ///  Before performing the comparison, the two date/times are converted to UTC
        ///  to ensure that the result is correct if one of the two date/times has
        ///  daylight saving time (DST) and the other doesn't. The exception is when
        ///  both instances are local clock time, in which case no conversion to UTC
        ///  is done.
        ///  Note that if either instance is a local clock time (type <code>ClockTime</code>),
        ///  the result cannot be guaranteed to be accurate, since by definition they
        ///  contain no information about time zones or daylight savings changes.
        ///  If one instance is date-only and the other is date-time, the date-time
        ///  value is first converted to the same time specification as the date-only
        ///  value, and the result is the difference in days between the resultant
        ///  date and the date-only date.
        ///  If both instances are date-only, the result is the difference in days
        ///  between the two dates, ignoring time zones.
        /// <param> name="other" other date/time
        /// </param></remarks>        <return> number of seconds difference
        /// </return>
        ///         <short>    Returns the number of seconds from this date/time to the <code>other</code> date/time.</short>
        ///         <see> secsTo</see>
        ///         <see> addSecs</see>
        ///         <see> daysTo</see>
        public long SecsTo_long(KDateTime other) {
            return (long) interceptor.Invoke("secsTo_long#", "secsTo_long(const KDateTime&) const", typeof(long), typeof(KDateTime), other);
        }
        /// <remarks>
        ///  Calculates the number of days from this date/time to the <code>other</code> date/time.
        ///  In calculating the result, <code>other</code> is first converted to this instance's
        ///  time zone. The number of days difference is then calculated ignoring
        ///  the time parts of the two date/times. For example, if this date/time
        ///  was 13:00 on 1 January 2000, and <code>other</code> was 02:00 on 2 January 2000,
        ///  the result would be 1.
        ///  Note that if either instance is a local clock time (type <code>ClockTime</code>),
        ///  the result cannot be guaranteed to be accurate, since by definition they
        ///  contain no information about time zones or daylight savings changes.
        ///  If one instance is date-only and the other is date-time, the date-time
        ///  value is first converted to the same time specification as the date-only
        ///  value, and the result is the difference in days between the resultant
        ///  date and the date-only date.
        ///  If both instances are date-only, the calculation ignores time zones.
        /// <param> name="other" other date/time
        /// </param></remarks>        <return> number of days difference
        /// </return>
        ///         <short>    Calculates the number of days from this date/time to the <code>other</code> date/time.</short>
        ///         <see> secsTo</see>
        ///         <see> addDays</see>
        public int DaysTo(KDateTime other) {
            return (int) interceptor.Invoke("daysTo#", "daysTo(const KDateTime&) const", typeof(int), typeof(KDateTime), other);
        }
        /// <remarks>
        ///  Returns the date/time as a string. The <code>format</code> parameter determines the
        ///  format of the result string. The <code>format</code> codes used for the date and time
        ///  components follow those used elsewhere in KDE, and are similar but not
        ///  identical to those used by strftime(3). Conversion specifiers are
        ///  introduced by a '%' character, and are replaced in <code>format</code> as follows:
        ///  <b></b>ate
        ///  - %y   2-digit year excluding century (00 - 99). Conversion is undefined
        ///         if year < 0.
        ///  - %Y   full year number
        ///  - %:m  month number, without leading zero (1 - 12)
        ///  - %m   month number, 2 digits (01 - 12)
        ///  - %b   abbreviated month name in current locale
        ///  - %B   full month name in current locale
        ///  - %:b  abbreviated month name in English (Jan, Feb, ...)
        ///  - %:B  full month name in English
        ///  - %e   day of the month (1 - 31)
        ///  - %d   day of the month, 2 digits (01 - 31)
        ///  - %a   abbreviated weekday name in current locale
        ///  - %A   full weekday name in current locale
        ///  - %:a  abbreviated weekday name in English (Mon, Tue, ...)
        ///  - %:A  full weekday name in English
        ///  <b></b>ime
        ///  - %H   hour in the 24 hour clock, 2 digits (00 - 23)
        ///  - %k   hour in the 24 hour clock, without leading zero (0 - 23)
        ///  - %I   hour in the 12 hour clock, 2 digits (01 - 12)
        ///  - %l   hour in the 12 hour clock, without leading zero (1 - 12)
        ///  - %M   minute, 2 digits (00 - 59)
        ///  - %S   seconds (00 - 59)
        ///  - %:S  seconds preceded with ':', but omitted if seconds value is zero
        ///  - %:s  milliseconds, 3 digits (000 - 999)
        ///  - %P   "am" or "pm" in the current locale, or if undefined there, in English
        ///  - %p   "AM" or "PM" in the current locale, or if undefined there, in English
        ///  - %:P  "am" or "pm"
        ///  - %:p  "AM" or "PM"
        ///  <b></b>ime zone
        ///  - %:u  UTC offset of the time zone in hours, e.g. -02. If the offset
        ///         is not a whole number of hours, the output is the same as for '%U'.
        ///  - %z   UTC offset of the time zone in hours and minutes, e.g. -0200.
        ///  - %:z  UTC offset of the time zone in hours and minutes, e.g. +02:00.
        ///  - %Z   time zone abbreviation, e.g. UTC, EDT, GMT. This is not guaranteed
        ///         to be unique among different time zones. If not applicable (i.e. if
        ///         the instance is type OffsetFromUTC), the UTC offset is substituted.
        ///  - %:Z  time zone name, e.g. Europe/London. This is system dependent. If
        ///         not applicable (i.e. if the instance is type OffsetFromUTC), the
        ///         UTC offset is substituted.
        ///  <b></b>ther
        ///  - %%   literal '%' character
        ///  Note that if the instance has a time specification of ClockTime, the
        ///  time zone or UTC offset in the result will be blank.
        ///  If you want to use the current locale's date format, you should call
        ///  KLocale.FormatDate() to format the date part of the KDateTime.
        /// <param> name="format" format for the string
        /// </param></remarks>        <return> formatted string
        /// </return>
        ///         <short>    Returns the date/time as a string.</short>
        ///         <see> fromString</see>
        ///         <see> KLocale.FormatDate</see>
        public string ToString(string format) {
            return (string) interceptor.Invoke("toString$", "toString(const QString&) const", typeof(string), typeof(string), format);
        }
        /// <remarks>
        ///  Returns the date/time as a string, formatted according to the <code>format</code>
        ///  parameter, with the UTC offset appended.
        ///  Note that if the instance has a time specification of ClockTime, the UTC
        ///  offset in the result will be blank, except for RFC 2822 format in which
        ///  it will be the offset for the local system time zone.
        ///  If the instance is date-only, the time will when <code>format</code> permits be
        ///  omitted from the output string. This applies to <code>format</code> = QtTextDate
        ///  or LocalDate. It also applies to <code>format</code> = ISODate when the instance
        ///  has a time specification of ClockTime. For all other cases, a time of
        ///  00:00:00 will be output.
        ///  For RFC 2822 format, set <code>format</code> to RFCDateDay to include the day
        ///  of the week, or to RFCDate to omit it.
        /// <param> name="format" format for output string
        /// </param></remarks>        <return> formatted string
        /// </return>
        ///         <short>    Returns the date/time as a string, formatted according to the <code>format</code>  parameter, with the UTC offset appended.</short>
        ///         <see> fromString</see>
        ///         <see> QDateTime.ToString</see>
        public string ToString(KDateTime.TimeFormat format) {
            return (string) interceptor.Invoke("toString$", "toString(KDateTime::TimeFormat) const", typeof(string), typeof(KDateTime.TimeFormat), format);
        }
        public new string ToString() {
            return (string) interceptor.Invoke("toString", "toString() const", typeof(string));
        }
        /// <remarks>
        ///  Checks whether the date/time returned by the last call to fromString()
        ///  was invalid because an otherwise valid date was outside the range which
        ///  can be represented by QDate. This status occurs when fromString() read
        ///  a valid string containing a year earlier than -4712 (4713 BC). On exit
        ///  from fromString(), if outOfRange() returns <code>true</code>, isValid() will
        ///  return <code>false.</code>
        /// </remarks>        <return> @c true if date was earlier than -4712, else @c false
        /// </return>
        ///         <short>    Checks whether the date/time returned by the last call to fromString()  was invalid because an otherwise valid date was outside the range which  can be represented by QDate.</short>
        ///         <see> isValid</see>
        ///         <see> fromString</see>
        public bool OutOfRange() {
            return (bool) interceptor.Invoke("outOfRange", "outOfRange() const", typeof(bool));
        }
        /// <remarks>
        ///  Compare this instance with another to determine whether they are
        ///  simultaneous, earlier or later, and in the case of date-only values,
        ///  whether they overlap (i.e. partly coincide but are not wholly
        ///  simultaneous).
        ///  The comparison takes time zones into account: if the two instances have
        ///  different time zones, they are first converted to UTC before comparing.
        ///  If both instances are date/time values, this instance is considered to
        ///  be either simultaneous, earlier or later, and does not overlap.
        ///  If one instance is date-only and the other is a date/time, this instance
        ///  is either strictly earlier, strictly later, or overlaps.
        ///  If both instance are date-only, they are considered simultaneous if both
        ///  their start of day and end of day times are simultaneous with each
        ///  other. (Both start and end of day times need to be considered in case a
        ///  daylight savings change occurs during that day.) Otherwise, this instance
        ///  can be strictly earlier, earlier but overlapping, later but overlapping,
        ///  or strictly later.
        ///  Note that if either instance is a local clock time (type <code>ClockTime</code>),
        ///  the result cannot be guaranteed to be correct, since by definition they
        ///  contain no information about time zones or daylight savings changes.
        /// </remarks>        <return> @c true if the two instances represent the same time, @c false otherwise
        /// </return>
        ///         <short>    Compare this instance with another to determine whether they are  simultaneous, earlier or later, and in the case of date-only values,  whether they overlap (i.</short>
        ///         <see> operator==</see>
        ///         <see> operator!=</see>
        ///         <see> operator<</see>
        ///         <see> operator<=</see>
        ///         <see> operator>=</see>
        ///         <see> operator></see>
        public KDateTime.Comparison Compare(KDateTime other) {
            return (KDateTime.Comparison) interceptor.Invoke("compare#", "compare(const KDateTime&) const", typeof(KDateTime.Comparison), typeof(KDateTime), other);
        }
        /// <remarks>
        ///  Check whether this date/time is simultaneous with another.
        ///  The comparison takes time zones into account: if the two instances have
        ///  different time zones, they are first converted to UTC before comparing.
        ///  Note that if either instance is a local clock time (type <code>ClockTime</code>),
        ///  the result cannot be guaranteed to be correct, since by definition they
        ///  contain no information about time zones or daylight savings changes.
        ///  If both instances are date-only, they are considered simultaneous if both
        ///  their start of day and end of day times are simultaneous with each
        ///  other. (Both start and end of day times need to be considered in case a
        ///  daylight saving change occurs during that day.)
        /// </remarks>        <return> @c true if the two instances represent the same time, @c false otherwise
        /// </return>
        ///         <short>    Check whether this date/time is simultaneous with another.</short>
        ///         <see> compare</see>
        public override bool Equals(object o) {
            if (!(o is KDateTime)) { return false; }
            return this == (KDateTime) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Check whether this date/time is earlier than another.
        ///  The comparison takes time zones into account: if the two instances have
        ///  different time zones, they are first converted to UTC before comparing.
        ///  Note that if either instance is a local clock time (type <code>ClockTime</code>),
        ///  the result cannot be guaranteed to be correct, since by definition they
        ///  contain no information about time zones or daylight savings changes.
        ///  If one or both instances are date-only, the comparison returns true if
        ///  this date/time or day, falls wholly before the other date/time or
        ///  day. To achieve this, the time used in the comparison is the end of day
        ///  (if this instance is date-only) or the start of day (if the other
        ///  instance is date-only).
        /// </remarks>        <return> @c true if this instance represents an earlier time than <code>other</code>,
        ///          @c false otherwise
        /// </return>
        ///         <short>    Check whether this date/time is earlier than another.</short>
        ///         <see> compare</see>
        /// <remarks>
        ///  Create a separate copy of this instance's data if it is implicitly shared
        ///  with another instance.
        ///  You would normally only call this if you want different copies of the
        ///  same date/time value to cache conversions to different time zones. Because
        ///  only the last conversion to another time zone is cached, and the cached
        ///  value is implicitly shared, judicious use of detach() could improve
        ///  efficiency when handling several time zones. But take care: if used
        ///  inappropriately, it will reduce efficiency!
        ///      </remarks>        <short>    Create a separate copy of this instance's data if it is implicitly shared  with another instance.</short>
        public void Detach() {
            interceptor.Invoke("detach", "detach()", typeof(void));
        }
        ~KDateTime() {
            interceptor.Invoke("~KDateTime", "~KDateTime()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KDateTime", "~KDateTime()", typeof(void));
        }
        public static bool operator==(KDateTime lhs, KDateTime other) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const KDateTime&) const", typeof(bool), typeof(KDateTime), lhs, typeof(KDateTime), other);
        }
        public static bool operator!=(KDateTime lhs, KDateTime other) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const KDateTime&) const", typeof(bool), typeof(KDateTime), lhs, typeof(KDateTime), other);
        }
        public static bool operator<(KDateTime lhs, KDateTime other) {
            return (bool) staticInterceptor.Invoke("operator<#", "operator<(const KDateTime&) const", typeof(bool), typeof(KDateTime), lhs, typeof(KDateTime), other);
        }
        public static bool operator<=(KDateTime lhs, KDateTime other) {
            return (bool) staticInterceptor.Invoke("operator<=#", "operator<=(const KDateTime&) const", typeof(bool), typeof(KDateTime), lhs, typeof(KDateTime), other);
        }
        public static bool operator>(KDateTime lhs, KDateTime other) {
            return (bool) staticInterceptor.Invoke("operator>#", "operator>(const KDateTime&) const", typeof(bool), typeof(KDateTime), lhs, typeof(KDateTime), other);
        }
        public static bool operator>=(KDateTime lhs, KDateTime other) {
            return (bool) staticInterceptor.Invoke("operator>=#", "operator>=(const KDateTime&) const", typeof(bool), typeof(KDateTime), lhs, typeof(KDateTime), other);
        }
        /// <remarks>
        ///  Returns the current date and time, as reported by the system clock,
        ///  expressed in the local system time zone.
        /// </remarks>        <return> current date/time
        /// </return>
        ///         <short>    Returns the current date and time, as reported by the system clock,  expressed in the local system time zone.</short>
        ///         <see> currentUtcDateTime</see>
        ///         <see> currentDateTime</see>
        public static KDateTime CurrentLocalDateTime() {
            return (KDateTime) staticInterceptor.Invoke("currentLocalDateTime", "currentLocalDateTime()", typeof(KDateTime));
        }
        /// <remarks>
        ///  Returns the current date and time, as reported by the system clock,
        ///  expressed in UTC.
        /// </remarks>        <return> current date/time
        /// </return>
        ///         <short>    Returns the current date and time, as reported by the system clock,  expressed in UTC.</short>
        ///         <see> currentLocalDateTime</see>
        ///         <see> currentDateTime</see>
        public static KDateTime CurrentUtcDateTime() {
            return (KDateTime) staticInterceptor.Invoke("currentUtcDateTime", "currentUtcDateTime()", typeof(KDateTime));
        }
        /// <remarks>
        ///  Returns the current date and time, as reported by the system clock,
        ///  expressed in a given time specification.
        /// <param> name="spec" time specification
        /// </param></remarks>        <return> current date/time
        /// </return>
        ///         <short>    Returns the current date and time, as reported by the system clock,  expressed in a given time specification.</short>
        ///         <see> currentUtcDateTime</see>
        ///         <see> currentLocalDateTime</see>
        public static KDateTime CurrentDateTime(KDateTime.Spec spec) {
            return (KDateTime) staticInterceptor.Invoke("currentDateTime#", "currentDateTime(const KDateTime::Spec&)", typeof(KDateTime), typeof(KDateTime.Spec), spec);
        }
        /// <remarks>
        ///  Returns the KDateTime represented by <code>string</code>, using the <code>format</code> given.
        ///  This method is the inverse of <see cref="#toString"></see>, except that it can
        ///  only return a time specification of UTC, OffsetFromUTC or ClockTime. An
        ///  actual named time zone cannot be returned since an offset from UTC only
        ///  partially specifies a time zone.
        ///  The time specification of the result is determined by the UTC offset
        ///  present in the string:
        ///  - if the UTC offset is zero the result is type <code>UTC.</code>
        ///  - if the UTC offset is non-zero, the result is type <code>OffsetFromUTC.</code>
        ///  - if there is no UTC offset, the result is by default type
        ///    <code>ClockTime.</code> You can use setFromStringDefault() to change this default.
        ///  If no time is found in <code>string</code>, a date-only value is returned, except
        ///  when the specified <code>format</code> does not permit the time to be omitted, in
        ///  which case an error is returned. An error is therefore returned for
        ///  ISODate when <code>string</code> includes a time zone specification, and for
        ///  RFCDate in all cases.
        ///  For RFC format strings, you should normally set <code>format</code> to
        ///  RFCDate. Only set it to RFCDateDay if you want to return an error
        ///  when the day of the week is omitted.
        ///  For <code>format</code> = ISODate or RFCDate[Day], if an invalid KDateTime is
        ///  returned, you can check why <code>format</code> was considered invalid by use of
        ///  outOfRange(). If that method returns true, it indicates that <code>format</code>
        ///  was in fact valid, but the date lies outside the range which can be
        ///  represented by QDate.
        /// <param> name="string" string to convert
        /// </param><param> name="format" format code. LocalDate cannot be used here.
        /// </param><param> name="negZero" if non-null, the value is set to true if a UTC offset of
        ///                 '-0000' is found or, for RFC 2822 format, an unrecognised
        ///                 or invalid time zone abbreviation is found, else false.
        /// </param></remarks>        <return> KDateTime value, or an invalid KDateTime if either parameter is invalid
        /// </return>
        ///         <short>    Returns the KDateTime represented by <code>string</code>, using the <code>format</code> given.</short>
        ///         <see> setFromStringDefault</see>
        ///         <see> toString</see>
        ///         <see> outOfRange</see>
        public static KDateTime FromString(string arg1, KDateTime.TimeFormat format, ref bool negZero) {
            StackItem[] stack = new StackItem[4];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(arg1);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(arg1);
#endif
            stack[2].s_int = (int) format;
            stack[3].s_bool = negZero;
            staticInterceptor.Invoke("fromString$$$", "fromString(const QString&, KDateTime::TimeFormat, bool*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).SynchronizedFree();
#endif
            negZero = stack[3].s_bool;
            object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
            ((GCHandle) stack[0].s_class).SynchronizedFree();
#endif
            return (KDateTime) returnValue;
        }
        public static KDateTime FromString(string arg1, KDateTime.TimeFormat format) {
            return (KDateTime) staticInterceptor.Invoke("fromString$$", "fromString(const QString&, KDateTime::TimeFormat)", typeof(KDateTime), typeof(string), arg1, typeof(KDateTime.TimeFormat), format);
        }
        public static KDateTime FromString(string arg1) {
            return (KDateTime) staticInterceptor.Invoke("fromString$", "fromString(const QString&)", typeof(KDateTime), typeof(string), arg1);
        }
        /// <remarks>
        ///  Returns the KDateTime represented by <code>string</code>, using the <code>format</code>
        ///  given, optionally using a time zone collection <code>zones</code> as the source of
        ///  time zone definitions. The <code>format</code> codes are basically the same as
        ///  those for toString(), and are similar but not identical to those used by
        ///  strftime(3).
        ///  The <code>format</code> string consists of the same codes as that for
        ///  toString(). However, some codes which are distinct in toString() have
        ///  the same function as each other here.
        ///  Numeric values without a stated number of digits permit, but do not
        ///  require, leading zeroes. The maximum number of digits consumed by a
        ///  numeric code is the minimum needed to cover the possible range of the
        ///  number (e.g. for minutes, the range is 0 - 59, so the maximum number of
        ///  digits consumed is 2). All non-numeric values are case insensitive.
        ///  <b></b>ate
        ///  - %y   year excluding century (0 - 99). Years 0 - 50 return 2000 - 2050,
        ///         while years 51 - 99 return 1951 - 1999.
        ///  - %Y   full year number (4 digits with optional sign)
        ///  - %:Y  full year number (>= 4 digits with optional sign)
        ///  - %:m  month number (1 - 12)
        ///  - %m   month number, 2 digits (01 - 12)
        ///  - %b
        ///  - %B   month name in the current locale or, if no match, in English,
        ///         abbreviated or in full
        ///  - %:b
        ///  - %:B  month name in English, abbreviated or in full
        ///  - %e   day of the month (1 - 31)
        ///  - %d   day of the month, 2 digits (01 - 31)
        ///  - %a
        ///  - %A   weekday name in the current locale or, if no match, in English,
        ///         abbreviated or in full
        ///  - %:a
        ///  - %:A  weekday name in English, abbreviated or in full
        ///  <b></b>ime
        ///  - %H   hour in the 24 hour clock, 2 digits (00 - 23)
        ///  - %k   hour in the 24 hour clock (0 - 23)
        ///  - %I   hour in the 12 hour clock, 2 digits (01 - 12)
        ///  - %l   hour in the 12 hour clock (1 - 12)
        ///  - %M   minute, 2 digits (00 - 59)
        ///  - %:M  minute (0 - 59)
        ///  - %S   seconds, 2 digits (00 - 59)
        ///  - %s   seconds (0 - 59)
        ///  - %:S  optional seconds value (0 - 59) preceded with ':'. If no colon is
        ///         found in <code>string</code>, no input is consumed and the seconds value is
        ///         set to zero.
        ///  - %:s  fractional seconds value, preceded with a decimal point (either '.'
        ///         or the locale's decimal point symbol)
        ///  - %P
        ///  - %p   "am" or "pm", in the current locale or, if no match, in
        ///         English. This format is only useful when used with %I or %l.
        ///  - %:P
        ///  - %:p  "am" or "pm" in English. This format is only useful when used with
        ///         %I or %l.
        ///  <b></b>ime zone
        ///  - %:u
        ///  - %z   UTC offset of the time zone in hours and optionally minutes,
        ///         e.g. -02, -0200.
        ///  - %:z  UTC offset of the time zone in hours and minutes, colon separated,
        ///         e.g. +02:00.
        ///  - %Z   time zone abbreviation, consisting of alphanumeric characters,
        ///         e.g. UTC, EDT, GMT.
        ///  - %:Z  time zone name, e.g. Europe/London. The name may contain any
        ///         characters and is delimited by the following character in the
        ///         <code>format</code> string. It will not work if you follow %:Z with another
        ///         escape sequence (except %% or %t).
        ///  <b></b>ther
        ///  - %t   matches one or more whitespace characters
        ///  - %%   literal '%' character
        ///  Any other character must have a matching character in <code>string</code>, except
        ///  that a space will match zero or more whitespace characters in the input
        ///  string.
        ///  If any time zone information is present in the string, the function
        ///  attempts to find a matching time zone in the <code>zones</code> collection. A time
        ///  zone name (format code %:Z) will provide an unambiguous look up in
        ///  <code>zones.</code> Any other type of time zone information (an abbreviated time
        ///  zone code (%Z) or UTC offset (%z, %:z, %:u) is searched for in <code>zones</code>
        ///  and if only one time zone is found to match, the result is set to that
        ///  zone. Otherwise:
        ///  - If more than one match of a UTC offset is found, the action taken is
        ///    determined by <code>offsetIfAmbiguous</code>: if <code>offsetIfAmbiguous</code> is true,
        ///    a local time with an offset from UTC (type <code>OffsetFromUTC</code>) will be
        ///    returned; if false an invalid KDateTime is returned.
        ///  - If more than one match of a time zone abbreviation is found, the UTC
        ///    offset for each matching time zone is compared and, if the offsets are
        ///    the same, a local time with an offset from UTC (type <code>OffsetFromUTC</code>)
        ///    will be returned provided that <code>offsetIfAmbiguous</code> is true. Otherwise
        ///    an invalid KDateTime is returned.
        ///  - If a time zone abbreviation does not match any time zone in <code>zones</code>,
        ///    or the abbreviation does not apply at the parsed date/time, an
        ///    invalid KDateTime is returned.
        ///  - If a time zone name does not match any time zone in <code>zones</code>, an
        ///    invalid KDateTime is returned.
        ///  - If the time zone UTC offset does not match any time zone in <code>zones</code>,
        ///    a local time with an offset from UTC (type <code>OffsetFromUTC</code>) is
        ///    returned.
        ///  If <code>format</code> contains more than one time zone or UTC offset code, an
        ///  error is returned.
        ///  If no time zone information is present in the string, by default a local
        ///  clock time (type <code>ClockTime</code>) is returned. You can use
        ///  setFromStringDefault() to change this default.
        ///  If no time is found in <code>string</code>, a date-only value is returned.
        ///  If any inconsistencies are found, i.e. the same item of information
        ///  appears more than once but with different values, the weekday name does
        ///  not tally with the date, an invalid KDateTime is returned.
        ///  If an invalid KDateTime is returned, you can check why <code>format</code> was
        ///  considered invalid by use of outOfRange(). If that method returns true,
        ///  it indicates that <code>format</code> was in fact valid, but the date lies outside
        ///  the range which can be represented by QDate.
        /// <param> name="string" string to convert
        /// </param><param> name="format" format string
        /// </param><param> name="zones" time zone collection, or null for none
        /// </param><param> name="offsetIfAmbiguous" specifies what to do if more than one zone
        ///                           matches the UTC offset found in the
        ///                           string. Ignored if <code>zones</code> is null.
        /// </param></remarks>        <return> KDateTime value, or an invalid KDateTime if an error occurs, if
        ///          time zone information doesn't match any in <code>zones</code>, or if the
        ///          time zone information is ambiguous and <code>offsetIfAmbiguous</code> is
        ///          false
        /// </return>
        ///         <short>    Returns the KDateTime represented by <code>string</code>, using the <code>format</code>  given, optionally using a time zone collection <code>zones</code> as the source of  time zone definitions.</short>
        ///         <see> setFromStringDefault</see>
        ///         <see> toString</see>
        ///         <see> outOfRange</see>
        public static KDateTime FromString(string arg1, string format, KTimeZones zones, bool offsetIfAmbiguous) {
            return (KDateTime) staticInterceptor.Invoke("fromString$$#$", "fromString(const QString&, const QString&, const KTimeZones*, bool)", typeof(KDateTime), typeof(string), arg1, typeof(string), format, typeof(KTimeZones), zones, typeof(bool), offsetIfAmbiguous);
        }
        public static KDateTime FromString(string arg1, string format, KTimeZones zones) {
            return (KDateTime) staticInterceptor.Invoke("fromString$$#", "fromString(const QString&, const QString&, const KTimeZones*)", typeof(KDateTime), typeof(string), arg1, typeof(string), format, typeof(KTimeZones), zones);
        }
        public static KDateTime FromString(string arg1, string format) {
            return (KDateTime) staticInterceptor.Invoke("fromString$$", "fromString(const QString&, const QString&)", typeof(KDateTime), typeof(string), arg1, typeof(string), format);
        }
        /// <remarks>
        ///  Sets the default time specification for use by fromString() when no time
        ///  zone or UTC offset is found in the string being parsed, or when "-0000"
        ///  is found in an RFC 2822 string.
        ///  By default, fromString() returns a local clock time (type <code>ClockTime</code>)
        ///  when no definite zone or UTC offset is found. You can use this method
        ///  to make it return the local time zone, UTC, or whatever you wish.
        /// <param> name="spec" the new default time specification
        /// </param></remarks>        <short>    Sets the default time specification for use by fromString() when no time  zone or UTC offset is found in the string being parsed, or when "-0000"  is found in an RFC 2822 string.</short>
        ///         <see> fromString</see>
        public static void SetFromStringDefault(KDateTime.Spec spec) {
            staticInterceptor.Invoke("setFromStringDefault#", "setFromStringDefault(const KDateTime::Spec&)", typeof(void), typeof(KDateTime.Spec), spec);
        }
    }
}
