/*
  Copyright (c) 2013-2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef SHORTURLUTILS_H
#define SHORTURLUTILS_H

#include <QObject>
#include "pimcommon_export.h"

namespace PimCommon
{
class AbstractShortUrl;
namespace ShortUrlUtils
{
enum EngineType {
    Google = 0,
    Tinyurl = 1,
    MigreMe = 2,
    TriopAB = 3,
    Ur1Ca = 4,
    IsGd = 5,

    //TODO add more engine.
    EndListEngine
};
QString stringFromEngineType(EngineType type);
AbstractShortUrl *loadEngine(QObject *parent);
PIMCOMMON_EXPORT PimCommon::AbstractShortUrl *loadEngine(PimCommon::ShortUrlUtils::EngineType type, QObject *parent);

int readEngineSettings();
void writeEngineSettings(int value);
}
}

#endif // SHORTURLUTILS_H
