/*
   Copyright (C) 2012-2016 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "akonadidatabase.h"

#include <AkonadiCore/ServerManager>

#include <QSettings>

AkonadiDataBase::AkonadiDataBase()
{
    init();
}

AkonadiDataBase::~AkonadiDataBase()
{

}

QStringList AkonadiDataBase::options() const
{
    return m_dboptions;
}

QString AkonadiDataBase::driver() const
{
    return m_dbdriver;
}

QString AkonadiDataBase::name() const
{
    return m_dbname;
}

void AkonadiDataBase::init()
{
    const QString serverConfigFile = Akonadi::ServerManager::serverConfigFilePath(Akonadi::ServerManager::ReadWrite);
    QSettings settings(serverConfigFile, QSettings::IniFormat);

    m_dbdriver = settings.value(QStringLiteral("General/Driver"), QStringLiteral("QMYSQL")).toString();
    settings.beginGroup(m_dbdriver);

    if (m_dbdriver == QLatin1String("QPSQL")) {
        m_dbname = settings.value(QStringLiteral("Name"), QStringLiteral("akonadi")).toString();
        m_dboptions.append(QLatin1String("--host=") + settings.value(QStringLiteral("Host"), QString()).toString());
        // If the server is started by the user, we don't need to know the username/password.
        bool startServer = settings.value(QStringLiteral("StartServer"), QStringLiteral("true")).toBool();
        if (!startServer) {
            // TODO: postgres will always ask for the user password ! implement .pgpass
            m_dboptions.append(QLatin1String("--username=") + settings.value(QStringLiteral("User"), QString()).toString());
        }
        settings.endGroup();
    } else if (m_dbdriver == QLatin1String("QMYSQL")) {
        m_dbname = settings.value(QStringLiteral("Name"), QStringLiteral("akonadi")).toString();
        // If the server is started by the user, we don't need to know the username/password.
        bool startServer = settings.value(QStringLiteral("StartServer"), QString()).toBool();
        if (!startServer) {
            m_dboptions.append(QLatin1String("--host=") + settings.value(QStringLiteral("Host"), QString()).toString());
            m_dboptions.append(QLatin1String("--user=") + settings.value(QStringLiteral("User"), QString()).toString());
            m_dboptions.append(QLatin1String("--password=") + settings.value(QStringLiteral("Password"), QString()).toString());
        } else {
            const QString options = settings.value(QStringLiteral("Options"), QString()).toString();
            const QStringList list = options.split(QLatin1Char('='));
            m_dboptions.append(QLatin1String("--socket=") + list.at(1));
        }

        settings.endGroup();
    }
}
