/*
   Copyright (C) 2016 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef CONFIRMADDRESSCONFIGUREWIDGET_H
#define CONFIRMADDRESSCONFIGUREWIDGET_H

#include <QWidget>
#include <MessageComposer/PluginEditorCheckBeforeSendConfigureWidget>
class QCheckBox;
class ConfirmAddressConfigureTab;
class ConfirmAddressConfigureWidget : public MessageComposer::PluginEditorCheckBeforeSendConfigureWidget
{
    Q_OBJECT
public:
    explicit ConfirmAddressConfigureWidget(KIdentityManagement::IdentityManager *im, QWidget *parent = Q_NULLPTR);
    ~ConfirmAddressConfigureWidget();

    void loadSettings() Q_DECL_OVERRIDE;
    void saveSettings() Q_DECL_OVERRIDE;
    void resetSettings() Q_DECL_OVERRIDE;

private:
    void slotEnableChanged(bool state);
    QCheckBox *mEnable;
    ConfirmAddressConfigureTab *mConfirmAddressConfigureTab;
};

#endif // CONFIRMADDRESSCONFIGUREWIDGET_H
