/*
   Copyright (C) 2019 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef DKIMRESULTATTRIBUTE_H
#define DKIMRESULTATTRIBUTE_H

#include <AkonadiCore/attribute.h>
#include "messageviewer_private_export.h"
namespace MessageViewer {
class DKIMResultAttributePrivate;

class MESSAGEVIEWER_TESTS_EXPORT DKIMResultAttribute : public Akonadi::Attribute
{
public:
    DKIMResultAttribute();
    ~DKIMResultAttribute();
    Q_REQUIRED_RESULT DKIMResultAttribute *clone() const override;
    Q_REQUIRED_RESULT QByteArray type() const override;
    Q_REQUIRED_RESULT QByteArray serialized() const override;
    void deserialize(const QByteArray &data) override;

    Q_REQUIRED_RESULT bool operator==(const DKIMResultAttribute &other) const;

    void setError(int err);
    Q_REQUIRED_RESULT int error() const;

    void setWarning(int err);
    Q_REQUIRED_RESULT int warning() const;

    void setStatus(int err);
    Q_REQUIRED_RESULT int status() const;

private:
    friend class DKIMResultAttributePrivate;
    DKIMResultAttributePrivate *const d;
};
}

#endif // DKIMRESULTATTRIBUTE_H
