/***************************************************************************
                          page2.cpp  -  KInstall's Wizard 2nd Page
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "page2.h"

Page2::Page2(_KInstall *parent, const char *name ) : _Page(parent,name) {
	ki->getButtonBack()->show();
	ki->setTitle(TITL_2);
	ki->setTitleFont("Helvetica",24,QFont::Bold,true);
	p_exp = new QLabel(MSG_07+ki->inst.name+MSG_08+remBinFromKdeBinDir()+" .",this);
	p_adress = new QLineEdit(this);
	p_browse = new QPushButton(BTN_BROWSE,this);
	p_xtra_args = new QLabel(MSG_21,this);
	p_xtrargs = new QLineEdit(this);
	if (ki->inst.wheretoinstall==0)
		p_adress->setText(remBinFromKdeBinDir());
	else
		p_adress->setText( ki->inst.wheretoinstall );
	if (ki->inst.xtrargs!=0&&ki->inst.xtrargs!="")
		 p_xtrargs->setText( ki->inst.xtrargs);
	connect(p_browse,SIGNAL(clicked()),this, SLOT(slotBrowsePressed()));
	connect(ki, SIGNAL(nextclicked()), this, SLOT(slotFinished()));
	connect(ki, SIGNAL(backclicked()), this, SLOT(slotFinished2()));
}
Page2::~Page2(){
}

void Page2::slotBrowsePressed(){
	KDirDialog dd("/",ki,"dd");QString d;
	d=dd.getDirectory("/",ki,"dd");
	if (d!=""&&d!=0)
		p_adress->setText(d);
}

void Page2::resizeEvent( QResizeEvent * ){
	p_exp->setGeometry(0,0,width(),60);
	p_adress->setGeometry(5,70,width()-85,25);
	p_browse->setGeometry(width()-75,70,70,25);
	p_xtra_args->setGeometry(0,100,width(),30);
	p_xtrargs->setGeometry(5,130,width()-10,25);
}

void Page2::slotFinished(){
	ki->inst.wheretoinstall = p_adress->text();
	ki->inst.xtrargs = p_xtrargs->text();
	disconnect(ki, SIGNAL(nextclicked()), this, SLOT(slotFinished()));
	disconnect(ki, SIGNAL(backclicked()), this, SLOT(slotFinished2()));
	emit finished();
}

void Page2::slotFinished2(){
	ki->inst.wheretoinstall = p_adress->text();
	ki->inst.xtrargs = p_xtrargs->text();
	disconnect(ki, SIGNAL(nextclicked()), this, SLOT(slotFinished()));
	disconnect(ki, SIGNAL(backclicked()), this, SLOT(slotFinished2()));
	emit finished2();
}

QString Page2::remBinFromKdeBinDir(){ // THE odd function... :-)
	QString t(kapp->kde_bindir());
	t.remove(strlen(t)-3,strlen(t));
	return t;
}
