#ifndef NUMTBL_H
#define NUMTBL_H

#include <qtablevw.h>


// -- class NumTbl

class NumTbl: public QTableView
{
  Q_OBJECT
public:

  NumTbl(int _cols, int _maxNum, QWidget *parent=0, const char *name=0);
  ~NumTbl();

  QString selection();
  void    setSelection(bool *);

public slots:

  void setSelection(const char *);
  void deselectAll ();

signals:

  void selectionChanged(const char *);
  
protected:

  void mousePressEvent(QMouseEvent *);
  void paintCell(QPainter *, int, int);

private:

  int  findNum(int, int);
  void newSelection();
  
  int  rows;
  int  cols;
  int  maxNum;
  bool *selected;
};

#endif // NUMTBL_H
