/***************************************************************************
                          khcountingmessage.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Aug 18 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kprocess.h>
#include <qstring.h>
#include <qdatetime.h>
#include "khglobals.h"
#include "khseccounter.h"
#include "khcountingmessage.h"

KHCountingMessage *KHCountingMessage::messages[SensorIdSize] = { 0 };
KHSecCounter *KHCountingMessage::timer = 0;
QMessageBox *KHCountingMessage::shutdownMessage = 0;


KHCountingMessage::KHCountingMessage( QString message, SensorId sid ) :
	 QMessageBox 		( NULL,
										message,
										QMessageBox::Warning,
										QMessageBox::Ok,
										QMessageBox::Cancel | QMessageBox::Escape | QMessageBox::Default,
										0,
										0,
										0,
										false // false for modeless
								 	)
{

	messages[sid] = this;

	testShutdownEnabled();
	this->sid = sid;
	show();
}

KHCountingMessage::~KHCountingMessage(){
	messages[sid] = 0;
	if ( timer ) {
		delete timer;
		timer = 0;
	}	
}


void KHCountingMessage::shutdownSystem(){
	KProcess proc;
	proc << "shutdown" << "-h" << "now";
	proc.start( KProcess::DontCare );
}


void KHCountingMessage::handleAlertMessage( int value ){
	QString text;
	bool stop_timer = true;

 	secsLeft = value;
 	// if the counted seconds are below the "visible part",
 	// check if any message is visible. If not ( user did click away the warnings )
 	// stop timer and leave this function
 	// otherwise show shutdown message box if it is not already there                                                    	
 	if ( value <= warningTime ) {
 		for ( SensorId sid = Fan1; sid < SensorIdSize; sid++ )
 			if ( messages[sid] )
 				if ( messages[sid]->isVisible() )
 					stop_timer = false;
 		if ( ( stop_timer ) && ( timer ) ) {
 			debug( "timer stopped" );
 			if ( timer->isActive() )
 			timer->stop();
 			return;
 		}
 		if ( !shutdownMessage ) {
 			debug("creating");
 			shutdownMessage = new QMessageBox	( NULL,
 																					"",
 																					QMessageBox::Warning,
 																					QMessageBox::Ok,
 																					QMessageBox::Cancel | QMessageBox::Escape | QMessageBox::Default,
 																					0,
 																					0,
 																					0,
 																					true
 																			 	);
 		}
 		text = ( i18n( "\nShutdown sequence initiated,\n" ) );
 		text.append( QString().setNum( value ) );
 		text.append( i18n( " seconds left !" ) );
 		shutdownMessage->setButtonText( Ok, i18n( "Shutdown now !" ) );
 		shutdownMessage->setButtonText( Cancel, i18n( "No, stop it !" ) );
 		shutdownMessage->setText( text );
 		int ret = shutdownMessage->exec();

 		// when the user reacted to the shutdown message,
 		// do what the user chose: stop timer or shut down immediately
 		debug("returning");
 		if ( ret == 1 ) shutdownSystem();
 		else if ( ret == 2 ) {
 			delete shutdownMessage;		                                 	
 			shutdownMessage = 0;
 			debug( "stopping timer" );
 			timer->stop();
 		}
 	}
}

void KHCountingMessage::show() {
	
	// if a new message pops up and no timer is running, restart timer
	if ( testShutdownEnabled() )
	if ( ( !timer->isActive() ) && ( !this->isVisible() ) ) {
		debug( "restarting timer" );
		timer->restart();
	}
	QMessageBox::show();	

}

/**  */
bool KHCountingMessage::testShutdownEnabled(){
	bool shutdown = false;	

	config = kapp->getConfig();
	config->setGroup( "General" );
	secsLeft = config->readNumEntry( GeneralKeys[2], 60 );
	warningTime = config->readNumEntry( GeneralKeys[3], 20);	
	shutdown = config->readBoolEntry( GeneralKeys[1], false );
	if ( ( !timer ) && ( shutdown ) ){
			debug( "starting timer" );
			timer = new KHSecCounter( secsLeft );	
			connect( timer, SIGNAL( timeout() ),
							 this , 	SLOT( shutdownSystem() ) );
			connect( timer, SIGNAL( secsLeft( int ) ),
							 this, 		SLOT( handleAlertMessage( int ) ) );
	}
	else if ( ( timer ) && ( !shutdown ) ) {
		delete timer;
		timer = 0;
	}
	else if ( ( timer ) && ( shutdown ) ) {
		timer->changeInterval( secsLeft );
	}

	return shutdown;
}



