/***************************************************************************
                          khdisplayitem.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Sep 26 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qspinbox.h>
#include <qlcdnumber.h>
#include <qlabel.h>
#include <khglobals.h>
#include <qlayout.h>
#include <kapp.h>
#include "khdisplayitem.h"
#include "khfeatureprofile.h"

int KHDisplayItem::itemNr = 0;
int KHDisplayItem::xPos = 2;
int KHDisplayItem::yPos = 1;

KHDisplayItem::KHDisplayItem( int NumDig,	int loboxLoLim, int loboxHiLim, int loboxSteps,
															int hiboxLoLim, int hiboxHiLim, int hiboxSteps,
															SensorId sid, QWidget *Parent ){

	QString label;

	switch ( sid ){
		case Fan1:
			label = i18n( "Fan 1 [ rpm ]" );
			Name = i18n( "Fan 1" );
		break;
		case Fan2:
			label = i18n( "Fan 2 [ rpm ]" );
			Name = i18n( "Fan 2" );
		break;
		case Fan3:
			label = i18n( "Fan 3 [ rpm ]" );
			Name = i18n( "Fan 3" );
		break;
		case Temp1:
			label = i18n( "Temperature 1 [ C ]" );
			Name = i18n( "Temperature 1" );
		break;
		case Temp2:
			label = i18n( "Temperature 2 [ C ]" );
			Name = i18n( "Temperature 2" );
		break;
		case Temp3:
			label = i18n( "Temperature 3 [ C ]" );
			Name = i18n( "Temperature 3" );
		break;
		case VCore:
			Name = label = i18n( "VCore" );
		break;
		case VCore2:
			Name = label = i18n( "Vtt" );
		break;
		case V33:
			Name = label = i18n( "+3.3 V" );
		break;
		case V5:
			Name = label = i18n( "+5 V" );
		break;
		case Vm5:
			Name = label = i18n( "-5 V" );
		break;
		case V12:
			Name = label = i18n( "+12 V" );
		break;
		case Vm12:
			Name = label = i18n( "-12 V" );
		break;
		case VID:
		 	Name = label = i18n( "VID" );
		default:
			// ignore aux values
		break;
	}

	Label = new QLabel( label, Parent );
	Label->setMinimumSize( Label->sizeHint().width(), Label->sizeHint().height() + 5 );
	grid->addWidget( Label, yPos - 1, xPos );

	Lcd = new QLCDNumber( NumDig, Parent );
	Lcd->setMinimumSize( Lcd->sizeHint().width() - 20, Lcd->sizeHint().height() );
	grid->addWidget( Lcd, yPos, xPos );

	Lobox = new QSpinBox( loboxLoLim, loboxHiLim, loboxSteps, Parent );
	Lobox->setMinimumWidth( 65 );
	grid->addWidget( Lobox, yPos, xPos - 2 );
	if ( loboxSteps == 0 ) Lobox->setEnabled( false );

	Hibox = new QSpinBox( hiboxLoLim, hiboxHiLim, hiboxSteps, Parent );
	Hibox->setMinimumWidth( 65 );
	grid->addWidget( Hibox, yPos, xPos + 2 );
	if ( hiboxSteps == 0 ) Hibox->setEnabled( false );

	itemNr++;
	yPos += 2;
	if ( itemNr == itemCount / 2 ) {
		// neue Spalte
		yPos = 1;
		xPos = 8;
	}
}

KHDisplayItem::~KHDisplayItem(){
}

/**  */
QString KHDisplayItem::name(){
	return Name;
}

/**  */
QLabel *KHDisplayItem::label(){
	return Label;
}

/**  */
QLCDNumber * KHDisplayItem::lcd(){
	return Lcd;
}

/**  */
QSpinBox * KHDisplayItem::lobox(){
	return Lobox;
}

/**  */
QSpinBox * KHDisplayItem::hibox(){
	return Hibox;
}
