/***************************************************************************
                          khfeatureprofile.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 31 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KHFEATUREPROFILE_H
#define KHFEATUREPROFILE_H

#include "sensorid.h"
#include "sensors.h"
#include "khglobals.h"

struct FeatureProfilePrivate{
	bool enabled;
	int number;
	int min;
	int max;
	int alarm;
	QString Name;
};

class KHFeatureProfile{

public:
	KHFeatureProfile( sensors_chip_name chipname );
	virtual ~KHFeatureProfile();
  /**  */
  static bool checkFeature( SensorId sid );
  /**  */
  int featureID( SensorId sid );
  /**  */
  int minID( SensorId sid );
  /**  */
  int maxID( SensorId sid );
	int alarmID( SensorId sid );
  /**  */
  /**  */
  static QString name( SensorId sid );
  virtual int featureCount();

protected:
	void parseFeatures();
	virtual SensorId *storeFeature( sensors_feature_data feature ) = 0;

protected:
  /**  */
  int count;
	sensors_chip_name chipname;
	static FeatureProfilePrivate profile[SensorIdSize + auxValues];

};

#endif
























