#ifndef __KSHEETDLG_H__
#define __KSHEETDLG_H__

#include <qdialog.h>
#include <qlist.h>
#include "KSheet.h"

class QPushButton;
class QGroupBox;

class KSheetDlg : public QDialog {
  Q_OBJECT
  
private:
  QPushButton* m_pNext;
  QPushButton* m_pPrev;
  QPushButton* m_pFinish;
  QPushButton* m_pCancel;
  
  int m_nCurSheet;
  QList<KSheet> m_cSheets;
  QGroupBox* m_pSheetHolder;

  void calcLayout();
  void updateButtons();
  
protected:
  virtual void resizeEvent(QResizeEvent*);
  
public:
  KSheetDlg(const char* name=0);

  void addSheet(KSheet*);
  void setNextButton(const char* text =  "Next >");
  void setPrevButton(const char* text =  "< Prev");
  void setFinishButton(const char* text= "Finish");
  void setCancelButton(const char* text= "Cancel");

  virtual void show();

public slots:
  void enableFinish();
  void enableNext();
  void disableFinish();
  void disableNext();

private slots:
  void onNext();
  void onPrev();
};

#endif // __KSHEETDLG_H__
