/************************************************************************
 * kinst - KDE Application Installer - readfile.cpp                     *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>

#include "readfile.h"

#ifndef EOL
#define EOL 10
#endif

#ifndef EOS
#define EOS 0
#endif

tKIFReader::tKIFReader()
{
  KIFfile = NULL;
  KIFOptions = new tKIFOptions;
}

tKIFReader::~tKIFReader()
{
  if (!(KIFfile == NULL)) fclose(KIFfile);
  KIFfile = NULL;

  delete KIFOptions;
}

int tKIFReader::OpenKIFfile(char* filename)
{
  if (KIFfile == NULL) KIFfile = fopen(filename, "r");
  if (KIFfile == NULL) return(0); else return(1);
}

int tKIFReader::getOption(char* opt, char* value)
{
  unsigned int i;
  char readchar;

  rewind(KIFfile);

  strcat(opt, "=");

  i = 1;

  do
    {
      if(i >= 1024) return(0);
      if(feof(KIFfile)) return(0);
      if(fread(&readchar,sizeof(char),1,KIFfile) < 1) return(0);

      if(readchar == opt[i-1]) i++; else i = 1;

      if(i-1 == strlen(opt)) i = 0;

    } while(i != 0);

  if(feof(KIFfile)) return(0);

  i = 1;

  do
    {
      if(i >= 1024-1) return(0);
      if(feof(KIFfile)) return(0);
      if(fread(&readchar,sizeof(char),1,KIFfile) < 1) return(0);

      if((readchar != EOL)/* &&(readchar != ' ') */)
	{
	  value[i-1] = readchar;
	  i++;
	}

    } while(readchar != EOL);

  value[i-1] = EOS;

  return(1);
}

int tKIFReader::CheckFileType(char* magicstring)
{
  unsigned int i;
  char readchar;

  if(KIFfile == NULL) return(0);

  rewind(KIFfile);

  i = 1;

  do
    {
      if(feof(KIFfile)) return(0);
      if(fread(&readchar,sizeof(char),1,KIFfile) < 1) return(0);

      if(readchar == magicstring[i-1]) i++; else return(0);

      if(i == strlen(magicstring)) i = 0;
    } while(i != 0);

  return(1);
}

int tKIFReader::ParseKIFfile(void)
{
  char actoption[1024];
  char actvalue[1024];
  char cptrextnr[2];
  int extnr;

  // Basic values for main package
  // -----------------------------

  strcpy(actoption, "PROGRAMNAME");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->ProgramName, actvalue, 1024);

  strcpy(actoption, "CHECKPRIORFILE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->CheckPriorFile, actvalue, 1024);

  strcpy(actoption, "CHECKPRIORRPM");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->CheckPriorRPM, actvalue, 1024);

  strcpy(actoption, "SOURCEFILETYPE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->SourceFileType, actvalue, 1024);

  strcpy(actoption, "SOURCEFILE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->SourceFile, actvalue, 1024);

  strcpy(actoption, "READMEFILE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->ReadMeFile, actvalue, 1024);

  strcpy(actoption, "GRAPHICSFILE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->GraphicsFile, actvalue, 1024);

  strcpy(actoption, "ICONFILE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->IconFile, actvalue, 1024);

  strcpy(actoption, "EXECBINARY");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->ExecBinary, actvalue, 1024);

  strcpy(actoption, "KDELNKADDITIONS");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->KDELNKAdditions, actvalue, 1024);

  strcpy(actoption, "DEFAULTINSTALLPATH");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->DefaultInstallPath, actvalue, 1024);

  strcpy(actoption, "RELOCATABLEPACKAGE");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->RelocatablePackage, actvalue, 1024);

  strcpy(actoption, "DEFAULTMENUENTRY");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->DefaultMenuEntry, actvalue, 1024);

  strcpy(actoption, "PREINSTALLSCRIPT");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->PreInstallScript, actvalue, 1024);

  strcpy(actoption, "DONEINSTALLSCRIPT");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->DoneInstallScript, actvalue, 1024);

  strcpy(actoption, "RECOMMENDREBOOT");
  if(!getOption(actoption, actvalue)) return(0);
  strncpy(KIFOptions->RecommendReboot, actvalue, 1024);

  strcpy(actoption, "LIBRARYDIR");
  if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
  strncpy(KIFOptions->LibraryDir, actvalue, 1024);

  strcpy(actoption, "URL");
  if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
  strncpy(KIFOptions->URL, actvalue, 1024);

  // Extension for multiple packages
  // -------------------------------

  for(extnr = 0;extnr <= 4;extnr++)
    {
      sprintf(cptrextnr, "%i", extnr + 2);

      strcpy(actoption, "PROGRAMNAME");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->ProgramName2[extnr], actvalue, 1024);

      strcpy(actoption, "CHECKPRIORFILE");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->CheckPriorFile2[extnr], actvalue, 1024);

      strcpy(actoption, "CHECKPRIORRPM");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->CheckPriorRPM2[extnr], actvalue, 1024);

      strcpy(actoption, "SOURCEFILE");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->SourceFile2[extnr], actvalue, 1024);

      strcpy(actoption, "ICONFILE");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->IconFile2[extnr], actvalue, 1024);

      strcpy(actoption, "EXECBINARY");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->ExecBinary2[extnr], actvalue, 1024);

      strcpy(actoption, "KDELNKADDITIONS");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->KDELNKAdditions2[extnr], actvalue, 1024);

      strcpy(actoption, "PREINSTALLSCRIPT");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->PreInstallScript2[extnr], actvalue, 1024);

      strcpy(actoption, "DONEINSTALLSCRIPT");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->DoneInstallScript2[extnr], actvalue, 1024);

      strcpy(actoption, "LIBRARYDIR");
      strcat(actoption, cptrextnr);
      if(!getOption(actoption, actvalue)) strcpy(actvalue, "");
      strncpy(KIFOptions->LibraryDir2[extnr], actvalue, 1024);
    }

  return(1);
}
