/************************************************************************
 * createinst - part of kinst package - package.c                       *
 * Copyright (C) 1999  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "i18n.h"

#ifndef EOL
#define EOL 10
#endif

int GetOverPacking(char* InstDir, char* NAME, char* KIF, char* PKG,
		   char* IMG, char* README, char* PRESCRIPT)
{
  char Command[65535]; /* should be sufficient... */
  char PackLocation[FILENAME_MAX];
  char kinstLocation[FILENAME_MAX];
  char moLocation[FILENAME_MAX];
  int numoffiles;
  char cptrnumoffiles[3];
  char s[FILENAME_MAX];
  FILE* kinsttest;
  FILE* tempfile;
  char temp[FILENAME_MAX];

  numoffiles = 0;

  tmpnam(temp);

  printf(_i18n("Please enter the full path of the \"kipack\" program\n(Or - if it's in the system PATH)\n: "));
  scanf("%s", s);
  if(s[0] == '-') strcpy(PackLocation, "kipack");
  else
    realpath(s, PackLocation);

  strcpy(Command, PackLocation);
  strcat(Command, " ");
  strcat(Command, "\"");
  /* strcat(Command, InstDir); */
  /* strcat(Command, "/"); */
  strcat(Command, NAME);
  strcat(Command, ".kip");
  strcat(Command, "\"");
  strcat(Command, " ");

  if(strlen(KIF) > 0) numoffiles++;
  if(strlen(PKG) > 0) numoffiles++;
  if(strlen(IMG) > 0) numoffiles++;
  if(strlen(README) > 0) numoffiles++;
  if(strlen(PRESCRIPT) > 0) numoffiles++;

  sprintf(cptrnumoffiles, "%i", numoffiles);
  strcat(Command, cptrnumoffiles);
  strcat(Command, " ");

  if(strlen(KIF) > 0)
    {
      strcat(Command, KIF);
      strcat(Command, " 0 ");
    }
  if(strlen(PKG) > 0)
    {
      strcat(Command, PKG);
      strcat(Command, " 0 ");
    }
  if(strlen(IMG) > 0)
    {
      strcat(Command, IMG);
      strcat(Command, " 0 ");
    }
  if(strlen(README) > 0)
    {
      strcat(Command, README);
      strcat(Command, " 0 ");
    }
  if(strlen(PRESCRIPT) > 0)
    {
      strcat(Command, PRESCRIPT);
      strcat(Command, " 1 ");
    }

  chdir(InstDir);

#ifdef _DEBUG_
  printf(_i18n("Executing: %s\n"), Command); */
#endif

  system(Command);

  printf(_i18n("Do you want to make a \"one-executable-installer\" [Y/N]?"));
  scanf("%1s", Command);
  Command[0] = toupper(Command[0]);
  if(Command[0] != 'Y') return(0);

  printf(_i18n("Please enter the full path of the \"kiselfextract\" program\n(Or - if it's in the system PATH)\n: "));
  scanf("%s", s);
  if(s[0] == '-')
    {
      strcpy(Command, "which kiselfextract > ");
      strcat(Command, temp);
      system(Command);
      tempfile = 0;
      tempfile = fopen(temp, "r");
      if(tempfile == 0)
	{
	  fprintf(stderr, "Error: Could not determine kiselfextract position\n");
	  exit(127);
	}
      fgets(PackLocation, FILENAME_MAX, tempfile);
      PackLocation[strlen(PackLocation)-1] = 0;
      fclose(tempfile);
      remove(temp);
    }
  else
    realpath(s, PackLocation);

  printf(_i18n("Please enter the full path to the directory containing the kinst gmo-Files\n: "));
  scanf("%s", s);
  realpath(s, moLocation);

  kinsttest = 0;
  strcpy(Command, getenv("KDEDIR"));
  strcat(Command, "/bin/kinst");
  kinsttest = fopen(Command, "r");
  if(kinsttest != 0)
    {
      fclose(kinsttest);
      strcpy(kinstLocation, Command);
    }
  else
    {
      printf(_i18n("Please enter the full path of the \"kinst\" program\n: "));
      scanf("%s", s);
      realpath(s, kinstLocation);
    }

  /* Get the GMOs */
  strcpy(Command, "cp -f ");
  strcat(Command, moLocation);
  strcat(Command, "/*.gmo .");

  system(Command);

  /* Get kinst */
  strcpy(Command, "cp -f ");
  strcat(Command, kinstLocation);
  strcat(Command, " .");

  system(Command);

  /* Ready the kip file */
  strcpy(Command, "mv -f ");
  strcat(Command, NAME);
  strcat(Command, ".kip package.kip");

  system(Command);

  /* use kiselfextract */
  strcpy(Command, PackLocation);
  strcat(Command, " -p *.gmo package.kip kinst > ");
  strcat(Command, NAME);
  strcat(Command, ".setupexe");

  system(Command);

  /* Make it executable */
  strcpy(Command, "chmod a+x ");
  strcat(Command, NAME);
  strcat(Command, ".setupexe");

  system(Command);

  return(0);
}
