/************************************************************************
 * kcreateinst - part of kinst package - createdlg.h                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _CREATEDLG_H
#define _CREATEDLG_H

#include "tparams.h"

#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <kfiledialog.h>
#include <drag.h>

class kcreateinstCreateDlg:public QDialog
{
  Q_OBJECT
 private:
  int start_requested;
  tParams* origparams;
  tParams* newparams;
  KDirDialog* FileSelector;
  QLineEdit* targetfolder_edit;
  QLabel* targetfolder_label;
  QPushButton* start_button;
  QPushButton* cancel_button;
  QPushButton* targetfolder_button;
  QCheckBox* onefile_check;
  QCheckBox* selfextract_check;
 private slots:
  void Browse1Pressed();
  void start_pressed();
  void cancel_pressed();
  void onefile_clicked();
 protected:
  void resizeEvent(QResizeEvent*);
  void closeEvent(QCloseEvent *e);
 public:
  void getCreatePrefs(tParams* actprefs, int* start_pressed);
  kcreateinstCreateDlg(QWidget *parent, const char *name);
};

#endif

