/***************************************************************************
                          liloconfig.cpp  -  description
                             -------------------
    begin                : Sat May 15 13:31:44 MEST 1999

    copyright            : (C) 1999 by Andreas Heck
    email                : aheck@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "liloconfig.h"
#include <iostream.h>
#include "global.h"

#define SPLITLINE(p) key = line.left(p);\
                     key = key.simplifyWhiteSpace();\
		     value = line.mid(p+1, line.length()-p+1);\
		     value = value.simplifyWhiteSpace();


LiloConfig::LiloConfig()
{
 
}

LiloConfigData LiloConfig::readConfig()
{
 QString line, key, value, valuebuffer;
 bool first = true;
 int pos = -1;
 QFile f (LILO_CONFIG_FILE); //open config file for lilo
 if (!f.open(IO_ReadOnly))
   return liloconfigdata;

 QTextStream stream(&f);
 while (!stream.eof())
 {
  line = stream.readLine();
  line = line.simplifyWhiteSpace();
  if ( (pos = line.find("#")) > -1 ) //remove comments
    line.truncate(pos);
  if (line.isEmpty())
    continue;
  line = line.lower();
  if (line == "linear")
    liloconfigdata.linear = true;
  if (line == "prompt")
    {
     line = stream.readLine();
     line = line.simplifyWhiteSpace();
     if ( (pos = line.find("#")) > -1)
       line.truncate(pos);
     if (line.isEmpty())
       continue;
     line = line.lower();
     if ((pos = line.find("=")) > -1)
       {
        SPLITLINE(pos);
        if (key == "timeout")
          {
           liloconfigdata.bootDelay = value.toInt();
          }
       }
    }
  if ((pos = line.find("=")) > -1)
    {
     SPLITLINE(pos);
     if (key == "boot")
       liloconfigdata.bootPartition = value;
     else if (key == "vga")
       liloconfigdata.vga = value;
     else if ((key == "image") || (key == "other"))
       {
        while (!stream.eof())
          {
           if (!first)
             {
              line = stream.readLine();
              line = line.simplifyWhiteSpace();
              if ( (pos = line.find("#")) > -1 ) //remove comments
                line.truncate(pos);
              if (line.isEmpty())
                continue;
              if ((pos = line.find("=")) > -1)
                {
                 valuebuffer = line.mid(pos+1, line.length()-pos+1);
                 valuebuffer = valuebuffer.simplifyWhiteSpace();
                 line = line.lower();
                 SPLITLINE(pos);
                }
             }
             else
               valuebuffer = value;
           first = false;
           if ((key == "image") || (key == "other"))
             {
              liloconfigdata.osList.append( new OSProperties() );
              if (key == "other")
                {
                 liloconfigdata.osList.current()->isLinux = false;
                 liloconfigdata.osList.current()->positionOnDisk = value;
                }
              else if (key == "image")
                liloconfigdata.osList.current()->kernel = valuebuffer;
             }
           else if (key == "label")
                  liloconfigdata.osList.current()->label = valuebuffer;
           else if (key == "root")
                  liloconfigdata.osList.current()->positionOnDisk = value;
          }
       }
    }
 }
 return liloconfigdata;
}

bool LiloConfig::writeConfig( LiloConfigData *config )
{
 QFile file(LILO_CONFIG_FILE);
 if (!file.open( IO_WriteOnly ))
   return false;

 QTextStream stream(&file);
 stream << "#This file has been generated by KLILO\n";
 stream << "boot=" << config->bootPartition << "\n";
 stream << "read-only\n" << "prompt\n" << "timeout=" << config->bootDelay << "\n";
 stream << "vga=" << config->vga << "\n";
 OSProperties *item;
 for ( item = config->osList.first(); item != 0; item = config->osList.next() )
    {
     if (item->isLinux)
       {
        stream << "\nimage=" << item->kernel << "\n";
        stream << "root=" << item->positionOnDisk << "\n";
        stream << "label=" << item->label << "\n";
       }
     else
       {
        stream << "\nother=" << item->positionOnDisk << "\n";
        stream << "label=" << item->label << "\n";
        stream << "table=" << getMBR().data() << "\n";
       }
    }

 return true;
}

QString LiloConfig::getMBR()
{
 QString MBR = "/dev/hda";
 QFile f(MBR.data());
 if (f.open(IO_ReadOnly))
   return MBR;
 else
 {
   MBR = "/dev/sda";
   f.setName(MBR.data());
   if (f.open(IO_ReadOnly))
     return MBR;
 }
 MBR = "";
 return MBR;
}

QString LiloConfig::getRootPartition()
{
 QFile in("/etc/fstab");
 QString dev, mpt, line;
 QTextStream stream(&in);

 if ( !in.open(IO_ReadOnly))
   return dev;

 while (!stream.eof())
  {
   line = stream.readLine();
   dev = strtok(line.data(), "\t ");
   mpt = strtok(NULL, "\t ");

   if ( mpt == "/" )
     return dev;
  }
}