/***************************************************************************
    $Id: kpcprinter.cpp,v 1.2 1999/09/26 15:43:04 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcprinter.cpp,v $
    Revision 1.2  1999/09/26 15:43:04  stephan
    Bugfixes.

    Revision 1.1  1999/09/14 00:26:26  wdl
    Restructuring of directories

    Revision 1.7  1999/09/09 11:28:43  stephan
    Fixed some things for the new spool handling

    Revision 1.6  1999/09/09 06:01:57  stephan
    Added OO style spool handling (by using KpcSpool)

    Revision 1.5  1999/08/29 15:03:41  stephan
    Added 2 methods for user specific printers which are not in the db

    Revision 1.4  1999/08/27 16:43:01  wdl
    Standard Headers

 ***************************************************************************/
#include "kpcprinter.h"

KpcPrinter::KpcPrinter(){
	DefaultPrinter = false;
	NetworkType = KpcPrinter::local;
}

KpcPrinter::KpcPrinter(KpcPrinter &t_prt){
	DefaultPrinter = t_prt.isDefaultPrinter();
	Model = t_prt.getModel();
	Manufactor = t_prt.getManufactor();
	PaperFormat = t_prt.getPaperFormat();
	Port = t_prt.getPort();
	RemoteMachine = t_prt.getRemoteMachine();
	RemoteQueue = t_prt.getRemoteQueue();	
	DbName = t_prt.getDbName();

	GSDriver = t_prt.getGSDriver();
	GSOptions = t_prt.getGSOptions();
	NetworkType = t_prt.getNetworkType();

	SpoolLst = t_prt.getSpoolLst();
}

KpcPrinter::~KpcPrinter(){
}

QList<QString> KpcPrinter::getSupportedPaperFormats() {
	QList<QString> t_lst;
	t_lst.clear();
  if(!Model.isEmpty() && !Manufactor.isEmpty()) {
		printerDB *t_db = new printerDB();
		printerDBentry *t_db_entry = new printerDBentry();
		*t_db_entry = t_db->getPrinterSPEC(Manufactor.data(),Model.data());
		t_lst = t_db_entry->getPaperFormats();
		delete(t_db); delete(t_db_entry);
	}
	return t_lst;
}

QList<QString> KpcPrinter::getSupportedMonoRes(){
	QList<QString> t_lst;
	t_lst.clear();
  if(!Model.isEmpty() && !Manufactor.isEmpty()) {
		printerDB *t_db = new printerDB();
		printerDBentry *t_db_entry = new printerDBentry();
		*t_db_entry = t_db->getPrinterSPEC(Manufactor.data(),Model.data());
		t_lst = t_db_entry->getMonoRes();
		delete(t_db); delete(t_db_entry);
	}
	return t_lst;
}

QList<QString> KpcPrinter::getSupportedColorRes(){
	QList<QString> t_lst;
	t_lst.clear();
  if(!Model.isEmpty() && !Manufactor.isEmpty()) {
		printerDB *t_db = new printerDB();
		printerDBentry *t_db_entry = new printerDBentry();
		*t_db_entry = t_db->getPrinterSPEC(Manufactor.data(),Model.data());
		t_lst = t_db_entry->getColorRes();
		delete(t_db); delete(t_db_entry);
	}
	return t_lst;
}


bool KpcPrinter::addSpool(KpcSpool *val){
	// first check if a spool with the same name is already present
	KpcSpool *t_spl = new KpcSpool;
	for(t_spl = SpoolLst.first(); t_spl != 0; t_spl = SpoolLst.next()) {
		if(strcmp(t_spl->getName(),val->getName()) == 0) return false;
	}
SpoolLst.append(new KpcSpool(*val));
delete(t_spl);
return true;
}

bool KpcPrinter::removeSpool(const char *val){
	KpcSpool *t_spl = new KpcSpool;
	bool found;
	found = false;
	for(t_spl = SpoolLst.first(); t_spl != 0; t_spl = SpoolLst.next()) {
		if(strcmp(t_spl->getName(),val) == 0 && !found){
			found = true;
			SpoolLst.remove();
		}
	}
delete(t_spl);
return found;
}

QList<QString> KpcPrinter::getSpoolLstName(){
	QString *t_str = new QString;
	QList<QString> t_lst;
	KpcSpool *t_spool = new KpcSpool();
	t_lst.clear();
	for(t_spool = SpoolLst.first(); t_spool != 0; t_spool = SpoolLst.next()){
		*t_str = t_spool->getName();
		t_lst.append(new QString(t_str->data()));
	}
	delete(t_str);
	delete(t_spool);
	return t_lst;	
}


