/***************************************************************************
    $Id: kpcspool.h,v 1.1 1999/09/14 00:26:26 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcspool.h,v $
    Revision 1.1  1999/09/14 00:26:26  wdl
    Restructuring of directories

    Revision 1.2  1999/09/09 11:28:43  stephan
    Fixed some things for the new spool handling

    Revision 1.1  1999/09/09 06:01:58  stephan
    Added OO style spool handling (by using KpcSpool)


 ***************************************************************************/
#ifndef KPCSPOOL_H
#define KPCSPOOL_H

/**
	* This class represents a spool for KpcPrinter.
	*
	* @see KpcPrinter
	**/


class KpcSpool {
	public:
		enum typeRecog{ automatic, raw, ascii };
		enum paperFormat{ def, a2, a3, a4, a5, b5, Letter, legal };
		enum col{ color, mono };
    KpcSpool();
		KpcSpool(KpcSpool &);
		KpcSpool(const char *valName, bool isDef=false ,typeRecog valRec=KpcSpool::automatic, col valCol=KpcSpool::color, paperFormat valPap=KpcSpool::def, int valX=0,int valY=0);
		~KpcSpool();
	
  	void setName(const char *val) { name = val; }
		/**
			* Set the X Resolution
			* In most cases the same as Y-Resolution
			**/
		void setXres(int val) { Xres = val; }
		/**
			* Set the Y Resolution
			* In most cases the same as X-Resolution
			**/
		void setYres(int val) { Yres = val; }
		/**
			*  Set the kind of TypeRecognition which apsfilter(our modified version) has to do)
			**/
		void setTypeRecognition(typeRecog val) { TypeRecognition = val; }
		/**
			* Set the Paperformat for the spool/queue
			**/
		void setPaperFormat(paperFormat val) { PaperFormat = val; }
		/**
			* Set spool to color or mono
			**/
		void setColor(col val) { Color = val; }
		void setDefaultSpool(bool val) { DefSpool = val; }

		const char *getName() { return name; }
		int getXres() { return Xres; }
		int getYres() { return Yres; }
		typeRecog getTypeRecognition() { return TypeRecognition; }
		paperFormat getPaperFormat() { return PaperFormat; }
		col getColor() { return Color; }
		bool isDefaultSpool() { return DefSpool; }

	private:
		typeRecog TypeRecognition;
		paperFormat PaperFormat;
		col Color;
		int Xres,Yres;
		const char *name;
		bool DefSpool;
};

#endif








