/***************************************************************************
    $Id: kpcwizard.cpp,v 1.16 1999/10/03 15:03:42 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcwizard.cpp,v $
    Revision 1.16  1999/10/03 15:03:42  stephan
    Removed refs.

    Revision 1.15  1999/10/01 17:42:28  stephan
    Bughunting.

    Revision 1.14  1999/09/26 15:49:53  stephan
    Added pages for startup and removing.

    Revision 1.13  1999/09/23 16:06:31  stephan
    Minor changes in kpcwizard

    Revision 1.12  1999/09/19 13:43:29  wdl
    kpcwizard is now a shared library

    Revision 1.11  1999/09/19 09:03:13  stephan
    Paperformats are now taken from the db

    Revision 1.10  1999/09/18 15:45:13  stephan
    Minor changes.

    Revision 1.9  1999/09/12 10:28:11  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.8  1999/09/09 11:28:43  stephan
    Fixed some things for the new spool handling

    Revision 1.7  1999/08/30 20:04:23  wdl
    First working version of knewwizard. It needs a lot of cleanup.

    Revision 1.6  1999/08/27 16:42:56  wdl
    Standard Headers

 ***************************************************************************/
#include "kpcwizard.h"

KpcWizard::KpcWizard(QWidget *parent, const char* name, bool modal):KNewWizard(parent, name, modal){

	standalone = !modal;
	resize(400,400);
	setNewLayout(true);

	myIntroPage = new IntroPage(this);
	myLocPage = new LocationPage(this);
	myModelPage = new ModelPage(this);
	myNetworkPage = new NetworkPage(this);
	myPaperPage = new PaperPage(this);
	myPortPage = new PortPage(this);
	myFinishPage = new FinishPage(this);

	addPage(i18n("Introduction"), 						myIntroPage,   true);
	addPage(i18n("Local/network printer"), 		myLocPage,     true);
	addPage(i18n("Network printer settings"), myNetworkPage, false);
	addPage(i18n("Local printer port"), 			myPortPage,    true);
	addPage(i18n("Printer Model"), 						myModelPage,   true);
	addPage(i18n("Paperformat"), 							myPaperPage,   true);
	addPage(i18n("Finished"), 								myFinishPage,  true);

	getOkButton()->setEnabled(false);

	connect(myLocPage,SIGNAL(isNetPrinter(KpcPrinter::netType)),SLOT(setNetworkSetup(KpcPrinter::netType)));
	connect(myLocPage,SIGNAL(isNetPrinter(KpcPrinter::netType)),myNetworkPage,SLOT(setNetType(KpcPrinter::netType)));
	connect(this,SIGNAL(selected(int)),SLOT(currentPage(int)));
	connect(this,SIGNAL(okclicked()),SLOT(setupPrinter()));
	connect(this,SIGNAL(cancelclicked()),SLOT(cancelSetup()));
	prevPage = 0;
	inCurrentPage = false;
	netSetup = KpcPrinter::local;
	show();
}

KpcWizard::~KpcWizard(){
}

void KpcWizard::setNetworkSetup(KpcPrinter::netType net_type){
	if(net_type == KpcPrinter::local) {
		netSetup = KpcPrinter::local;
		setPageEnabled(2, false);
		setPageEnabled(3, true);
	} else
	if(net_type == KpcPrinter::lpd) {
		netSetup = KpcPrinter::lpd;
		setPageEnabled(2, true);
		setPageEnabled(3, false);
	} else
	if(net_type == KpcPrinter::smb) {
		netSetup = KpcPrinter::smb;
		setPageEnabled(2, true);
		setPageEnabled(3, false);
	}
	
}

void KpcWizard::currentPage(int page){
	int t_prevPage;
  KpcPrinter *myT_prt = new KpcPrinter;
	if( !inCurrentPage ) {
		inCurrentPage = true;
		t_prevPage = prevPage;
		prevPage = page;
  	switch ( page ) {
  		case 0 :			// Intro Page
  			break;
  		case 1 :			// Location Page
  			break;
  		case 2 :			// network Page
				if( t_prevPage == 1 && netSetup == KpcPrinter::local )
  					gotoPage(3);
				else
					if( netSetup == KpcPrinter::local )
						gotoPage(1);
  			break;
  		case 3 :			// Port Page
				if( t_prevPage == 2 && netSetup != KpcPrinter::local )
					gotoPage(4);
				else
					if( netSetup != KpcPrinter::local )
						gotoPage(2);
  			break;
  		case 4 :			// Model Page			
					myPaperPage->disableAll();
  			break;
  		case 5 :			// Paper Page
		
				myT_prt->setModel(myModelPage->getModelName());
				myT_prt->setManufactor(myModelPage->getManufactor());
				myPaperPage->setSupportedPaper(myT_prt->getSupportedPaperFormats());
				break;
  		case 6 :			// Finish Page
				myFinishPage->setPrinter(getSummary());
  			getOkButton()->setEnabled(true);
  			break;
  	}
		inCurrentPage = false;
	}
	else
		prevPage = page;
	getOkButton()->setEnabled(page == 6);
	delete(myT_prt);
}


KpcPrinter KpcWizard::getSummary(){
	KpcPrinter t_kpcPrt;
	if(netSetup != KpcPrinter::local){
		t_kpcPrt.setRemoteMachine(myNetworkPage->getRmMachineName());
		t_kpcPrt.setRemoteQueue(myNetworkPage->getRmSpoolName());
		t_kpcPrt.setManufactor(myModelPage->getManufactor());
		t_kpcPrt.setModel(myModelPage->getModelName());
		t_kpcPrt.setPaperFormat(myPaperPage->getPaperFormat());
		t_kpcPrt.setNetworkType(netSetup);
 	}
	else {
		t_kpcPrt.setModel(myModelPage->getModelName());
		t_kpcPrt.setManufactor(myModelPage->getManufactor());
		t_kpcPrt.setPort(myPortPage->getPort());
		t_kpcPrt.setPaperFormat(myPaperPage->getPaperFormat());
		t_kpcPrt.setNetworkType(KpcPrinter::local);
	}
 return t_kpcPrt;
}

void KpcWizard::setupPrinter(){
	// code follows
	KpcAPI *t_kpcAPI = new KpcAPI();
	KpcPrinter *t_kpcPrt = new KpcPrinter();
	if(netSetup != KpcPrinter::local){
		t_kpcPrt->setRemoteMachine(myNetworkPage->getRmMachineName());
		t_kpcPrt->setRemoteQueue(myNetworkPage->getRmSpoolName());
		t_kpcPrt->setManufactor(myModelPage->getManufactor());
		t_kpcPrt->setModel(myModelPage->getModelName());
		t_kpcPrt->setPaperFormat(myPaperPage->getPaperFormat());
		t_kpcPrt->setNetworkType(netSetup);
		t_kpcAPI->addPrinter((new KpcPrinter(*t_kpcPrt)));
		t_kpcPrt->setDefaultPrinter(myFinishPage->isDefault());
		// and example spool follows....for the wizard you can define some std spools
		// in the kc-module it should be possible to the user to define them!!!
		KpcSpool *t_spool = new KpcSpool((new QString(t_kpcPrt->getDbName()))->append(" remote").data(),false);
		if(!t_kpcPrt->addSpool(new KpcSpool(*t_spool))) exit(-1);
		delete(t_spool);
	}
	else {
		t_kpcPrt->setModel(myModelPage->getModelName());
		t_kpcPrt->setManufactor(myModelPage->getManufactor());
		t_kpcPrt->setPort(myPortPage->getPort());
		t_kpcPrt->setPaperFormat(myPaperPage->getPaperFormat());
		t_kpcPrt->setNetworkType(KpcPrinter::local);
		t_kpcPrt->setDefaultPrinter(myFinishPage->isDefault());
		//t_kpcPrt->setDefaultPrinter(true); please add a checkbox to the wizard
		// here a example how to add spools to a printer
		// either
		/**
		KpcSpool *t_spool = new KpcSpool;
		t_spool->setColor(KpcSpool::color);
		t_spool->setDefaultSpool(true);
		t_spool->setName((new QString(t_kpcPrt->getDbName()))->append(" color").data() );
		t_spool->setPaperFormat(KpcSpool::a4);
		if(!t_kpcPrt->addSpool(new KpcSpool(*t_spool))) exit(-1);
		**/
		// or KpcSpool(name,default queue,type recognition, color/mono, PaperFormat,Xres,Yres);
		if(t_kpcPrt->getSupportedColorRes().count() != 0){
			KpcSpool *t_spool = new KpcSpool((new QString(t_kpcPrt->getDbName()))->data(),myFinishPage->isDefault(),KpcSpool::automatic,KpcSpool::color,myPaperPage->getEnumPaperFormat());
			if(!t_kpcPrt->addSpool(new KpcSpool(*t_spool))) exit(-1);
			delete(t_spool);
		} else {
			KpcSpool *t_spool = new KpcSpool((new QString(t_kpcPrt->getDbName()))->data(),myFinishPage->isDefault(),KpcSpool::automatic,KpcSpool::mono,myPaperPage->getEnumPaperFormat());
			if(!t_kpcPrt->addSpool(new KpcSpool(*t_spool))) exit(-1);
			delete(t_spool);	
		}
		// --
		t_kpcAPI->addPrinter((new KpcPrinter(*t_kpcPrt)));
	}
	t_kpcAPI->sync();
	delete(t_kpcPrt);
	delete(t_kpcAPI);
	if( standalone )
	  kapp->quit();
	else
		done(0);
}

void KpcWizard::cancelSetup(){
	if( standalone )
		kapp->quit();
	else
		done(0);
}













































