/***************************************************************************
    $Id: modelpage.cpp,v 1.5 1999/08/27 16:42:57 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: modelpage.cpp,v $
    Revision 1.5  1999/08/27 16:42:57  wdl
    Standard Headers

 ***************************************************************************/
#include "modelpage.h"

ModelPage::ModelPage(QWidget *parent, const char *name ) : QWidget(parent,name){
	ModelLst = new KTreeList(this);
	ModelLst->setGeometry(170,10,200,height()-20);
  // here comes the printerdb access code....
  readPrinterDB();
	// Help Widget
	Help = new HTMLHelp(this);
	Help->setGeometry(0,0,150,height()-20);
	Help->showHelp("model.html");

	// signal / slot connections
	connect(ModelLst,SIGNAL(highlighted(int)),SLOT(lookItemUp(int)));
		
}

ModelPage::~ModelPage(){
}

void ModelPage::readPrinterDB(){
	KpcAPI *t_kpcAPI = new KpcAPI();
	QString *tmpStr = new QString;
	QString *tmpMan = new QString;
	QList<QString> *tmpLst = new QList<QString>;
	QList<QString> *tmpManLst = new QList<QString>;

	*tmpManLst = t_kpcAPI->getManufactorList();
	for(tmpMan = tmpManLst->first(); tmpMan !=0; tmpMan = tmpManLst->next()){
		KTreeListItem *tmpTreeItem = new KTreeListItem;
		*tmpLst = t_kpcAPI->getPrinterLst(tmpMan->data());
		tmpTreeItem->setText(tmpMan->data());
		tmpTreeItem->setPixmap(new QPixmap(kapp->kde_icondir() + "/mini/folder.xpm"));
		for(tmpStr = tmpLst->first(); tmpStr != 0; tmpStr = tmpLst->next()){
			tmpTreeItem->appendChild(new KTreeListItem(tmpStr->data(), new QPixmap(kapp->kde_icondir() + "/mini/printer.xpm")));
		}
		ModelLst->insertItem(tmpTreeItem);
	}
	delete(t_kpcAPI); delete(tmpStr); delete(tmpLst); //delete(tmpTreeItem);
	delete(tmpManLst); delete(tmpMan);
}

//Del by KDevelop: void ModelPage::enable(bool val){
//Del by KDevelop: 	setEnabled(val);
//Del by KDevelop: 	ModelLst->setEnabled(val);
//Del by KDevelop: 	if(!val) Help->showHelp("nothing.html");
//Del by KDevelop: 	if(val) Help->showHelp("model.html");
//Del by KDevelop: }

void ModelPage::lookItemUp(int num){
	if(ModelLst->getCurrentItem()->getParent()->getText() != 0) {
		Manufactor = ModelLst->getCurrentItem()->getParent()->getText();
		ModelName = ModelLst->getCurrentItem()->getText();	
  } else { ModelName = 0; Manufactor = 0;  }
}

void ModelPage::resizeEvent(QResizeEvent *){
	Help->setGeometry(0,10,150,height()-20);	
	ModelLst->setGeometry(170,10,200,height()-20);
}

















