/***************************************************************************
    $Id: networkpage.cpp,v 1.4 1999/09/23 16:06:31 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: networkpage.cpp,v $
    Revision 1.4  1999/09/23 16:06:31  stephan
    Minor changes in kpcwizard

    Revision 1.3  1999/08/27 16:42:57  wdl
    Standard Headers

 ***************************************************************************/
#include "networkpage.h"

NetworkPage::NetworkPage(QWidget *parent, const char *name ) : QWidget(parent,name){
	RmMachineName = new KLined(this);
	RmMachineName->setGeometry(270,100,100,25);
	RmSpoolName = new KLined(this);
	RmSpoolName->setGeometry(300,130,70,25);
	lab1 = new QLabel("Remote Machine:",this);
	lab1->setGeometry(170,100,100,25);
	lab2 = new QLabel("Remote Spool Name:",this);
	lab2->setGeometry(170,130,120,25);

	Help = new HTMLHelp(this);
	Help->setGeometry(0,0,150,height());
	Help->showHelp("network.html");
}

NetworkPage::~NetworkPage(){
}

void NetworkPage::setNetType(KpcPrinter::netType net_type){
	if(net_type == KpcPrinter::lpd) {
		lab1->setText("Remote Machine:");
		lab2->setText("Remote Spool Name:");
	} else
	if(net_type == KpcPrinter::smb) {
		lab1->setText("Machine:");
		lab2->setText("Service:");
	}
	
}

bool NetworkPage::isDataComplete(){
	QString *tmp1,*tmp2;
	tmp1 = new QString(RmMachineName->text());
	tmp2 = new QString(RmSpoolName->text());
	if((!tmp1->isEmpty())&&(!tmp2->isEmpty())){ return true; }
	return false;
}

//Del by KDevelop: void NetworkPage::enable(bool val){
//Del by KDevelop: 		setEnabled(val);
//Del by KDevelop: 		RmMachineName->setEnabled(val);
//Del by KDevelop: 		RmSpoolName->setEnabled(val);
//Del by KDevelop: 		lab1->setEnabled(val);
//Del by KDevelop: 		lab2->setEnabled(val);
//Del by KDevelop: 		if(val) Help->showHelp("network.html");
//Del by KDevelop: 		if(!val) Help->showHelp("nothing.html");
//Del by KDevelop: }

void NetworkPage::resizeEvent(QResizeEvent *){
	Help->setGeometry(0,10,150,height()-20);	
}

















