/***************************************************************************
    $Id: paperpage.cpp,v 1.6 1999/10/01 17:42:28 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: paperpage.cpp,v $
    Revision 1.6  1999/10/01 17:42:28  stephan
    Bughunting.

    Revision 1.5  1999/09/19 09:03:14  stephan
    Paperformats are now taken from the db

    Revision 1.4  1999/08/27 16:42:58  wdl
    Standard Headers

 ***************************************************************************/
#include "paperpage.h"

PaperPage::PaperPage(QWidget *parent, const char *name ) : QWidget(parent,name) {
	buttonGrp = new QButtonGroup(this);
	buttonGrp->setFrameStyle(0);
	buttonGrp->setGeometry(170,10,200,200);
	def = new QRadioButton(i18n("default (recommend)"),buttonGrp);
	def->setGeometry(0,50,180,25);
	def->setChecked(true);
	a3 = new QRadioButton(i18n("A3"),buttonGrp);
	a3->setGeometry(0,80,180,25);
	a3->setEnabled(false);
	a4 = new QRadioButton(i18n("A4"),buttonGrp);
	a4->setGeometry(0,110,180,25);
	a4->setEnabled(false);
	a5 = new QRadioButton(i18n("A5"),buttonGrp);
	a5->setGeometry(0,140,180,25);
	a5->setEnabled(false);
	letter = new QRadioButton(i18n("Letter"),buttonGrp);
	letter->setGeometry(0,170,180,25);
	letter->setEnabled(false);
	legal = new QRadioButton(i18n("Legal"),buttonGrp);
	legal->setGeometry(0,200,180,25);
	legal->setEnabled(false);
	buttonGrp->insert(def);
	buttonGrp->insert(a3);
	buttonGrp->insert(a4);
	buttonGrp->insert(a5);
	buttonGrp->insert(letter);	
	buttonGrp->insert(legal);

	Help = new HTMLHelp(this);
	Help->setGeometry(0,0,150,height());
	Help->showHelp("paper.html");
}

PaperPage::~PaperPage(){
}

const char * PaperPage::getPaperFormat(){
	if (def->isChecked()) return "default";
	if (a4->isChecked()) return "A4";
	if (a5->isChecked()) return "A5";
	if (a3->isChecked()) return "A3";
	if (legal->isChecked()) return "Legal";
	return "Letter";
}
KpcSpool::paperFormat PaperPage::getEnumPaperFormat(){
	if (def->isChecked()) return KpcSpool::def;
	if (a4->isChecked()) return KpcSpool::a4;
	if (a3->isChecked()) return KpcSpool::a3;
	if (a5->isChecked()) return KpcSpool::a5;
	if (letter->isChecked()) return KpcSpool::Letter;
	return KpcSpool::legal;	
}

void PaperPage::setSupportedPaper(QList<QString> _sup){
	QString *t_str = new QString;
	for(t_str = _sup.first(); t_str != 0; t_str = _sup.next()){
		if(strcmp(t_str->lower().data(),"a3") == 0) a3->setEnabled(true);
  	if(strcmp(t_str->lower().data(),"a4") == 0) a4->setEnabled(true);
		if(strcmp(t_str->lower().data(),"a5") == 0) a5->setEnabled(true);
		if(strcmp(t_str->lower().data(),"letter") == 0) letter->setEnabled(true);
		if(strcmp(t_str->lower().data(),"legal") == 0) legal->setEnabled(true);
	}
	delete(t_str);
}

void PaperPage::disableAll(){
 legal->setEnabled(false);
 letter->setEnabled(false);
 a3->setEnabled(false);
 a4->setEnabled(false);
 a5->setEnabled(false);
}

void PaperPage::resizeEvent(QResizeEvent *){
	Help->setGeometry(0,10,150,height()-20);	
}



