/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <stdio.h>

#include "devscanner.h"


DeviceScanner::DeviceScanner()
{

}


/*
 * Protected methods
 ********************/

uint  DeviceScanner::ioRange(uint ioaddr)
{
  FILE  *fhd;
  uint  iostart, ioend;
  char  buffer[128];
  
  if ((fhd = fopen("/proc/ioports", "r")))
  {
    while (fgets(buffer, sizeof(buffer), fhd))
    {
      sscanf(buffer, "%04x", &iostart);
      
      if (iostart == ioaddr)
      {
        fclose(fhd);
	sscanf(buffer+5, "%04x", &ioend);
	
	return ioend-iostart+1;
      }
    }
    
    fclose(fhd);
  }
  
  return 1;
}
 
