/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __RESOURCE_H
#define __RESOURCE_H

#include <sys/types.h>

#include <qstring.h>


class Resource
{
  public:
  
    enum restype  { Unknown,
    		    ResDMAPort,
    		    ResInterrupt,
		    ResIOAddress,
		    ResMemAddress };
		    
    Resource();
    Resource(ulong);
    virtual ~Resource() {}
    
    bool    operator==(const Resource&);
    
    virtual QString  resourceName() const = 0;
    virtual restype  resourceType() const = 0;
    
    void    setResourceRange(ulong rrng) { _resrng = rrng; }
    void    setResourceValue(ulong rval) { _resval = rval; }
    ulong   resourceRange() const        { return _resrng; }
    ulong   resourceValue() const        { return _resval; }
    
  protected:
  
    ulong  _resval, _resrng;
};


#endif
