/***************************************************************************
                          kappllistbox.h  -  description                              
                             -------------------                                         
    begin                : Fri Aug 27 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KAPPLLISTBOX_H
#define KAPPLLISTBOX_H

#include <qlistview.h>
#include <qstrlist.h>
#include <qlist.h>

#include "kappldialogitem.h"

/**
  * This class provides the list box for the Application Dialog. It is derived from the QListView
  * and overloads some functions for own representations.
  * @author Geri House
  */

typedef Q_DECLARE(QListM,KApplDialogItem)          KAppList;

class KApplListBox : public QListView  {
public: 
  	/** Constructor */
	KApplListBox(QWidget * parent = 0, const char * name = 0);
  	/** Destructor */
	~KApplListBox();
  	/** overloaded  for mouse Press Event */
	virtual void mousePressEvent ( QMouseEvent * e );
  	/** For getting the Application List */
	KAppList getAppList() { return selectedApp;}
  	/** For clearing the Application List */
	void clearAppList();
private:
	KAppList selectedApp;
};

#endif









