/***************************************************************************
    kuninstaller.cpp  -  Source file of class KUninstallerApp
    ------------------------------------------------------------------------
    begin                : Wed Mar 10 08:47:08 MET 1999
                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlistbox.h>
#include <qcombo.h>

#include <kseparator.h>

#include "kuninstaller.h"
#include "kuninstalleroption.h"


KUninstallerApp::KUninstallerApp()
{
  setCaption("KUninstaller " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();
  if (view->isSaveUninstalling()==true)
  	 enableCommand(ID_BACKUP);

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
//  resize( 400, 460 );

}

KUninstallerApp::~KUninstallerApp()
{
  
}

void KUninstallerApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KUninstallerApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KUninstallerApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/kuninstallerapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("C&lose Window"), ID_FILE_CLOSE_WINDOW);
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("exit.xpm"), i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  edit_menu = new QPopupMenu();
  edit_menu->insertItem(Icon("search.xpm"), i18n("&Search"), ID_SEARCH);
  edit_menu->insertItem(Icon("stop.xpm"), i18n("S&top"), ID_STOP);
  edit_menu->insertItem(Icon("delete.xpm"), i18n("&Remove"), ID_REMOVE);
  edit_menu->insertItem(Icon("reload.xpm"), i18n("&Wipe off"), ID_NEW);
  edit_menu->insertSeparator();
  edit_menu->insertItem(Icon("undo.xpm"), i18n("&Undo Remove"), ID_UNDO);
  edit_menu->insertSeparator();
  edit_menu->insertItem(Icon("configure.xpm"), i18n("&Configuration"), ID_CONFIGURE);
  edit_menu->insertItem(Icon("mini/kfm_fulltrash.xpm"), i18n("&Delete Backups"), ID_BACKUP);
  edit_menu->setItemEnabled(ID_REMOVE, FALSE);
  edit_menu->setItemEnabled(ID_NEW, FALSE);
  edit_menu->setItemEnabled(ID_UNDO, FALSE);
  edit_menu->setItemEnabled(ID_STOP, FALSE);
  edit_menu->setItemEnabled(ID_BACKUP, FALSE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Commands"), edit_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(edit_menu);
  CONNECT_CMD(view_menu);

}
void KUninstallerApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print the List"));
//  toolBar()->insertLineSeparator();
  toolBar()->insertButton(Icon("search.xpm"), ID_SEARCH, true, i18n("Search for Application"));
  toolBar()->insertButton(Icon("stop.xpm"), ID_STOP, false, i18n("Stop searching"));
  toolBar()->insertButton(Icon("delete.xpm"), ID_REMOVE, false, i18n("Remove Application"));
  toolBar()->insertButton(Icon("reload.xpm"), ID_NEW, false, i18n("Wipe of search results"));
  toolBar()->insertButton(Icon("undo.xpm"), ID_UNDO, false, i18n("Undo last Uninstalling"));
//  toolBar()->insertLineSeparator();
  toolBar()->insertButton(Icon("configure.xpm"), ID_CONFIGURE, true, i18n("Configure application"));
  toolBar()->insertButton(Icon("mini/kfm_fulltrash.xpm"), ID_BACKUP, false, i18n("Delete Backups"));
  toolBar()->insertButton(Icon("exit.xpm"), ID_FILE_QUIT, true, i18n("Exit the Application"));
//  toolBar()->insertLineSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));
  toolBar()->alignItemRight(ID_HELP);
  toolBar()->alignItemRight(ID_FILE_QUIT);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

void KUninstallerApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void KUninstallerApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  view = new KUninstallerView(kapp,this);
  setView(view);
}

bool KUninstallerApp::queryExit()
{
  int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"), KMsgBox::QUESTION);

  if(exit==1)
    return TRUE;
  else
    return FALSE;
}

void KUninstallerApp::resizeEvent( QResizeEvent *e) {
    view->resizeEvent(e);
    KTMainWindow::resizeEvent(e);
}

void KUninstallerApp::saveOptions()
{
  KConfig *config = kapp->getConfig();
  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());
  config->writeEntry("WindowSize", size());
  view->saveOptions(config);

}

void KUninstallerApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();
  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);
  QSize *s=new QSize(570,500);
  resize(config->readSizeEntry("WindowSize", s));
  view->readOptions(config);

}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KUninstallerApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KUninstallerApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  QStrList *strList=view->getTextForPrinting();
  if (strList!=0 && printer.setup(this)) {
      QPainter painter;

      ///////////////////////////////////////////////////////////////////
      // TODO: Define printing by using the QPainter methods here
     	  painter.begin( &printer );
      	  painter.setFont( QFont("times", 12, QFont::Bold) );
      	  char *str=strList->first();
   	      painter.drawText( 50,30, str );      	
     	  painter.setFont( QFont("times", 12) );
     	  int i=1;
   	      str=strList->next();
   	      while(str!=0) {
     	      painter.drawText( 70,30+i*20, str );
     	      str=strList->next();
     	      if (i%39==0 && str!=0) {
     	      	printer.newPage();
     	      	i=1;
     	      }
     	      else
     	      	i++;  	
      	  }
      	  painter.end();
      	  delete strList;
  }

  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotFileCloseWindow()
{
  close();
}
void KUninstallerApp::slotFileQuit()
{ 
  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(queryExit()==TRUE) {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
  }
  else
    slotStatusMsg(IDS_DEFAULT);
}


void KUninstallerApp::slotSearch() {
  slotStatusMsg(i18n("Searching for Application parts..."));
  enableCommand(ID_STOP);
  disableCommand(ID_SEARCH);
  if (view->search()!=0) {
     enableCommand(ID_REMOVE);
     enableCommand(ID_NEW);
  }
  disableCommand(ID_STOP);
  enableCommand(ID_SEARCH);
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotNew() {
  slotStatusMsg(i18n("Wipe off the Application parts..."));
  view->wipeOff();
  disableCommand(ID_REMOVE);
  disableCommand(ID_NEW);
  if (view->isSaveUninstalling()==true)
  	  disableCommand(ID_UNDO);
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotUndo() {
  slotStatusMsg(i18n("Undos the last removing Action..."));
  view->undo();
  if (view->isSaveUninstalling()==true)
  	  disableCommand(ID_UNDO);
  enableCommand(ID_NEW);
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotStop() {
  slotStatusMsg(i18n("Stops searching for Application parts..."));
  view->stop();
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotRemove() {
  	slotStatusMsg(i18n("Removing the Application parts..."));
  	if (view->remove()!=0) {
  		disableCommand(ID_REMOVE);
  		disableCommand(ID_NEW);
  		if (view->isSaveUninstalling()==true)
  	  		enableCommand(ID_UNDO);
  }
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotConfigure() {
	KUninstallerOption *dialog = new KUninstallerOption(0,"configure", true);
	if (dialog->exec()==QDialog::Accepted) {
  		KConfig *config = kapp->getConfig();
  		view->readOptions(config);
  		view->showBackupBox();
  		if (view->isSaveUninstalling()==true)
  			enableCommand(ID_BACKUP);
  		else	
  			disableCommand(ID_BACKUP);
	}
}

void KUninstallerApp::slotBackup() {
  slotStatusMsg(i18n("Removing all Application Backups..."));
  view->removeAllBackups();	
  disableCommand(ID_UNDO);
  slotStatusMsg(IDS_DEFAULT);
}

void KUninstallerApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

void KUninstallerApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KUninstallerApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KUninstallerApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KUninstallerApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_PRINT,               slotFilePrint())
    ON_CMD(ID_FILE_CLOSE_WINDOW,        slotFileCloseWindow())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_SEARCH,                   slotSearch())
    ON_CMD(ID_STOP,                     slotStop())
    ON_CMD(ID_REMOVE,                   slotRemove())
    ON_CMD(ID_NEW,                      slotNew())
    ON_CMD(ID_UNDO,                     slotUndo())

    ON_CMD(ID_CONFIGURE,                slotConfigure())
    ON_CMD(ID_BACKUP,               	slotBackup())

    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
  }
}

void KUninstallerApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,   i18n("Opens a new application window"))
    ON_STATUS_MSG(ID_FILE_PRINT,        i18n("Prints the application list"))
    ON_STATUS_MSG(ID_FILE_CLOSE_WINDOW, i18n("Closes the current window"))
    ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))

    ON_STATUS_MSG(ID_SEARCH,            i18n("Searches for all application parts"))
    ON_STATUS_MSG(ID_STOP,              i18n("Stops searching for application"))
    ON_STATUS_MSG(ID_REMOVE,            i18n("Removes all selected application parts"))
    ON_STATUS_MSG(ID_NEW,               i18n("Wipes off the searching results"))
    ON_STATUS_MSG(ID_UNDO,              i18n("Undos the last Uninstalling action"))

    ON_STATUS_MSG(ID_CONFIGURE,         i18n("Configuration of the application"))
    ON_STATUS_MSG(ID_BACKUP,      	    i18n("Delete all Application Backups"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))
  }
}














































































































