/***************************************************************************
    kuninstalllistitem.cpp  -  Source file of class KUninstallListItem
    ------------------------------------------------------------------------
    begin                : Wed Mar 17 1999
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kiconloader.h>

#include "kuninstalllistitem.h"
#include "kuninstalllistview.h"
#include "kuninstallerview.h"

static QString * s = 0;
static const QPixmap *pix=0;

KUninstallListItem::KUninstallListItem(QFileInfo f, QCheckListItem * parent, const char * txt, QCheckListItem::Type typ)
:QCheckListItem(parent, txt, typ) {
	finfo=f;
}

KUninstallListItem::KUninstallListItem(QFileInfo f, QListView * parent, const char * txt, QCheckListItem::Type  typ)
:QCheckListItem(parent, txt, typ) {
	finfo=f;
}

KUninstallListItem::KUninstallListItem(QFileInfo f, QListViewItem * parent, const char * txt, const QPixmap & pix)
:QCheckListItem(parent, txt, pix) {
	finfo=f;
}

KUninstallListItem::KUninstallListItem(QFileInfo f, QListView * parent, const char * txt, const QPixmap & pix)
:QCheckListItem(parent, txt, pix) {
	finfo=f;
}

KUninstallListItem::~KUninstallListItem(){
}

void KUninstallListItem::checkAllChilds(bool setOpen) {
	if (childCount()!=0) {
		KUninstallListItem* first= (KUninstallListItem*) firstChild();
		while (first!=0) {
			first->setOn(setOpen);
			first->checkAllChilds(setOpen);
			first=(KUninstallListItem*)first->nextSibling();
		}
	}
}


float KUninstallListItem::getSizeAndNumber(int &number) {
    float size=0;
    number=0;
    if (childCount()!=0) {
 		KUninstallListItem* first= (KUninstallListItem*) firstChild();
		while (first!=0) {
		    if (first->isOn()==TRUE) {
		        int childnum=0;
			    size+=first->getSizeAndNumber(childnum);
			    number+=childnum;
			}
			first=(KUninstallListItem*)first->nextSibling();
		}   	
    }
    else {
    	size=finfo.size();
    	number=1;
    }	
    return size;
}

const char * KUninstallListItem::text( int column ) const  {
	if (s==0)
		s = new QString(100);
    *s="";
    if (depth()>0) {
		if (column==0)
			s->append(QListViewItem::text(0));
		else {
		    int number=0;
			float fsize=getSizeAndNumber(number);
			KUninstallerView* view= (KUninstallerView*) listView()->parentWidget();
			s->append(view->size2Ascii(fsize));
		}	
	}
	else
		s->append(QListViewItem::text(column));
	return *s;
}

const char * KUninstallListItem::text() const  {
	return text(0);
}

const QPixmap * KUninstallListItem::pixmap ( int column ) const {
    if (pix==0)
    	pix=new QPixmap();
	if (!column && parent()!=0) {
		if (finfo.isDir())
			*pix=kapp->getIconLoader()->loadIcon("mini/folder.xpm");
		else if (finfo.extension()=="xpm" || finfo.extension()=="bmp")
			*pix=kapp->getIconLoader()->loadIcon("mini/xpaint.xpm");
		else
			*pix=kapp->getIconLoader()->loadIcon("mini/unknown.xpm");	
		return pix;
	}
	else
		return QListViewItem::pixmap(column);
}

void KUninstallListItem::showChildItems()  {
    if (childCount()==0) {
		QDir dir(finfo.absFilePath());
		if (dir.exists()==TRUE && dir.isReadable()==TRUE) {
			dir.setFilter(QDir::Dirs | QDir::Hidden | QDir::Files);
	    	const QFileInfoList *strList = dir.entryInfoList();
			QFileInfo *f=strList->first();
			while (f!=0) {
				if (f->fileName()!="." && f->fileName()!="..")  {
					KUninstallListItem *newChild = new KUninstallListItem(*f, this,f->fileName(), QCheckListItem::CheckBox);
					newChild->setOn(isOn());				
					if (f->isDir()==TRUE)
						newChild->showChildItems();
				}
				f=strList->next();
			}			
		}
	}
}






































