/*

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Frithjof Brestrich
                       brestrich@kde.org


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _KVIDTUNECFG_H_
#define _KVIDTUNECFG_H_

#include <qstring.h>

class KVidTuneCfg 
{
  Q_OBJECT;
  
public:

  KVidTuneCfg();
  ~KVidTuneCfg();

  void configLoad();
  void configStore();

public:
 
  /* variables stored in the kvidtune configuration file */
  bool            cfgDisplayWarning;
  bool            cfgNeedConfigInfo;
  bool            cfgWarnIfNotLocal;
  QString         cfgConfigFile;
  QString         cfgWorkingDirectory;
  bool            cfgHideNonActiveModeLines;

  /* system environment variables */
  QString         displayName;
  QString         hostName;
};

#endif
