#include <kapp.h>
#include <klocale.h>
#include "XFont.h"
#include "listefolder.h"
#include <qdir.h>
#include <qlistbox.h>
#include <kconfig.h>
#include <qstrlist.h>
#include <kiconloader.h>

XFont::XFont(QWidget *parent, const char *name) : QWidget(parent, name) {

  KConfig * fichier = new KConfig(NULL,"xfreeconfig");
  QStrList  ListeFonte ;
  modified=FALSE;
/*frame du haut*/
	QFrame *tmp1;
	tmp1 = new QFrame ( this, "QFrame1");
	tmp1->setCaption( "" );
	tmp1->setGeometry( 4, 4, 341, 177 );
	tmp1->setMinimumSize( 0, 0 );
	tmp1->setMaximumSize( 32767, 32767 );
	tmp1->setMouseTracking( FALSE);
	tmp1->setSizeIncrement( 0, 0 );
	tmp1->setLineWidth( 1 );
	tmp1->setMidLineWidth( 0 );
	tmp1->setFrameStyle( QFrame::Panel | QFrame::Raised );

	ListFontSelected = new QListBox ( tmp1);
	ListFontSelected->setGeometry( 8, 20, 325, 150 );
  fichier -> setGroup("Fonts");
  fichier -> readListEntry( "FontPath", ListeFonte , ';');
  if( ListeFonte.count() > 0 )
  {
    for (unsigned int n = 0; n < ListeFonte.count() ; n++)
      ListFontSelected->insertItem(ListeFonte.at(n));
  }
  else
  {
    modified=TRUE;
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/misc/");
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/75dpi/:unscaled");
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/100dpi/:unscaled");
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/Type1/");
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/Speedo/");
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/75dpi/");
    ListFontSelected->insertItem("/usr/X11R6/lib/X11/fonts/100dpi/");
  }
	LFrFont = new QLabel ( this, "");
	LFrFont->setCaption( "" );
	LFrFont->setGeometry( 12, 5, 125, 17 );
	LFrFont->setMinimumSize( 0, 0 );
	LFrFont->setMaximumSize( 32767, 32767 );
	LFrFont->setFont( QFont( "utopia", 12, 75, 1));
	LFrFont->setMouseTracking( FALSE);
	LFrFont->setSizeIncrement( 0, 0 );
	LFrFont->setLineWidth( 1 );
	LFrFont->setMidLineWidth( 0 );
	LFrFont->setText(klocale->translate( "Fonts Path") );
	LFrFont->setMargin( -1 );
	LFrFont->setAlignment( AlignHCenter | AlignVCenter | ExpandTabs | ShowPrefix );
	LFrFont->setAutoResize( FALSE );
	LFrFont->setBuddy( LFrFont );


/*sparation de la fenetre*/
	QFrame *tmp5;
	tmp5 = new QFrame ( this, "QFrame2");
  tmp5->setGeometry( -4, 184, 453, 9 );
	tmp5->setLineWidth( 1 );
	tmp5->setFrameStyle( QFrame::HLine | QFrame::Raised );
/*frame du bas (rpertoire) */
	FFileDial = new QFrame ( this, "FFileDial");
	FFileDial->setCaption( "" );
	FFileDial->setGeometry( 4, 196, 341, 161 );
	FFileDial->setMinimumSize( 0, 0 );
	FFileDial->setMaximumSize( 32767, 32767 );
	FFileDial->setMouseTracking( FALSE);
	FFileDial->setSizeIncrement( 0, 0 );
	FFileDial->setLineWidth( 1 );
	FFileDial->setMidLineWidth( 0 );
	FFileDial->setFrameStyle( QFrame::Panel | QFrame::Raised );

  StrPath="/usr/X11R6/lib/X11/fonts";

	FileDialog = new QListBox ( FFileDial, "FileDialog");
	FileDialog->setGeometry( 8, 12, 321, 137 );
  init_folder(StrPath);
  connect(FileDialog,SIGNAL(selected( int )), SLOT (slotchangedir( int )) );


/*zone des boutons*/
  KIconLoader IL;
	LPixmap = new QLabel ( this, "");
	LPixmap->setGeometry( 364, 8, 65, 53 );

  LPixmap->setPixmap(IL.loadIcon("font.xpm"));
	LPixmap->setAlignment( AlignHCenter | AlignVCenter | ExpandTabs | ShowPrefix );

	PushUpFont = new QPushButton ( this , "");
	PushUpFont->setText(klocale->translate( "Up") );
  PushUpFont->setGeometry( 360, 96, 73, 21 );
  connect(PushUpFont, SIGNAL (clicked()), SLOT(slotup()) );

	PushDownFont = new QPushButton ( this , "");
	PushDownFont->setGeometry( 360, 120, 73, 21 );
	PushDownFont->setText( klocale->translate("Down") );
  connect(PushDownFont, SIGNAL(clicked()), SLOT(slotdown()) );

	PushSupFont = new QPushButton ( this , "");
	PushSupFont->setCaption( "" );
	PushSupFont->setGeometry( 360, 156, 73, 21 );
	PushSupFont->setMinimumSize( 0, 0 );
	PushSupFont->setMaximumSize( 32767, 32767 );
	PushSupFont->setMouseTracking( FALSE);
	PushSupFont->setSizeIncrement( 0, 0 );
	PushSupFont->setText( klocale->translate("Delete") );
	PushSupFont->setAutoResize( FALSE );
	PushSupFont->setAutoRepeat( FALSE );
	PushSupFont->setToggleButton( FALSE );
	PushSupFont->setAutoDefault( FALSE );
  connect(PushSupFont,SIGNAL(clicked()), SLOT(slotremovefont()));

	PushAddFont = new QPushButton ( this , "");
	PushAddFont->setCaption( "" );
	PushAddFont->setGeometry( 360, 200, 73, 21 );
	PushAddFont->setMinimumSize( 0, 0 );
	PushAddFont->setMaximumSize( 32767, 32767 );
	PushAddFont->setMouseTracking( FALSE);
	PushAddFont->setSizeIncrement( 0, 0 );
	PushAddFont->setText( klocale->translate( "&Add") );
	PushAddFont->setAutoResize( FALSE );
	PushAddFont->setAutoRepeat( FALSE );
	PushAddFont->setToggleButton( FALSE );
	PushAddFont->setAutoDefault( FALSE );
  connect(PushAddFont,SIGNAL(clicked()),SLOT(slotaddfont()));

}

XFont::~XFont() {

}






void XFont::init_folder( QString path)
{
 KIconLoader IL;
 QDir p(path.data());
 unsigned int n;
 p.setFilter(QDir :: Dirs);

 ListeFolder *liste ;
  FileDialog -> clear();

 liste = new ListeFolder ("..",IL.loadIcon("folder.xpm"));

 FileDialog->insertItem(liste,0);

 for(n=2; n<p.count(); n++)
  {
    liste= new ListeFolder (p[n], IL.loadIcon("folder.xpm"));
    FileDialog->insertItem(liste,-1);
  }

}


void XFont::slotchangedir(int rang)
{
 printf("slotchangedir()\n");
 QString NewPath;
 if (rang==0)
 {
   NewPath=StrPath;
   NewPath.truncate(StrPath.findRev('/',strlen( StrPath.data()) ) );
   if (strlen(NewPath.data()) == 0   )
     NewPath.sprintf("/");
 }
 else
 {
   NewPath.sprintf("%s/%s",StrPath.data(),FileDialog->text(rang));
 }

 init_folder( NewPath);
 StrPath=NewPath;
}

void XFont::slotremovefont()
{
 if(ListFontSelected->currentItem()>=0)
    ListFontSelected->removeItem(ListFontSelected->currentItem());
 modified=TRUE;
}

void XFont::slotaddfont()
{
  QString StrAdd;
  if ( FileDialog->currentItem() >=0 )
  {
    StrAdd.sprintf("%s/%s/",StrPath.data(),FileDialog->text(FileDialog->currentItem()) );
    ListFontSelected->insertItem(StrAdd);
   }
  modified=TRUE;
}

void XFont::slotup()
{
 if ( ListFontSelected->currentItem() >0)
 {
    QString  tmp = ListFontSelected->text(ListFontSelected->currentItem());
    QString tmp1 = ListFontSelected->text(ListFontSelected->currentItem()-1);
    ListFontSelected->changeItem(tmp, ListFontSelected->currentItem()-1);
    ListFontSelected->changeItem(tmp1 ,ListFontSelected->currentItem());
    ListFontSelected->setSelected(ListFontSelected->currentItem()-1, TRUE );
 }
 modified=TRUE;
}

void XFont::slotdown()
{
 if ((unsigned)ListFontSelected->currentItem() < ListFontSelected->count()-1)
 {
    QString  tmp = ListFontSelected->text(ListFontSelected->currentItem());
    QString tmp1 = ListFontSelected->text(ListFontSelected->currentItem()+1);
    ListFontSelected->changeItem(tmp, ListFontSelected->currentItem()+1);
    ListFontSelected->changeItem(tmp1 ,ListFontSelected->currentItem());
    ListFontSelected->setSelected(ListFontSelected->currentItem()+1, TRUE );
 }
 modified=TRUE;
}

/*enregistrement des param*/
void XFont::writeconfig()
{
 QStrList ListeFont ;
 if(modified == TRUE)
 {
  for (unsigned int n = 0; n < ListFontSelected->count() ; n++)
    ListeFont.insert(n,ListFontSelected->text(n));

  KConfig * fichier = new KConfig(NULL, "xfreeconfig");
  fichier -> setGroup("Fonts");
  fichier-> writeEntry("FontPath",ListeFont,';');
  fichier->sync();
  delete fichier; // delete fichier;
  modified=FALSE;
 }
}

















