#include <kapp.h>
#include <klocale.h>
#include "custon.h"
#include <qpixmap.h>
#include <qbttngrp.h>
#include <qmessagebox.h>
#include <kiconloader.h>


custom::custom(QString MM, QString MT, QString HS, QString VS, char * Res, QWidget *parent, const char *name) : QDialog(parent, name, TRUE)
{
  KIconLoader iconLoader;
  if ((HS =="") && (VS==""))
       QMessageBox::warning(this,"Attention", "La saisie de mauvaises valeurs de frquence de balayage\npeut entrainner la destruction du moniteur.\nEt je n'en serais pas responsable " ,"&Ok");
  QFont f;
/*cration de la frame gnrale */
	FCustom = new QFrame ( this, "FCustom");
	FCustom->setGeometry( 0, 4, 437, 209 );
	FCustom->setLineWidth( 1 );
	FCustom->setFrameStyle( QFrame::Panel | QFrame::Raised );

  QLabel * pixmap = new QLabel(FCustom);
  pixmap -> setPixmap(iconLoader.loadIcon("custom.xpm"));
  pixmap -> setGeometry(10,15,40,40);

/*info moniteur */
	QFrame *tmp15;
	tmp15 = new QFrame ( FCustom, "QFrame2");
	tmp15->setGeometry( 68, 16, 357, 81 );
	tmp15->setMaximumSize( 32767, 32767 );
	tmp15->setLineWidth( 1 );
	tmp15->setFrameStyle( QFrame::Box | QFrame::Sunken );

	QLabel *tmp16;
	tmp16 = new QLabel ( tmp15, "");
	tmp16->setGeometry( 10, 12, 121, 21 );
	tmp16->setText(klocale->translate( "Monitor Vendor" ));
	tmp16->setAlignment( AlignLeft | AlignVCenter | ExpandTabs );

	QLabel *tmp17;
	tmp17 = new QLabel ( tmp15, "");
	tmp17->setGeometry( 10, 40, 117, 21 );
	tmp17->setText(klocale->translate("Description") );
	tmp17->setAlignment( AlignLeft | AlignVCenter | ExpandTabs );


	LMarque = new QLineEdit ( tmp15, "Marque" );
	LMarque->setGeometry( 144, 12, 201, 21 );
	LMarque->setText( MM );
	LMarque->setEchoMode( QLineEdit::Normal );

	LType = new QLineEdit ( tmp15, "Type" );
  if (MT !="Personnalis ..." )
   	LType->setText( MT );
	LType->setGeometry( 144, 44, 201, 21 );
	LType->setEchoMode( QLineEdit::Normal );





/*la zone des frequence*/
	FBalayage = new QFrame ( FCustom, "FBalayage");
	FBalayage->setGeometry( 8, 112, 209, 77 );
	FBalayage->setLineWidth( 1 );
	FBalayage->setFrameStyle( QFrame::Box | QFrame::Sunken );

	QLabel *tmp3;
	tmp3 = new QLabel ( FBalayage, "");
	tmp3->setGeometry( 8, 12, 93, 21 );
	tmp3->setText(klocale->translate( "Horizontal KHz" ));
	tmp3->setAlignment( AlignRight | AlignVCenter | ExpandTabs );

	LHSync = new QLineEdit ( FBalayage, "QLineEdit1" );
	LHSync->setGeometry( 104, 12, 97, 21 );
	LHSync->setText( HS );
	LHSync->setFrame( TRUE );
	LHSync->setEchoMode( QLineEdit::Normal );

	QLabel *tmp5;
	tmp5 = new QLabel ( FBalayage, "");
	tmp5->setGeometry( 20, 40, 81, 21 );
	tmp5->setText(klocale->translate( "Vertical Hz") );
	tmp5->setAlignment( AlignRight | AlignVCenter | ExpandTabs );

	LVSync = new QLineEdit ( FBalayage, "QLineEdit2" );
	LVSync->setGeometry( 104, 40, 97, 21 );
	LVSync->setFrame( TRUE );
  LVSync->setText(VS);
	LVSync->setEchoMode( QLineEdit::Normal );

	QLabel *tmp14;
	tmp14 = new QLabel ( FCustom, "");
	tmp14->setGeometry( 12, 100, 143, 21 );
  f.setBold(true);
	tmp14->setFont( f);
	tmp14->setText( klocale->translate(" Scanning Frequency") );
	tmp14->setAlignment( AlignLeft | AlignVCenter | ExpandTabs );

/*liste des rsolution max*/
  QString ActiveRes;
  ActiveRes.sprintf("%s",Res);
	QButtonGroup *GrpRes;
	GrpRes = new QButtonGroup ( klocale->translate(" Max Resolution "),FCustom, "QFrame1");
  GrpRes -> setFont(f);
	GrpRes->setGeometry( 220, 105, 207, 83 );
	GrpRes->setFrameStyle( QFrame::Box | QFrame::Sunken );
	QRadioButton *_640;
	_640 = new QRadioButton ( GrpRes);
	QRadioButton *_800;
	_800 = new QRadioButton ( GrpRes);
	QRadioButton *_1024;
	_1024 = new QRadioButton ( GrpRes);
	QRadioButton *_1152;
	_1152 = new QRadioButton ( GrpRes);
	QRadioButton *_1280;
	_1280 = new QRadioButton ( GrpRes);
	QRadioButton *_1600;
  _1600 = new QRadioButton ( GrpRes);
	_640->setGeometry( 4, 15, 77, 21 );
	_640->setText( "&640x480" );
  _640->setChecked(TRUE);
	_800->setGeometry( 4, 35, 77, 21 );
	_800->setText( "&800x600" );
	_1024->setGeometry( 4, 55, 81, 21 );
	_1024->setText( "1&024x768" );
	_1152->setGeometry( 108, 15, 85, 21 );
	_1152->setText( "11&52x864" );
	_1280->setGeometry( 108, 35, 85, 21 );
	_1280->setText( "1&200x1024" );
	_1600->setGeometry( 108, 55, 85, 21 );
	_1600->setText( "&1600x1200" );
  if (ActiveRes == "640x480") { _640->setChecked ( TRUE ); value =0;}
  if( ActiveRes == "800x600") { _800->setChecked(TRUE); value=1;}
  if( ActiveRes == "1024x768") {_1024->setChecked(TRUE);value=2;}
  if( ActiveRes == "1152x864")  {_1152->setChecked(TRUE); value= 3;}
  if( ActiveRes == "1280x1024")  {_1280->setChecked(TRUE);value=4;}
  if( ActiveRes == "1600x1200")  {_1600->setChecked(TRUE);value=5;}
  connect (GrpRes, SIGNAL(clicked(int )), SLOT (slotResClicked( int )));
/*fin*/

/*les butons en bas (original  non !! */
	QPushButton *help;
	help = new QPushButton ( this , "");
	COkButton = new QPushButton ( this , "");
	CCancelButton = new QPushButton ( this , "");
  connect( CCancelButton , SIGNAL(clicked()) , SLOT (reject()) );
  connect(COkButton , SIGNAL (clicked()), SLOT ( slotquit() ) );
	CCancelButton->setGeometry( 352, 220, 81, 25 );
	CCancelButton->setText(klocale->translate( "&Cancel" ));
	COkButton->setGeometry( 244, 220, 81, 25 );
	COkButton->setText(klocale->translate( "&Ok") );
  COkButton->setDefault ( TRUE );
	help->setGeometry( 16, 220, 81, 25 );
	help->setText( klocale->translate("&Help") );

/*parametre de la fenetre de dialogue */
	this->setCaption(klocale->translate("Custom ..." ));
	this->setGeometry( 210, 166, 440, 250 );
	this->setMinimumSize( 440, 250 );
	this->setMaximumSize( 440, 250 );



};

custom::~custom()
{
}



QString custom::ValueHSync()
{
  return LHSync->text();
}

QString custom::ValueVSync()
{
   return LVSync->text();
}

QString custom::ResMax()
{
   QString s;
   switch (value)
   {
     case 0 : s="640x480" ; break;
     case 1 : s="800x600"; break;
     case 2 : s="1024x768";break;
     case 3 : s="1152x864";break;
     case 4 : s="1280x1024";break;
     case 5 : s="1600x1200";break;
   }
   return s;
}

QString custom::MType()
{
   return LType->text();
}

QString custom::MMarque()
{
   return LMarque->text();
}


void custom::slotquit()
{

 if( (strlen(LHSync->text() ) !=0) && (strlen(LVSync->text()))!=0)
 {
   accept();
 }
 else
    QMessageBox::warning(this,"Erreur .... ",
    "    Il faut au moins entrer les valeurs de frquences    \n       Horizontales (HSync\n       tvertivales(VSync).\n" ,"&Ok");


}


void custom::slotResClicked(int i)
{
 value =i;
}











