/***************************************************************************
                          listefolder.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Thu Feb 4 1999                                           
    copyright            : (C) 1999 by Didier Gaudin                         
    email                : gaudin@club-internet?fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "listefolder.h"

void ListeFolder::paint( QPainter *p )
{
  p->drawPixmap( 3, 0, pm );
  QFontMetrics fm = p->fontMetrics();
  int yPos;                       // vertical text position
  if ( pm.height() < fm.height() )
    yPos = fm.ascent() + fm.leading()/2;
  else
    yPos = pm.height()/2 - fm.height()/2 + fm.ascent();
  p->drawText( pm.width() + 5, yPos, text() );
}

int ListeFolder::height(const QListBox *lb ) const
{
  return QMAX( pm.height(), lb->fontMetrics().lineSpacing() + 1 );
}

int ListeFolder::width(const QListBox *lb ) const
{
  return pm.width() + lb->fontMetrics().width( text() ) + 6;
}

