/***************************************************************************
                          logbook.cpp  -  description                              
                             -------------------                                         
    begin                : Tue May 18 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "dhlog.h"

LogBook::LogBook()
{

 	
}

void LogBook::LogInit(void)
{
 	strcpy(dinfo.testname,"DH-Log");
 	dinfo.dateiversion = VERSION_V201;
 	dinfo.anz_qso = 0;
 	dinfo.anz_call  = 0;
 	dinfo.anz_bemerkung = 0;
 	dinfo.max_call = 0; 			// reiner Dummywert
 	dinfo.bemnr = 1;
 	dinfo.checksumme = 0;		// im Moment nicht genutzt...
 	changed = false;
 	loggeladen = false;
 	qsoliste.setAutoDelete(true);
 	qsoliste.clear();
}
	
bool LogBook::LogLaden(const char *name)
{
	FILE *fh;
	int test;
			
	fh = fopen(name,"rb");
	if(fh == NULL) return false;
	strcpy(logname,name);
	LogInit();	
	// Infoblock laden
	test = fread(&dinfo,sizeof(TDInfoBlock),1,fh);
	if(test != 1)
	{
		fclose(fh);
		KMsgBox::message(NULL,"Fehler","Infoblock lesen....");
		return false;
	}
	// QsoDaten laden
	if(! LoadQsoData(fh))
	{
		fclose(fh);
		KMsgBox::message(NULL,"Fehler","LoadQsoData(fh)");
		return false;
	}
	// CallDaten laden
	if(! LoadCallData(fh))
	{
		fclose(fh);
		KMsgBox::message(NULL,"Fehler","LoadCallData(fh)");
		return false;
	}
	
	if(! setAktQso(1))
	{
		fclose(fh);
		KMsgBox::message(NULL,"Fehler","setAktQso()");
		return false;
	}
	fclose(fh);
 	return true;
}

bool LogBook::LoadQsoData(FILE *fh)
{
	long i;
	
	i = anzQso();
	while (i > 0)
	{ 	
		qsoliste.append( new CQso(fh) );
		i--;
	}
	return true;
}

bool LogBook::SaveQsoData(FILE *fh)
{
	long i;
	
	i = anzQso();
	qsoliste.first();	
	while (i > 0)
	{
		qsoliste.current()->SaveQso(fh);
		qsoliste.next();
		i--;
	}
	return true;
}		

bool LogBook::LoadCallData(FILE *fh)
{
	long i;
	i = anzCall();
	while (i > 0)
	{
		callliste.append( new CCall(fh) );
		i--;
	}
	return true;
}

bool LogBook::SaveCallData(FILE *fh)
{
	long i;
	
	i = anzCall();
	callliste.first();
	while (i > 0)
	{
		callliste.current()->SaveCall(fh);
		callliste.next();
		i--;
	}
	return true;
}	
			
bool LogBook::LogSpeichern(const char *name)
{
 	FILE *fh;
 	
 	fh = fopen(name,"wb");
 	if(fh == NULL) return false;
 	
 	fwrite(&dinfo,sizeof(TDInfoBlock),1,fh);
 	SaveQsoData(fh);
 	SaveCallData(fh);
 	fclose(fh);
 	changed = false;
 	return true;
}

bool LogBook::LogSchliessen(void)
{
	loggeladen = false;
	changed = false;
	return false;
}

void LogBook::LogSort(long li_grenze,long re_grenze,CQso* tausch)
{
	long li,re;
	CQso *l1,*l2,*test;
	
	li = li_grenze;
	re = re_grenze;
	test = qsoliste.at( ((li + re) / 2) - 1);
	do
	{
		l1 = qsoliste.at(li - 1);
		while(CompareDatum(l1,test) < 0)
		{
			li++;
			l1 = qsoliste.at(li - 1);
		}
		
		l2 = qsoliste.at(re - 1);
		while(CompareDatum(test,l2) < 0)
		{
			re--;
			l2 = qsoliste.at(re - 1);
		}
		
		if(li <= re)
		{
			*tausch = *l1;
			*l1 = *l2;
			*l2 = *tausch;
			li++;
			re--;
			changed = true;
		}
	} while(li <= re);
	if(li_grenze < re) LogSort(li_grenze,re,tausch);
	if(li < re_grenze) LogSort(li,re_grenze,tausch);
}

int LogBook::CompareDatum(CQso *qso1,CQso *qso2)
{
	long datum1,datum2;
	
	datum1 = qso1->datum.getRaw();
	datum2 = qso2->datum.getRaw();
	if(datum1 < datum2) return -1;
	if(datum1 > datum2) return 1;
	if(datum1 == datum2)
	{
		long utc1,utc2;
		
		utc1 = qso1->utc.getRaw();
		utc2 = qso2->utc.getRaw();			
		if(utc1 < utc2) return -1;
		if(utc1 > utc2) return 1;
		if(utc1 == utc2) return 0;
	}
	return -2;	// Fehler aufgetreten ?!?
}
	
	



bool LogBook::logChanged(void)
{
	return changed;
}


long LogBook::anzQso(void)
{
	return dinfo.anz_qso;
}

long LogBook::anzCall(void)
{
	return dinfo.anz_call;
}

long LogBook::aktQso(void)
{
	if(aktqso > dinfo.anz_qso)
		aktqso = dinfo.anz_qso;
	return aktqso;
}

bool LogBook::setAktQso(long nr)
{
	if((nr >= 1) && (nr <= anzQso()))
	{
		aktqso = nr;
		return true;
	}
	else
	return false;
}

bool LogBook::setAktQso(CQso *qso)
{
	return setAktQso((int) qsoliste.findRef(qso) + 1);
}

CQso* LogBook::GetQso(long nr)
{
	if( qsoliste.isEmpty() ) return NULL;
	return qsoliste.at(nr - 1);
}

bool LogBook::DeleteQso(long nr)
{
	CQso *qso;
	
	qso = GetQso(nr);
	if(qso == NULL) return false;
	if(qsoliste.removeRef(qso))
	{
		dinfo.anz_qso--;
		changed = true;
		return true;
	}
	else
		return false;
}
	

CCall* LogBook::SearchCall(CQso *qso)
{
	char *help,help1[15],dummy[20];
	long i;
	
	if(qso == NULL) return NULL;
	if(callliste.isEmpty() ) return NULL;
	callliste.first();
	help = qso->GetCall(false,dummy);					// Call gekuerzt holen...
	i = anzCall();
	
	while(i > 0)
	{
		callliste.current()->GetCall(help1);
		if(strcmp(help,help1) == 0)
		{
			return callliste.current();
		}	
		if((callliste.next()) == NULL)
			return NULL;
		i--;
	}
	return NULL;
}

bool LogBook::AddCall(CCall *call)
{
	if(call ==NULL) return false;
	dinfo.anz_call++;
	callliste.append(call);
	changed = true;
	return true;
}

bool LogBook::AddQso(CQso *qso)
{
	if(qso == NULL) return false;
	dinfo.anz_qso++;
	qsoliste.append(qso);
	changed = true;
	return true;
}

	
void LogBook::GetQsoListe(const char *searchcall,QList<CQso> *liste)
{
	long x;
	CQso *qso;
	
	if(liste == NULL)	return;
	if(qsoliste.isEmpty()) return ;
	qsoliste.first();
	x = anzQso();
	while(x > 0)
	{
		char dummy[20];
		qso = qsoliste.current();
		if( strcmp(searchcall,qso->GetCall(false,dummy)) == 0)
			liste->append(qso);				
		x--;
		qsoliste.next();
	}
}

void LogBook::GetQslOut(QList<CQso> *qso,int id)
{
	long x;
	CQso *helpqso;
	x = anzQso();
	qsoliste.first();
	while (x > 0)
	{
		helpqso = qsoliste.current();
		if(helpqso != NULL)
		{
			if((!helpqso->GetQslAus()) && (id == QSLOUT_ALL))
				qso->append(helpqso);
			if((!helpqso->GetQslAus()) && helpqso->GetQslDirekt() && (id == QSLOUT_DIREKT))
				qso->append(helpqso);
			if((!helpqso->GetQslAus()) && (! helpqso->GetQslDirekt()) && (id == QSLOUT_BURO))
				qso->append(helpqso);
		}
		x--;
		qsoliste.next();
	}
}

void LogBook::MarkQslOut(int nr)
{
	long x;
	CQso *qso;
	
	x = anzQso();
	qsoliste.first();
	while(x > 0)
	{
		qso = qsoliste.current();
		if(! qso->GetQslAus())
		{
			if(nr == QSLOUT_ALL)
				qso->SetQslAus(true);
			else
			{
				if((nr == QSLOUT_BURO) && (! qso->GetQslDirekt()))
					qso->SetQslAus(true);
				if((nr == QSLOUT_DIREKT) && qso->GetQslDirekt())
					qso->SetQslAus(true);
			}
		}
		x--;
		qsoliste.next();
	}
}
		
CQso *LogBook::GetQslInList(QList<CQso> *trefferListe,const char *call,long datum)
{
	char hCall[20],dummy[20];
	CQso *hQso,*trefferQso;
	CQso aQso;
	long anzTreffer;
	long x;
	
	anzTreffer = 0;
	trefferQso = NULL;
	aQso.CallKuerzen(hCall,call);
	x = anzQso();
	qsoliste.first();
	while( x > 0)
	{
		hQso = qsoliste.current();
		if( (strcmp(hCall,hQso->GetCall(false,dummy)) == 0) && (datum == hQso->datum.getRaw()) )
		{
			anzTreffer++;
			trefferQso = hQso;
		}
		if( strcmp(hCall,hQso->GetCall(false,dummy)) == 0)
			trefferListe->append(hQso);
		x--;
		qsoliste.next();
	}
	
	if(anzTreffer == 1)	//genau ein Qso gefunden
		return trefferQso;
	
	return NULL;		// keins oder mehrere Qsos gefunden...
}






