/***************************************************************************
                          ontimelog.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Oct 18 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "ontimelog.h"

OnTimeLog::OnTimeLog(QWidget *parent, const char *name) : QDialog(parent,name,true){
	
	int x;
		
	initDialog();
	setIcon(Icon("ontimelog.xpm"));
	checkedCall = "";
	qsoListe = new LogListView(this);
	qsoListe->setGeometry(300,180,310,180);
	qsoListe->createQsoEditView();
	
	for(x = 0;x < banddata.anzBand();x++)
		band->insertItem(banddata.band(x));
	for(x = 0;x <= modedata.anzMode();x++)
		mode->insertItem(modedata.mode(x));
	band->setAutoCompletion(true);
	mode->setAutoCompletion(true);
	logButton->setEnabled(false);
		
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	connect(logButton,SIGNAL(clicked()),this,SLOT(slotLogQso()));
}

OnTimeLog::~OnTimeLog(){
}

void OnTimeLog::newQso(KConfig *aconfig,LogBook *alog,CQso *aqso,CCall *acalldata)
{
	time_t *ptime;
	tm *gmt;	
	CDatum _datum;
	CUtc _utc;
	config = aconfig;
	log = alog;
	qso = aqso;
	calldata = acalldata;
	newCall = false;
	
	setCaption(i18n("OnTime Log"));
	
	ptime = new time_t;
	time(ptime);
	gmt = gmtime(ptime);
	_datum.create(gmt->tm_mday,gmt->tm_mon,gmt->tm_year);
	_utc.create(gmt->tm_hour,gmt->tm_min);
	delete ptime;
	datum->setText(_datum.get(DTAUS_LONG));
	utc->setText(_utc.get(DTAUS_LONG));
	
	config->setGroup("Logging");
	band->setCurrentItem(config->readLongNumEntry("Band",0));
	mode->setCurrentItem(config->readLongNumEntry("Mode",0));
	emit slotModeSelect(config->readLongNumEntry("Mode",0));
	callCheckButton->setDefault(true);
	logButton->setDefault(false);
	qslActivity->setChecked(true);
	call->setFocus();
	connect(mode,SIGNAL(activated(int)),this,SLOT(slotModeSelect(int)));
	connect(callCheckButton,SIGNAL(clicked()),this,SLOT(slotCheckCall()));
}

void OnTimeLog::createQsoListe(const char *searchcall)
{
	CQso	*hQso;
	char qslInfo[8];
	QList<CQso> liste;
		
	qsoListe->clear();
	log->GetQsoListe(searchcall,&liste);
	if(liste.isEmpty())
	{
		(void) new QListViewItem(qsoListe,i18n("No contact yet."));
		return;
	}
	
	liste.first();
	while((hQso = liste.current()) != NULL)
	{
		if(hQso->GetQslEin())
			strcpy(qslInfo,"Tnx Qsl");
		else
			strcpy(qslInfo,"Pse Qsl");
		(void) new QListViewItem(qsoListe,hQso->GetCall(),hQso->datum.get(DTAUS_SHORT),hQso->utc.get(true),
			banddata.band(hQso->GetBand()),modedata.mode(hQso->GetMode()),qslInfo);
		via->setText(hQso->GetViaCall());
		liste.next();
	}
}

bool OnTimeLog::checkEntries(void)
{
	CQso *qso;
	QString help;
	char ic,test[7];
	
	ic = 0;
	qso = new CQso();
	
	if(! qso->datum.insert(datum->text()))
	{
		datum->setFocus();
		KMsgBox::message(this,i18n("OnTime Log"),i18n("Unknown date.\nEnter date like ddmmyy or dd.mm.yyyy"));
		delete qso;
		return false;
	}
	if(! qso->utc.insert(utc->text()))
	{
		utc->setFocus();
		KMsgBox::message(this,i18n("OnTime Log"),i18n("Unknown UTC time.\nEnter time like hhmm or hh:mm"));
		delete qso;
		return false;
	}
	
	if(! qso->SetCall(call->text()))
	{
		call->setFocus();
		KMsgBox::message(this,i18n("OnTime Log"),
			i18n("Unknown Call.\nOnly calls with three or more characters are acceptable."));
		delete qso;
		return false;
	}
	if(! qso->SetRstAus(rstAus->text()))
	{
		rstAus->setFocus();
		KMsgBox::message(this,i18n("OnTime Log"),
			i18n("Unknown rst.\nOnly rst with two or more characters are acceptable."));
		delete qso;
		return false;
	}
	if(! qso->SetRstEin(rstEin->text()))
	{
		rstEin->setFocus();
		KMsgBox::message(this,i18n("OnTime Log"),
			i18n("Unknown rst.\nOnly rst with two or more characters are acceptable."));
		delete qso;
		return false;
	}
	if(! qso->SetViaCall(via->text()))
	{
		via->setFocus();
		KMsgBox::message(this,i18n("OnTime Log"),
			i18n("Unknown Via Call.\nOnly calls with three or more characters are acceptable."));
		delete qso;
		return false;
	}
	
	help = locator->text();		// Locator auf korrektes Format prfen
	strcpy(test,help);
	if(isalpha(test[0])) ic++;
	if(isalpha(test[1])) ic++;
	if(isdigit(test[2])) ic++;
	if(isdigit(test[3])) ic++;
	if(isalpha(test[4])) ic++;
	if(isalpha(test[5])) ic++;
	if(strlen(test) == 0)
	{
		ic = 6;
		help = "------";
	}
	if(strcmp(test,"------") == 0) ic = 6;
	
	if(ic != 6)
	{
		KMsgBox::message(this,i18n("OnTime Log"),i18n("Unknown Locator.\nUse 6 digits like JO41EB or none.\n"));
		locator->setFocus();
		return false;
	}
	return true;	// scheint ja alles ok zu sein...
}

CCall* OnTimeLog::getNewCall()
{
	if(newCall)
		return calldata;
	else
		return NULL;
}

// Signale abarbeiten
//####################
void OnTimeLog::slotModeSelect(int index)
{
	rstEin->setText(modedata.rst(index));
	rstAus->setText(modedata.rst(index));
}
void OnTimeLog::slotCheckCall()
{
	CQso *hQso;
	
	hQso = new CQso();
  	if(! hQso->SetCall(call->text()))
	{
		call->setFocus();
		KMsgBox::message(NULL,i18n("On-Time Log"),
			i18n("Unknown Call.\nOnly calls with three or more characters are acceptable."));
		delete qso;
	}
   else
   {
   	QString help;
   	char dummy[20];
      	
   	help = call->text();
   	if(help.upper() == checkedCall ) return;
   	checkedCall = help.upper();
   	call->setText(checkedCall);
   	createQsoListe(hQso->GetCall(false,dummy));
   	call->selectAll();
   	call->setFocus();
   	calldata = log->SearchCall(hQso);
   	if(calldata)
   	{
   		name->setText(calldata->GetName());
   		qth->setText(calldata->GetQth());
   		dok->setText(calldata->GetDok());
   		locator->setText(calldata->GetLocator());
   	}
   	else
   	{
   		name->setText("");
   		qth->setText("");
   		dok->setText("");
   		locator->setText("");
   	}
   		
   	delete hQso;
   	logButton->setEnabled(true);
   }
}

void OnTimeLog::slotLogQso()
{
	int return_code = ONTIMELOG_CALLOLD;
	int ic;
	QString help;
	
  	if( !checkEntries())
		return;
	config->setGroup("Logging");
	config->writeEntry("Band",band->currentItem());
	config->writeEntry("Mode",mode->currentItem());
	qso->SetCall(call->text());
	qso->SetViaCall(via->text());
	qso->datum.insert(datum->text());
	qso->utc.insert(utc->text());
	qso->SetBand(band->currentItem());
	qso->SetMode(mode->currentItem());
	qso->SetRstEin(rstEin->text());
	qso->SetRstAus(rstAus->text());
	qso->SetQslEin(false);
	qso->SetQslAus(false);
	qso->SetQslDirekt(direktQsl->isChecked());
	qso->SetQslActivity(qslActivity->isChecked());
	
	ic = 0;
	if(strlen(name->text()) == 0) ic++;
	if(strlen(qth->text()) == 0) ic++;
	if(strlen(dok->text()) == 0) ic++;
	if(strlen(locator->text()) == 0) ic++;
	if(ic >= 4)
	{
		done(return_code);
		return;
	}
	
	if(calldata == NULL)
	{
		calldata = new CCall();
		newCall = true;
		return_code = ONTIMELOG_CALLNEW;
	}
	calldata->SetName(name->text());
	calldata->SetQth(qth->text());
	calldata->SetDok(dok->text());
	help = locator->text();
	calldata->SetLocator(help.upper());
	
	done(return_code);
}
			






