/***************************************************************************
                          qslindlg.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 23 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qslindlg.h"
#include "qslinwahldlg.h"
#include "qsoeditdlg.h"
#include "calleditdlg.h"

QslInDlg::QslInDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	setCaption(i18n("QSL incomming"));
	call->setFocus();
	
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotOk()));
}

QslInDlg::~QslInDlg(){
}

void QslInDlg::init(KConfig *aconfig, LogBook *alog)
{
	log = alog;
	config = aconfig;
}

void QslInDlg::clearAll()
{
	call->clear();
	call->setFocus();
	date->clear();   	
}

void QslInDlg::newQso(bool query)
{
	int ic;
	if(query)
	{
		ic = KMsgBox::yesNo(this,i18n("QSL incomming"),i18n("This QSO is no existing.\nDo you want to enter it ?"),
			KMsgBox::QUESTION);
	}
	else
		ic = 1;
	if(ic == 1)
	{
		CQso* qso;
		QsoEditDlg* dlg;
	
		qso = new CQso();
		dlg = new QsoEditDlg();
		dlg->newQslQso(config,log,qso,call->text(),date->text());
		if(dlg->exec())
		{
			log->AddQso(qso);
			log->setAktQso(log->anzQso());
		}
		else
			if(qso) delete qso;
		if(dlg) delete dlg;
	}	
}

void QslInDlg::qsoAuswahl(QList<CQso> *treffer)
{
	QslInWahlDlg *wahl;
	int result;
	
	wahl = new QslInWahlDlg();
	wahl->init(log,treffer);
	result = wahl->exec();
	if(result == QSLIN_NEW) newQso(false);
	if(result == QSLIN_OK) checkCallData(log->GetQso(log->aktQso()));
	delete wahl;
}

void QslInDlg::checkCallData(CQso *qso)
{
	if(qso == NULL ) return;
	
	config->setGroup("QSL");
	if(config->readBoolEntry("CHECK_CALL",true))
	{
		CCall *newcall;
	 	CallEditDlg* cdlg;
		char dummy[20];
		int ic;
		
		if( (newcall = log->SearchCall(qso)) == NULL)
		{	
			cdlg = new CallEditDlg();
			newcall = new CCall();
			newcall->SetCall(qso->GetCall(false,dummy));
			cdlg->SetCallRef(newcall);
			cdlg->setCaption(i18n("Create New Call"));
			if(cdlg->exec() == true)
				log->AddCall(newcall);
			else
				delete newcall;
			delete cdlg;
		}
		else
			if( (ic = newcall->dataComplete(config)) != CALLCHECK_OK)
			{
				CallEditDlg* dlg;
	
				dlg = new CallEditDlg();
				dlg->setCaption(i18n("Edit Call"));
				dlg->SetCallRef(newcall);
				dlg->callChecked(ic);
				dlg->exec();
				delete dlg;
			}	
   }
}

//
// Slots
//-------

void QslInDlg::slotOk()
{
	QString theCall;
	QString theDate;
	CDatum qsoDatum;
	QList<CQso> treffer;
	CQso *hQso;
	
	hQso = NULL;
	theCall = call->text();
	call->setText(theCall.upper());
	if(theCall.length() <= 2)
	{
		call->setFocus();
		KMsgBox::message(this,i18n("QSL incomming"),
			i18n("Unknown Call.\nOnly calls with three or more characters are acceptable."));
		return;
	}
	theDate = date->text();
	if(theDate.length() == 0)
		qsoDatum.create(31,02,1999);
	else
		if(qsoDatum.insert(theDate) == false)
		{
			date->setFocus();
			KMsgBox::message(this,theDate,//i18n("QSL incomming"),
				i18n("Unknown date.\nEnter date like ddmmyy or dd.mm.yyyy"));
			return;
		}
		
	hQso = log->GetQslInList(&treffer,theCall.upper(),qsoDatum.getRaw());	
	if(hQso)               			// ein passendes Qso gefunden
	{
		log->setAktQso(hQso);
		hQso = log->GetQso(log->aktQso());
		hQso->SetQslEin();
		checkCallData(hQso);
		done(1);
	}
	else
	{
		if(treffer.isEmpty())		// nichts gefunden
			newQso(true);            	
		else
			qsoAuswahl(&treffer);	// jede Menge gefunden
	}
	done(1);
}




































