/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/khylafax.cpp,v 1.2 1999/02/26 15:45:00 jonny Exp $

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpopmenu.h>
#include <qkeycode.h>
#include <kmsgbox.h>
#include <ktopwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlistbox.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kconfig.h>
#include <kwm.h>
#include "status.h"
#include "prefs.h"
#include "khylafax.h"

QList<KHylaFax> KHylaFax::windowList;

int KHylaFax::init() {

  cover = new coverPage; //Stores all coverpage variables

  windowList.append(this);
  //KWM::setIcon(winId(), kapp->getIcon());
  //KWM::setMiniIcon(winId(), kapp->getMiniIcon());

  topLayout = new QFrame(this);
  setView(topLayout);

  QBoxLayout *vBox = new QVBoxLayout(topLayout,5);

  QLabel *coverLab = new QLabel(topLayout);
  coverLab->setText(klocale->translate("Cover Page Information"));
  coverLab->setAlignment(AlignCenter);
  coverLab->setFixedHeight(15);
  vBox->addWidget(coverLab);
  
  int gridrowmax = 8;
  int gridcolmax = 2;
  int gridrow = 0;
  int gridcol = 0;

  QGridLayout *gridBox = new QGridLayout(gridrowmax, gridcolmax);
  vBox->addLayout(gridBox, 10);

  gridBox->addColSpacing(0,100);
  gridBox->setColStretch(0,0);
  gridBox->setColStretch(1,20);

  cover->faxNumLab = new QLabel(topLayout);
  cover->faxNumLab->setText(klocale->translate("Fax Number"));
  gridBox->addWidget(cover->faxNumLab,gridrow,gridcol++);
  
  cover->faxNum = new QLineEdit(topLayout);
  gridBox->addWidget(cover->faxNum,gridrow, gridcol++);
  
  gridrow++;
  gridcol = 0;

  cover->phoneNumLab = new QLabel(topLayout);
  cover->phoneNumLab->setAutoResize(TRUE);
  cover->phoneNumLab->setText(klocale->translate("Phone Number"));
  gridBox->addWidget(cover->phoneNumLab,gridrow, gridcol++);

  cover->rcpt = new QLineEdit(topLayout);
  gridBox->addWidget(cover->rcpt,gridrow, gridcol++);

  gridrow++;
  gridcol = 0;

  cover->rcptLab = new QLabel(topLayout);
  cover->rcptLab->setText(klocale->translate("Recipient"));
  gridBox->addWidget(cover->rcptLab,gridrow, gridcol++);

  cover->rcpt = new QLineEdit(topLayout);
  gridBox->addWidget(cover->rcpt,gridrow, gridcol++);

  gridrow++;
  gridcol = 0;

  cover->companyLab = new QLabel(topLayout);
  cover->companyLab->setText(klocale->translate("Company"));
  gridBox->addWidget(cover->companyLab,gridrow, gridcol++);

  cover->company = new QLineEdit(topLayout);
  gridBox->addWidget(cover->company,gridrow, gridcol++);

  gridrow++;
  gridcol = 0;

  cover->locationLab = new QLabel(topLayout);
  cover->locationLab->setText(klocale->translate("Location"));
  gridBox->addWidget(cover->locationLab,gridrow, gridcol++);

  cover->location = new QLineEdit(topLayout);
  gridBox->addWidget(cover->location,gridrow, gridcol++);

  gridrow++;
  gridcol = 0;

  cover->subjectLab = new QLabel(topLayout);
  cover->subjectLab->setText(klocale->translate("Subject"));
  gridBox->addWidget(cover->subjectLab,gridrow, gridcol++);

  cover->subject = new QLineEdit(topLayout);
  gridBox->addWidget(cover->subject,gridrow, gridcol++);

  gridrow++;
  gridcol = 0;

  cover->transmitLab = new QLabel(topLayout);
  cover->transmitLab->setText(klocale->translate("Transmit Time"));
  gridBox->addWidget(cover->transmitLab, gridrow, gridcol++);

  cover->transmitBut = new QPushButton(topLayout);
  cover->transmitBut->setText(klocale->translate("Now"));
  gridBox->addWidget(cover->transmitBut, gridrow, gridcol++);
  connect(cover->transmitBut, SIGNAL(clicked()),SLOT(setTransmitTime()));

  int tmpgridrow;
  for(tmpgridrow = 0; tmpgridrow <= gridrow; tmpgridrow++) {
    gridBox->addRowSpacing(tmpgridrow,cover->phoneNumLab->sizeHint().height()+7);
    gridBox->setRowStretch(tmpgridrow,0);
  }

  gridrow++;
  gridcol = 0;

  cover->memoLab = new QLabel(topLayout);
  cover->memoLab->setText(klocale->translate("Memo"));
  cover->memoLab->setAlignment(AlignTop);
  gridBox->addWidget(cover->memoLab,gridrow, gridcol++);
  
  cover->memo = new QMultiLineEdit(topLayout);
  gridBox->addWidget(cover->memo,gridrow, gridcol++);
  gridBox->setRowStretch(gridrow,5);

  fileListLab = new QLabel(topLayout);
  fileListLab->setText(klocale->translate("Documents to fax"));
  fileListLab->setAlignment(AlignCenter);
  fileListLab->setFixedHeight(15);
  vBox->addWidget(fileListLab);

  fileList = new QListBox(topLayout);
  vBox->addWidget(fileList,15);

  QBoxLayout *fileButLayout = new QHBoxLayout(4);
  vBox->addLayout(fileButLayout,0);

  QPushButton *fileAdd = new QPushButton(topLayout);
  fileAdd->setText(klocale->translate("Add"));
  fileAdd->setFixedHeight(25);
  fileButLayout->addWidget(fileAdd,0,0);

  QPushButton *fileRemove = new QPushButton(topLayout);
  fileRemove->setText("Remove");
  fileButLayout->addWidget(fileRemove,0,1);

  QPushButton *fileScan = new QPushButton(topLayout);
  fileScan->setText("Scan Page");
  fileButLayout->addWidget(fileScan,0,1);

  QPushButton *fileClear = new QPushButton(topLayout);
  fileClear->setText("Clear");
  fileButLayout->addWidget(fileClear,0,1);

  connect(fileAdd,SIGNAL(clicked()),SLOT(addFaxFile()));
  connect(fileRemove,SIGNAL(clicked()), SLOT(removeFaxFile()));
  connect(fileClear, SIGNAL(clicked()), SLOT(clearFaxFile()));

  QPopupMenu *file = new QPopupMenu;
  file->insertItem( klocale->translate("&New Fax"), ID_FILE_NEWFAX);
  file->setAccel(CTRL+Key_N,ID_FILE_NEWFAX);
  file->insertItem( klocale->translate("&Send Fax"), ID_FILE_SENDFAX);
  file->insertSeparator();
  file->insertItem( klocale->translate("Raise File"), ID_FILE_FILEUP);
  file->insertItem( klocale->translate("Lower File"), ID_FILE_FILEDOWN);
  file->insertSeparator();
  file->insertItem(  klocale->translate("Close"), ID_FILE_CLOSE);
  file->setAccel(CTRL+Key_W,ID_FILE_CLOSE);
  file->insertSeparator();
  file->insertItem(  klocale->translate("Quit"), ID_FILE_QUIT);
  file->setAccel(CTRL+Key_Q,ID_FILE_QUIT);

  QPopupMenu *edit = new QPopupMenu;
  edit->insertItem(klocale->translate("&Copy"), ID_EDIT_COPY);
  edit->setAccel(CTRL+Key_C,ID_EDIT_COPY);
  edit->insertItem(klocale->translate("&Paste"), ID_EDIT_PASTE);
  edit->setAccel(CTRL+Key_V,ID_EDIT_PASTE);
  edit->insertItem(klocale->translate("Cut"), ID_EDIT_CUT);
  edit->setAccel(CTRL+Key_X,ID_EDIT_CUT);

  QPopupMenu *view = new QPopupMenu;
  view->insertItem( klocale->translate("Fax Status"), ID_VIEW_FAXSTATUS);
  view->insertItem( klocale->translate("Preferences"), ID_VIEW_PREFERENCES);

  QPopupMenu *help = new QPopupMenu;
  help->insertItem( klocale->translate("Contents"), ID_HELP_HELP);
  help->setAccel(Key_F1,ID_HELP_HELP);
  help->insertItem( klocale->translate("About"), ID_HELP_ABOUT);

  connect (file, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (edit, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (view, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (help, SIGNAL (activated (int)), SLOT (menuCallback (int)));

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem( klocale->translate("&File"), file );
  menu->insertItem( klocale->translate("&Edit"), edit );
  menu->insertItem( klocale->translate("&View"), view );
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), help );
  setMenu(menu);
  menu->show();

  KIconLoader *loader = kapp->getIconLoader();
  toolbar = new KToolBar(this);
  toolbar->insertButton(loader->loadIcon("send.xpm"),
			ID_FILE_SENDFAX, TRUE, klocale->translate("Send Fax"));
  toolbar->insertButton(loader->loadIcon("filenew.xpm"),
                        ID_FILE_NEWFAX, TRUE, klocale->translate("New Fax"));
  toolbar->insertButton(loader->loadIcon("contents.xpm"),
			ID_VIEW_FAXSTATUS, TRUE, klocale->translate("Fax Status"));
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("editcut.xpm"),ID_EDIT_CUT, FALSE,
                        klocale->translate("Not implemented"));
  toolbar->insertButton(loader->loadIcon("editcopy.xpm"),ID_EDIT_COPY, FALSE,
                        klocale->translate("Not implemented"));
  toolbar->insertButton(loader->loadIcon("editpaste.xpm"),ID_EDIT_PASTE, FALSE,
                        klocale->translate("Not implemented"));
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("up.xpm"), ID_FILE_FILEUP, FALSE,
			klocale->translate("Raise File Position"));
  toolbar->insertButton(loader->loadIcon("down.xpm"), ID_FILE_FILEDOWN, FALSE,
			klocale->translate("Lower File Posistion"));
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("help.xpm"),ID_HELP_ABOUT, TRUE,
                        klocale->translate("About KHylaFax"));
  addToolBar(toolbar);
  toolbar->setBarPos(KToolBar::Top);
  toolbar->show();
  connect(toolbar, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));

  topLayout->show();
  vBox->activate();

  setMinimumSize(400,450);
  resize(400,450);
  //show(); /* is done now by khylainfo */

  return 0;
}

void KHylaFax::addFaxFile() {
  QString fileAdd = KFileDialog::getOpenFileName();
  if(! fileAdd.isEmpty())
    fileList->insertItem(fileAdd);
}

void KHylaFax::removeFaxFile() {
  if(fileList->currentItem() >= 0)
    fileList->removeItem(fileList->currentItem());
}

void KHylaFax::clearFaxFile() {
  fileList->clear();
}

void KHylaFax::setTransmitTime() {
  KMsgBox::message(topLayout,"Transmission Time" , "Transmission Time is not implemented yet.");
}

void KHylaFax::menuCallback(int item) {
  switch (item) {
  case ID_FILE_NEWFAX:
    new KHylaFax(netcom);
    break;

  case ID_FILE_SENDFAX:
    sendFax(config);
    break;

  case ID_FILE_FILEUP:
    break;

  case ID_FILE_FILEDOWN:
    break;

  case ID_FILE_CLOSE: {
    //windowList.remove(this);
    //if (windowList.isEmpty())
    //  kapp->quit();
    //else
    //  delete this;
    hide();
    break;
  }
  case ID_FILE_QUIT: {
    kapp->quit();
    break;
  }

  case ID_EDIT_COPY: {
    break;
  }
  
  case ID_EDIT_PASTE: {
    break;
  }
  
  case ID_EDIT_CUT: {
    break;
  }
  
  case ID_VIEW_TOOLBAR:
    break;

  case ID_VIEW_PREFERENCES: {
    KHylaFaxPrefs *prefs = new KHylaFaxPrefs(config);
    prefs->show();
    break;
  }
  
  case ID_VIEW_FAXSTATUS: {
    KHylaFaxStatus *status = new KHylaFaxStatus(config, netcom);
    status->show();
    break;
  }

  case ID_HELP_HELP: {
    kapp->invokeHTMLHelp( "khylafax/index.html", "" );
    break;
  } 

  case ID_HELP_ABOUT: {
     QString str;
     str.append( "KHylaFax\n");
     str.append( VERSION );
     str.append( "\nby Jeremy Lublin  (jlublin@further.com)" );
     str.append( "\nnetwork extensions by Jonas Sextl (jonny@dillingen.baynet.de)");
     KMsgBox::message( 0, klocale->translate("About KHylaFax"),
                       (const char *)str,
                       KMsgBox::INFORMATION, klocale->translate("Close") );
     break;
  }
  }
}

KHylaFax::KHylaFax(NetCom *netcom) {
	config = kapp->getConfig();
	init();
	this->netcom = netcom;
}

KHylaFax::~KHylaFax() {
  delete toolbar;
  delete menu;
  delete topLayout;
}

void KHylaFax::closeEvent ( QCloseEvent *e) {
  windowList.remove(this);
  //if (windowList.isEmpty())
    //kapp->quit();

  hide();

  e->accept();
}

#include "khylafax.moc"




