/*

    File: ksermon.h
    Version: 0.3.0
    Date: 31-DEC-1998
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    ksermon is an system-utility to watch the activities on a given serial
    port. The current state of the TX,RX,CTS,RTS,DTR,DSR,DCD and RI lines are
    shown by some kind of LEDs. Furthermore, the current TX/RX transfer rates
    are visualisized using bars and within an osziloscope. Additionaly,
    the amount of received and transmitted data since programm start
    is displayed.
    
    This utility is set on top of the kernelpatch done by sermon-0.23 from
    Peter Fox (fox@roestock.demon.co.uk).

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef KSERMON_H
#define KSERMON_H



// include several header files

#include <qlabel.h> 
#include <qpopmenu.h>

#include <ktopwidget.h>

#include "smif.h"
#include "bar.h"
#include "oszi.h"
#include "pref.h"
#include "ledtoolbar.h"
#include "texttoolbar.h"


// declare qsermon class

class ksermon : public KTopLevelWidget {

  // ksermon is a qobject
  Q_OBJECT
  
public:

  // constructor
  ksermon(char* name="");
  
private:

  // serial monitor interface
  smif* smon;

  // attributes for the Led-Toolbar and Text-Toolbar
  int hide_ledbar,ledbarID,ledbmnID;
  int hide_textbar,textbarID,textbmnID;

  // "options"-menu
  QPopupMenu* options;

  // Menubar, Led-Toolbar & Text-Toolbar
  KMenuBar* menubar;
  LedToolBar *ledbar;
  TextToolBar *textbar;

  // bar to show TX-rate
  bar* txbar;

  // bar to show RX-rate
  bar* rxbar;

  // oszilograph for TX/RX
  oszi* txrxoszi;
  
  // preference widget
  pref* preferences;

private slots:

  // what to do when Menus in "option"-menu were selected
  void toggleLedBar();
  void toggleTextBar();
  void settings();

  // save and restore settings
  void writeSettings();
  void readSettings();

signals:

  // inform, when attributes have been changed
  void deviceChanged(const char*);
  void maximumChanged(float);
  void intervalChanged(int);
  void tauChanged(int);

};



#endif
