/*
    File: ledtoolbar.cpp
    Version: 0.2.4
    Date: 31-DEC-1998
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    The LedToolBar shows the line activities (RX,TX,RTS,CTS etc.)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "fixedlabel.h"
#include "ledtoolbar.h"

#include <iostream.h>

// define texts of led-labels

const char* labelText[NUM_LEDS]={"TX","RX","RTS","CTS","DTR","DSR","DCD","RI"};



LedToolBar::LedToolBar(smif* serialmon,QWidget* parent=0) :
  KToolBar(parent),serialmon(serialmon) {

  setFullWidth(false);
  
  // init leds & labels
  for(int i=0;i<NUM_LEDS;i++) {
    
    // create a frame for led & label
    QFrame* fr=new QFrame(this);
    
    // generate Label
    ledLabel[i]=new FixedLabel(labelText[i],fr);
    ledLabel[i]->setAlignment(AlignCenter);
    ledLabel[i]->QLabel::setFont(QFont("System",8));
    ledLabel[i]->show();
    ledLabel[i]->setGeometry(0,2,24,8);
    
    // generate Led
    statLed[i]=new led(fr);
    statLed[i]->show();
    statLed[i]->setGeometry(3,12,20,10);
    
    // add Frame to ledbar
    insertWidget(i,24,fr);

  };

  // interconnect smif-status-signals to leds-set-slots
  connect(serialmon,SIGNAL(TXstatusChanged(bool)),
	  statLed[LED_TX],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(RXstatusChanged(bool)),
	  statLed[LED_RX],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(RTSstatusChanged(bool)),
	  statLed[LED_RTS],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(CTSstatusChanged(bool)),
	  statLed[LED_CTS],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(DTRstatusChanged(bool)),
	  statLed[LED_DTR],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(DSRstatusChanged(bool)),
	  statLed[LED_DSR],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(DCDstatusChanged(bool)),
	  statLed[LED_DCD],SLOT(setLed(bool)));
  connect(serialmon,SIGNAL(RIstatusChanged(bool)),
	  statLed[LED_RI],SLOT(setLed(bool)));

};






