/***************************************************************************
                          klistview.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Aug 4 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

//QT includes
#include <qheader.h>

//own includes
#include "klistview.h"

KListView::KListView(QWidget *parent, const char *name ) : QListView(parent,name)
{
 	addColumn("Bookname",-1);
	header()->hide();
	setRootIsDecorated(false);
  setFrameStyle( Panel | Sunken );

  //connect the sugnals. Use single and doubleclick	
	connect(this, SIGNAL(currentChanged(QListViewItem*)), this, SLOT(slotSelected(QListViewItem*)));
	connect(this, SIGNAL(doubleClicked(QListViewItem*)),  this, SLOT(slotSelected(QListViewItem*)));
}

KListView::~KListView()
{
}

int KListView::count(QListViewItem *item)
{
	QListViewItem *myItem = item;
	int count=0;
	
	while (myItem)
	{
		if (myItem->childCount() > 0)
			myItem=myItem->firstChild();
		else
			myItem=myItem->nextSibling();
		
		if (myItem)
			count+=myItem->childCount();
		else break;
	};
	
	return count;
};

void KListView::setCurrentItem(int index)
{
	int currentPos=0;
	int currentCount=0;
	QListViewItem* item = this->firstChild();
		
	while(currentPos < index )
	{
		currentCount+=count(item);
		if (currentCount >= index)
			setOpen(item, true);
	
	  if ( item->childCount()>0 )
			item = item->firstChild();
		else if ( item->nextSibling() )
			item = item->nextSibling();
		else
			return;
		
		currentPos++;
	};
	
	this->ensureItemVisible(item);
	setSelected(item, true);
};

QListViewItem* KListView::itemAt(int index)
{
	QListViewItem *item=this->firstChild();
	int currentPos=0;
	
	while (item && currentPos < index)
	{
		if (item->childCount() > 0)
			item=item->firstChild();
		else
			item=item->nextSibling();
		
		currentPos++;
	};

	return item;
};

void KListView::addChildItem(QString text, QPixmap pix,int index)
{
	QListViewItem *item = new QListViewItem(this,text);	
	item->setPixmap(0, pix);
};

void KListView::slotSelected(QListViewItem *item)
{
	emit singleSelected( getCurrentItem(item) );
};

int KListView::getCurrentItem(QListViewItem *item)
{
	int currentPos=0;
	int fixPos=itemPos(item);
	QListViewItem *currentItem = this->firstChild();

	/** We will compare the positions of the searched item and the currentItem.
		* If they're the same we have found the current item
		*/		
	while ( currentItem && itemPos(currentItem) != fixPos  )
	{
		if (currentItem->childCount() > 0)
			currentItem=currentItem->firstChild();
		else
			currentItem=currentItem->nextSibling();
		
		currentPos++;
	};	
	return currentPos;
};

