/***************************************************************************
                          clinkmanagement.cpp  -  description
                             -------------------
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by The team of BibleTime
    email                : BibleTime@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "clinkmanagement.h"

#include <qstrlist.h>
#include <kquickhelp.h>

CLinkManagement::CLinkManagement(QWidget *parent, const char *name ) : QWidget(parent,name)
{
	config= kapp->getConfig();
	currentItem = 0;
	linkList = new QList<QListViewItem>;

	this->initView();
	this->readSettings();

	connect(ext_Edit,SIGNAL(textChanged(const char*)),	
					this, SLOT(slotExtensionChanged(const char*)));
	connect(command_Edit,SIGNAL(textChanged(const char*)),	
					this, SLOT(slotCommandlineChanged(const char*)));
	connect(add_Button, SIGNAL(clicked()),
					this, SLOT(slotAddClicked()));
	connect(change_Button, SIGNAL(clicked()),
					this, SLOT(slotChangeClicked()));	
	connect(delete_Button, SIGNAL(clicked()),
					this, SLOT(slotDeleteClicked()));
	connect(mainListView, SIGNAL(selectionChanged(QListViewItem*)),
					this, SLOT(slotListSelectionChanged(QListViewItem*)));
}

CLinkManagement::~CLinkManagement()
{

}

/**  */
void CLinkManagement::resizeEvent( QResizeEvent *event )
{
	mainListView->resize(this->width(), this->height()/2);
	mainListView->setColumnWidth(0, mainListView->width()/2 -5);
	mainListView->setColumnWidth(1, mainListView->width()/2 -5);
	
	ext_Label->setGeometry(5,this->height()/2+5, 200,30);
 	ext_Edit->setGeometry(210,this->height()/2+5,100,30);

	command_Label->setGeometry(5,this->height()/2+40, 200,30);
 	command_Edit->setGeometry(210,this->height()/2+40,this->width()-215,30);

	main_Separator->setGeometry(5,this->height()/2+80,this->width()-10, 5 );
	add_Button->setGeometry(5,this->height()/2+90,100,30);
	change_Button->setGeometry(this->width()/2-52,this->height()/2+90,100,30);	
	delete_Button->setGeometry(this->width()-105,this->height()/2+90,100,30);
}

/**  */
void CLinkManagement::slotExtensionChanged(const char* text)
{
	QString dummy;
	dummy = text;

	if ( dummy!="" )
		command_Edit->setEnabled(true);
	else
		command_Edit->setEnabled(false);

	if (dummy!="" && currentItem!=0)	
	{
		change_Button->setEnabled(true);		
		change_Button->setEnabled(true);
	}
	else
	{
		change_Button->setEnabled(false);		
		change_Button->setEnabled(false);
	}	
}

/**  */
void CLinkManagement::slotCommandlineChanged(const char* text)
{
	QString dummy;
	dummy = text;

	if ( dummy!="" )
		add_Button->setEnabled(true);
	else
		add_Button->setEnabled(false);
		
	if (dummy!="" && currentItem!=0)	
	{
		change_Button->setEnabled(true);		
		change_Button->setEnabled(true);
	}
	else
	{
		change_Button->setEnabled(false);		
		change_Button->setEnabled(false);
	}	
}

/**  */
void CLinkManagement::slotAddClicked()
{
	QListViewItem *item= new QListViewItem(mainListView);
	item->setText(0, ext_Edit->text());
	item->setText(1, command_Edit->text());

	linkList->append(item);
}

/**  */
void CLinkManagement::slotChangeClicked()
{
	if (currentItem!=0)
	{
		currentItem->setText(0, ext_Edit->text());
		currentItem->setText(1, command_Edit->text());
	};
	
	change_Button->setEnabled(false);
}

/**  */
void CLinkManagement::slotDeleteClicked()
{
	if (currentItem)
	{
		linkList->first();
		while (linkList->current())
		{
			if (linkList->current() == currentItem )
			{
				linkList->remove();
				break;
			}
			else linkList->next();
		}
		delete currentItem;
	}

	currentItem=0;
	delete_Button->setEnabled(false);
	change_Button->setEnabled(false);	
}

/**  */
void CLinkManagement::readSettings()
{
	config->setGroup("Linkmanagement");
	QStrList		*extensionList = new QStrList;
	QStrList		*commandList = new QStrList;

	config->readListEntry("Extensions",*extensionList);
	config->readListEntry("Commands", *commandList);
  if ( !extensionList || !commandList )
		return;

	QListViewItem *item =0;		
	extensionList->first();
	commandList->first();

	while ( extensionList->current() && commandList->current() )
	{
		item = new QListViewItem(mainListView);
		item->setText(0, extensionList->current());
		item->setText(1, commandList->current());
		linkList->append(item);
		
		extensionList->next();
		commandList->next();		
	};
}

/** Saves the entries to the config file */
void CLinkManagement::saveSettings()
{
	QStrList		*extensionList = new QStrList;
	QStrList		*commandList = new QStrList;
	
	linkList->first();
	while (linkList->current())
	{
		extensionList->append( linkList->current()->text(0) );
		commandList->append( linkList->current()->text(1) );
		linkList->next();
	};

	config->setGroup("Linkmanagement");
	config->writeEntry("Extensions", *extensionList);
	config->writeEntry("Commands", *commandList);
	config->sync();

	emit sigRefreshLinkLists();
}


/**  */
void CLinkManagement::initView()
{
	mainListView = new QListView(this);
	mainListView->addColumn(i18n("File extension"),-1);
	mainListView->addColumn(i18n("commandline"),-1);
	mainListView->header()->hide();
	mainListView->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  mainListView->setLineWidth( 2 );
	mainListView->setAllColumnsShowFocus(true);

	ext_Label=new QLabel(this, "ext_Label" );
	ext_Label->setText(i18n("File extension"));
	KQuickHelp::add(ext_Label, i18n("Type in the edit line the file extension you want to configure."));

	ext_Edit= new QLineEdit(this, "ext_Edit");

	command_Label = new QLabel(this, "command_Label");
	command_Label->setText(i18n("Command line"));
	command_Edit = new QLineEdit(this, "command_Edit");
	command_Edit->setEnabled(false);

	main_Separator= new KSeparator(KSeparator::HLine,this );

	add_Button=new QPushButton(this, "add_Button");
	add_Button->setText(i18n("Add entry"));
	add_Button->setEnabled(false);
	KQuickHelp::add(add_Button, i18n("Use this button to add the specified options as an entry in the list at the top of the page."));

	change_Button=new QPushButton(this, "add_Button");
	change_Button->setText(i18n("Change"));
	change_Button->setEnabled(false);
	KQuickHelp::add(change_Button, i18n("Use this button to change the current entry"));

	delete_Button=new QPushButton(this, "delete_Button");
	delete_Button->setText(i18n("Delete entry"));
	delete_Button->setEnabled(false);
	KQuickHelp::add(delete_Button, i18n("Click on this button to delete the selected entry in the list."));
}

/**  */
void CLinkManagement::slotListSelectionChanged( QListViewItem* item )
{
	currentItem = item;
	delete_Button->setEnabled(true);
  	
	ext_Edit->setText( item->text(0) );
	command_Edit->setText( item->text(1) );	
	change_Button->setEnabled(false);
}


