/************************************************************************
                          swordapi.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jun 24 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qregexp.h>

// SWORD STUFF
#include <swmgr.h>
#include <versekey.h>
#include <regex.h>
#include <swconfig.h>

#include "bibletimedoc.h"
#include "swordapi.h"

//own includes
#include "filters/plainfootnotes.h"

#include <gbfhtml.h>
#include <rwphtml.h>
#include <plainhtml.h>
#include <rawgbf.h>

BibleTimeMgr::BibleTimeMgr() : SWMgr()
{
//These lines are commented because you have to change some SWORD things to usw this code.
//This enables the filter for footnotes in plain text
	SWFilter *tmpFilter = 0;
	tmpFilter = new PLAINFootnotes();
	optionFilters.insert(FilterMap::value_type("PLAINFootnotes", tmpFilter));
	cleanupFilters.push_back(tmpFilter);

	gbftohtml 	= new GBFHTML();
	rwptohtml 	= new RWPHTML();
	plaintohtml = new PLAINHTML();
	
	Load();
}

BibleTimeMgr::~BibleTimeMgr()
{
	if (gbftohtml!=0)
		delete gbftohtml;
			
	if (rwptohtml!=0)
		delete rwptohtml;
		
	if (plaintohtml!=0)
		delete plaintohtml;
}
			
void BibleTimeMgr::AddRenderFilters(SWModule *module, ConfigEntMap &section)
{
	string sourceformat;
	string moduleDriver;
	ConfigEntMap::iterator entry;
	bool noDriver = true;

	sourceformat = ((entry = section.find("SourceType")) != section.end()) ? (*entry).second : (string) "";
	moduleDriver = ((entry = section.find("ModDrv")) != section.end()) ? (*entry).second : (string) "";
	// Temporary: To support old module types
	if (sourceformat.empty())	{
		if (dynamic_cast<RawGBF *>(module))
			sourceformat = "GBF";
	}
	if (!stricmp(sourceformat.c_str(), "GBF")) {
		module->AddRenderFilter(gbftohtml);
		noDriver = false;
	}
	if (!stricmp(sourceformat.c_str(), "PLAIN")) {
		module->AddRenderFilter(plaintohtml);
		noDriver = false;
	}
	if (!stricmp(module->Name(), "-+*personal*+-")) {
		module->AddRenderFilter(plaintohtml);
		noDriver = false;
	}
	if (!stricmp(module->Name(), "RWP")) {
		module->AddRenderFilter(rwptohtml);
		noDriver = false;
	}
	if (noDriver){
		if (!stricmp(moduleDriver.c_str(), "RawCom")) {
			module->AddRenderFilter(plaintohtml);
			noDriver = false;
		}
		if (!stricmp(moduleDriver.c_str(), "RawLD")) {
			module->AddRenderFilter(plaintohtml);
			noDriver = false;
		}
	}
	
	/** Use PLAINHTML as standard filter, if no is specified use plaintohtml
		* I used a profiler and saw this function eats more than 80% of the program power!
		* We have to optimize the PLAINTOHTML filter.
	*/
	if (noDriver){
		module->AddRenderFilter(plaintohtml);
		noDriver = false;
	};
}

// End definition of new Manager

HTMLEntryDisplay::HTMLEntryDisplay(BibleTimeDoc *doc)
{
	this->doc = doc;
	
	//set up colors
	//we implement reading colors only in this class vecause HTMNLChapterDisplay is derived from this class
	KConfig *config= kapp->getConfig();
	config->setGroup( "DocBrowserAppearance" );

	QColor c;
	c= config->readColorEntry("versenumberColor");
	verseNumberColor.sprintf( "%02X%02X%02X", c.red(), c.green(), c.blue() );
	
	c= config->readColorEntry("verseColor");	
	verseColor.sprintf( "%02X%02X%02X", c.red(), c.green(), c.blue() );
};

HTMLEntryDisplay::~HTMLEntryDisplay()
{
};

// provide a HTML rendering of the received text
char HTMLEntryDisplay::Display(SWModule &imodule)
{
	QString result 	= 0;
	QString type 		= imodule.Type();
	QString name 		= imodule.Name();
	(const char *)imodule; // get key (taken from Cheatah)
	QString text((const char *)imodule);
	QString mark		= 0;
	int 		pos 		= 0;
	int 		index 	= 0;
	bool 		done 		= false;
	// scan text for hrefs and mark them
	while (!done)
	{
		if ((pos = text.find( "http://", index, false )) == -1)
			done = true;
		else
		{
			// found a href to mark
			if ((index = text.find(QRegExp("[\\s<>]"),pos)) == -1)
				index = text.length();
				
			mark = (QString) "\">" + text.mid(pos,index-pos) + (QString) "</A>";
			text.insert(index,mark.data());
			text.insert(pos,"<A HREF=\"");
			index += (index-pos+15);
		}
	}
	result.sprintf("<HTML><BODY><H3><FONT COLOR=#"+ verseNumberColor +">[%s]</FONT>", imodule.KeyText());
	result.append("</H3>");
	result.append( text.data() );
	result.append("\n</BODY></HTML>\n");
	
	doc->sendHTML(type, result);
	
	return 0;
}

void HTMLEntryDisplay::slotChangeColors()
{
	KConfig *config= kapp->getConfig();
	config->setGroup( "DocBrowserAppearance" );

	QColor c;
	c= config->readColorEntry("versenumberColor");
	verseNumberColor.sprintf( "%02X%02X%02X", c.red(), c.green(), c.blue() );
	
	c= config->readColorEntry("verseColor");
	verseColor.sprintf( "%02X%02X%02X", c.red(), c.green(), c.blue() );
};

HTMLChapterDisplay::~HTMLChapterDisplay()
{
};

// we always want to view a whole chapter
char HTMLChapterDisplay::Display(SWModule &imodule)
{
	QString result		= "<HTML><TITLE>Text</TITLE><BODY>";
	QString type 			= imodule.Type();
	QString	tmp				= 0;
	VerseKey *key 		= (VerseKey *)(SWKey *)imodule;
	int curVerse 			= key->Verse();
	int curChapter 		= key->Chapter();
	int curBook 			= key->Book();

	for (key->Verse(1); (key->Book() == curBook && key->Chapter() == curChapter && !imodule.Error()); imodule++)
	{
		tmp.sprintf("<B><FONT COLOR=#"+verseNumberColor+">%d.</FONT></B> ", key->Verse());
		result.append(tmp.data());
		
		if (key->Verse() == curVerse)
		{
			result.append("<A NAME=\"Current\">");
			result.append("<FONT COLOR=#"+verseColor +">");
			result.append( (const char *)imodule );
			result.append("</FONT></A>");
		} else {
			result.append( (const char *)imodule );
		}
		result.append("<BR>\n");
	}
	result.append("</BODY></HTML>\n");
	key->Verse(1);
	key->Chapter(1);
	key->Book(curBook);
	key->Chapter(curChapter);
	key->Verse(curVerse);
	doc->sendHTML(type, result);
	return 0;
}
