#include "TabView.h"

TabView::TabView(QWidget *parent, const char *name)
	: KTabListBox(parent, name)
{
    setFocusPolicy(QWidget::StrongFocus);
    setAutoUpdate(TRUE);
    //lbox.setAutoUpdate(TRUE);
}

void TabView::fitAll(void)
{
    for(int i=0; i<numCols(); i++){
	int res = 80;
	/*
	  QFontMetrics metrics(tab->tableFont());
	  int headWidth = metrics.width(tab->text(0, i));
	  res = headWidth;
	*/
	setColumnWidth(i, res);
    }
    repaint();
}

/**
	Set the titles of each columns using a string where column names are 
	separated by a tab ('\t').
*/
void TabView::setColumns(QString columns)
{
    if(columns.isEmpty())
	return;
    int index = 0;
    bool fin = false;
    int i = 0;
    while(!fin) {
	int index2 = columns.find('\t', index);
	if(index2 == -1) {
	    index2 = columns.length();
	    fin = true;
	}
	QString col = columns.mid(index, index2-index);
	setColumn(i, col);
	index = index2+1;
	i++;
    }
}

