// -*-Mode: C++;-*-  
/*
 * $Id: TableView.h,v 2.3 1999/07/31 00:51:56 ral Exp $
 */

#ifndef CTableView_included
#define CTableView_included

#include "TableViewData.h"
#include <qlist.h>
#include "tabledescr.h"
#include <qmsgbox.h>
#include "PatternPair.h"
#include "stringlist.h"

class CTableView : public CTableViewData
{
    Q_OBJECT

public:

    CTableView (QWidget* parent = NULL, const char* name = NULL);

    virtual ~CTableView();
protected slots:
    void MakeRequest();
    void OffsetSet(int);
    void CountSet(int);
    void db_select(int);
    void table_select(int);
    void search_rows();
    void entrySelected(int);
    void entrySelected(int col,int){entrySelected(col);}
    void addRow();
    void OutputSelected(int);
    void modifyRow();
    void delete_row();
    void emptyTable();
    void saveResult();

public slots:
    void show();
    void RefreshLists();

private:
    ColumnList *Current_Table_Fields;
    ColumnList *Current_Displayed_Fields;
    void set_buttons(bool how);
    bool KeyDisplayed();
    CColumnDescriptor*FindTableItem(const char*what);
    int BreakIntoParts(PatternList*BreakList,PatternList*KeyList=0,
		       int count = -1,bool no_auto_filter = false);
    void saveAscii(const char*filename);
    void saveHtml(const char*filename);
    void saveLatex(const char*filename);
};

#endif // CTableView_included
