#include "TextInputData.h"

#ifndef rcsid
static const char rcsid[]="$Id: TextInputData.cpp,v 2.2 1999/07/04 22:30:44 ral Exp $";
const char*textinputdata_rcs(){return rcsid;}
#endif

#define Inherited QDialog
#include <kapp.h>
#include <qpushbt.h>

CTextInputData::CTextInputData
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, 643072 )
{
	InputField = new QLineEdit( this, "InputField" );
	InputField->setGeometry( 10, 40, 200, 30 );
	InputField->setMinimumSize( 10, 10 );
	InputField->setMaximumSize( 32767, 32767 );
	connect( InputField, SIGNAL(returnPressed()), SLOT(accept_field()) );
	connect( InputField, SIGNAL(textChanged(const char*)), SLOT(inputChanged(const char*)) );
	InputField->setText( "" );
	InputField->setMaxLength( 32767 );
	InputField->setEchoMode( QLineEdit::Normal );
	InputField->setFrame( TRUE );

	OkButton = new QPushButton( this, "PushButton_1" );
	OkButton->setGeometry( 10, 70, 100, 30 );
	OkButton->setMinimumSize( 10, 10 );
	OkButton->setMaximumSize( 32767, 32767 );
	connect( OkButton, SIGNAL(clicked()), SLOT(accept()) );
	OkButton->setText( "OK" );
	OkButton->setAutoRepeat( FALSE );
	OkButton->setAutoResize( FALSE );

	QPushButton* dlgedit_PushButton_2;
	dlgedit_PushButton_2 = new QPushButton( this, "PushButton_2" );
	dlgedit_PushButton_2->setGeometry( 110, 70, 100, 30 );
	dlgedit_PushButton_2->setMinimumSize( 10, 10 );
	dlgedit_PushButton_2->setMaximumSize( 32767, 32767 );
	connect( dlgedit_PushButton_2, SIGNAL(clicked()), SLOT(reject()) );
	dlgedit_PushButton_2->setText( "Cancel" );
	dlgedit_PushButton_2->setAutoRepeat( FALSE );
	dlgedit_PushButton_2->setAutoResize( FALSE );

	InputLabel = new QLabel( this, "Label_1" );
	InputLabel->setGeometry( 10, 10, 200, 30 );
	InputLabel->setMinimumSize( 10, 10 );
	InputLabel->setMaximumSize( 32767, 32767 );
	InputLabel->setFrameStyle( 34 );
	InputLabel->setText( i18n("Insert new Database Name") );
	InputLabel->setAlignment( 292 );
	InputLabel->setMargin( -1 );

	resize( 220,110 );
	setMinimumSize( 220, 110 );
	setMaximumSize( 220, 110 );
}


CTextInputData::~CTextInputData()
{
}
void CTextInputData::accept_field()
{
}
void CTextInputData::inputChanged(const char*)
{
}
