#include <qlist.h>
#include <qstrlist.h>
#include <qlabel.h>

#include "PatternPair.h"
#include "grantedit.h"

#ifndef rcsid
static const char rcsid[]="$Id: grantedit.cpp,v 2.4 1999/07/31 19:52:38 ral Exp $";
const char*grantedit_rcs(){return rcsid;}
#endif

#define Inherited CGrantEditData

CGrantEdit::CGrantEdit(QWidget* parent,	const char* name)
    :Inherited( parent, name )
{
    OrigPatterns = 0;
    EditCounts = 0;
    WidgetList = 0;
    ShutdownBox->setEnabled(FALSE);
    ReloadBox->setEnabled(FALSE);
    ProcessBox->setEnabled(FALSE);
    FileBox->setEnabled(FALSE);
}

CGrantEdit::~CGrantEdit()
{
    if (WidgetList)
	delete WidgetList;
}

void CGrantEdit::set_entries(PatternList*Patterns,stringlist*titles)
{
    QLineEdit*dummy;
    CPatternPair*pat;
    OrigPatterns = Patterns;
    WidgetList = new QList<QLineEdit>;
    unsigned int i = 0;
    unsigned int edit_counts = 0;
    bool how = FALSE;
    QBoxLayout*d_layout;
    QLabel*d_label;
    QString s,t;
    if (!titles)
	return;
    edit_counts = titles->size();
    for (i = 0; i < edit_counts; i++) {
	d_layout = new QBoxLayout(QBoxLayout::LeftToRight, 2, NULL);
	EditLayout->addLayout(d_layout,0);
	s = (*titles)[i].c_str();
	d_label = new QLabel(s,this);
	d_label->setAlignment(AlignRight|AlignVCenter); 
	d_label->setMinimumSize(80,25);
	d_label->setMaximumSize(80,25);
	d_layout->addWidget(d_label);
	pat = &((*Patterns)[i]);
	dummy = new QLineEdit(this,pat->get_entry());
	if (pat->isNumeric())
	    dummy->setEnabled(FALSE);
	if (pat->isPassword())
	    dummy->setEchoMode(QLineEdit::Password);
	dummy->setText(pat->get_pattern());
	dummy->resize(400,25);
	dummy->setMinimumSize(10,25);
	dummy->setMaximumSize(32767,25);
	d_layout->addWidget(dummy);
	WidgetList->append(dummy);
	connect( dummy, SIGNAL(returnPressed()), SLOT(change_focus()) );
	if (how == FALSE && !pat->isNumeric()) {
	    dummy->setFocus();
	    how = TRUE;
	}
    }
    setMinimumSize(420,edit_counts*25+edit_counts*5+90);
    i = 0;
    for (i = edit_counts;i < Patterns->size();i++) {
//	pat = Patterns->at(i);
	s = (*Patterns)[i].get_pattern();
	if (s == "Y" || s ==  "y")
	    how = TRUE;
	else 
	    how = FALSE;
	switch (i-edit_counts) {
	case 0:
	    SelectBox->setChecked(how);
	    break;
	case 1:
	    InsertBox->setChecked(how);
	    break;
	case 2:
	    UpdateBox->setChecked(how);
	    break;
	case 3:
	    DeleteBox->setChecked(how);
	    break;
	case 4:
	    CreateBox->setChecked(how);
	    break;
	case 5:
	    DropBox->setChecked(how);
	    break;
	case 6:
	    ReloadBox->setChecked(how);
	    ReloadBox->setEnabled(TRUE);
	    break;
	case 7:
	    ShutdownBox->setChecked(how);
	    ShutdownBox->setEnabled(TRUE);
	    break;
	case 8:
	    ProcessBox->setChecked(how);
	    ProcessBox->setEnabled(TRUE);
	    break;
	case 9:
	    FileBox->setChecked(how);
	    FileBox->setEnabled(TRUE);
	    break;
	default:
	    break;
	}
    }
    adjustSize();
}

PatternList * CGrantEdit::get_entries()
{
    QLineEdit*currentEdit;
    PatternList*Patterns;
    QString pat;
    QString name;
    QString yes = "Y";
    QString no = "N";
    Patterns = new PatternList;
    for (currentEdit=WidgetList->first();currentEdit!=0;currentEdit=WidgetList->next()) {
	if (currentEdit->isEnabled()) {
	    name = currentEdit->name();
	    pat = currentEdit->text();
	    Patterns->push_back(CPatternPair(name,pat));
	}
    }
    set_yesno("Select_priv",SelectBox,Patterns);
    set_yesno("Insert_priv",InsertBox,Patterns);
    set_yesno("Update_priv",UpdateBox,Patterns);
    set_yesno("Delete_priv",DeleteBox,Patterns);
    set_yesno("Create_priv",CreateBox,Patterns);
    set_yesno("Drop_priv",DropBox,Patterns);

    if (ReloadBox->isEnabled())
	set_yesno("Reload_priv",ReloadBox,Patterns);
    if (ShutdownBox->isEnabled())
	set_yesno("Shutdown_priv",ShutdownBox,Patterns);
    if (ProcessBox->isEnabled())
	set_yesno("Process_priv",ProcessBox,Patterns);
    if (FileBox->isEnabled())
	set_yesno("File_priv",FileBox,Patterns);
    return Patterns;
}

void CGrantEdit::set_yesno(const char*name,QCheckBox*box,PatternList*pats)
{
    string yes = "Y";
    string no = "N";

    if (box->isChecked())
	pats->push_back(CPatternPair(name,yes.c_str()));
    else
	pats->push_back(CPatternPair(name,no.c_str()));
}

void CGrantEdit::change_focus()
{
    focusNextPrevChild(TRUE);
}

