/***************************************************************************
                                 KSqlAbout.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "ksqlabout.h"
#include "korapic.xpm"
#include <iostream.h>
#include <qmultilinedit.h>

#include <qlabel.h>

KSqlAbout::KSqlAbout(QWidget* parent, const char* name) :
		KDialog( parent, name, TRUE, 1036288 )
{
	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	QLabel* pictureWLabel;
	pictureWLabel = new QLabel( this, "pictureWLabel");
	pictureWLabel->setMinimumSize(100, 100);
	pictureWLabel->setMaximumSize(100, 100);
	pictureWLabel->setFocusPolicy( QWidget::NoFocus );
	pictureWLabel->setBackgroundMode( QWidget::PaletteBackground );
	pictureWLabel->setFontPropagation( QWidget::NoChildren );
	pictureWLabel->setPalettePropagation( QWidget::NoChildren );
	pictureWLabel->setFrameStyle( 0 );
	pictureWLabel->setLineWidth( 1 );
	pictureWLabel->setMidLineWidth( 0 );
	pictureWLabel->QFrame::setMargin( 0 );
	pictureWLabel->setAlignment( 292 );
	pictureWLabel->setMargin( -1 );
	pictureWLabel->setPixmap(picture);

	QLabel* nameWLabel;
	nameWLabel = new QLabel( this, "nameWLabel" );
	nameWLabel->setGeometry( 5, 15, 470, 30 );
	nameWLabel->setMinimumSize( 410, 30 );
	nameWLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "helvetica", 18, 75, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		nameWLabel->setFont( font );
	}
	nameWLabel->setFocusPolicy( QWidget::NoFocus );
	nameWLabel->setBackgroundMode( QWidget::PaletteBackground );
	nameWLabel->setFontPropagation( QWidget::NoChildren );
	nameWLabel->setPalettePropagation( QWidget::NoChildren );
	nameWLabel->setFrameStyle( 0 );
	nameWLabel->setLineWidth( 1 );
	nameWLabel->setMidLineWidth( 0 );
	nameWLabel->QFrame::setMargin( 0 );
	nameWLabel->setText( i18n("K Oracle Sql Communicator V0.3.2") );
	nameWLabel->setAlignment( 292 );
	nameWLabel->setMargin( -1 );

	QLabel* writtenWLabel;
	writtenWLabel = new QLabel( this, "writtenWLabel" );
	writtenWLabel->setGeometry( 5, 55, 470, 30 );
	writtenWLabel->setMinimumSize( 410, 30 );
	writtenWLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "helvetica", 14, 63, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		writtenWLabel->setFont( font );
	}
	writtenWLabel->setFocusPolicy( QWidget::NoFocus );
	writtenWLabel->setBackgroundMode( QWidget::PaletteBackground );
	writtenWLabel->setFontPropagation( QWidget::NoChildren );
	writtenWLabel->setPalettePropagation( QWidget::NoChildren );
	writtenWLabel->setFrameStyle( 0 );
	writtenWLabel->setLineWidth( 1 );
	writtenWLabel->setMidLineWidth( 0 );
	writtenWLabel->QFrame::setMargin( 0 );
	writtenWLabel->setText( i18n("written by Ullrich Wagner") );
	writtenWLabel->setAlignment( 292 );
	writtenWLabel->setMargin( -1 );

	QLabel* emailWLabel;
	emailWLabel = new QLabel( this, "emailWLabel" );
	emailWLabel->setGeometry( 5, 95, 470, 30 );
	emailWLabel->setMinimumSize( 410, 30 );
	emailWLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "helvetica", 14, 50, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		emailWLabel->setFont( font );
	}
	emailWLabel->setFocusPolicy( QWidget::NoFocus );
	emailWLabel->setBackgroundMode( QWidget::PaletteBackground );
	emailWLabel->setFontPropagation( QWidget::NoChildren );
	emailWLabel->setPalettePropagation( QWidget::NoChildren );
	emailWLabel->setFrameStyle( 0 );
	emailWLabel->setLineWidth( 1 );
	emailWLabel->setMidLineWidth( 0 );
	emailWLabel->QFrame::setMargin( 0 );
	emailWLabel->setText( "Ullrich.Wagner@gmx.de" );
	emailWLabel->setAlignment( 292 );
	emailWLabel->setMargin( -1 );

	QLabel* gnuWLabel;
	gnuWLabel = new QLabel( this, "gnuWLabel" );
	gnuWLabel->setGeometry( 5, 135, 470, 30 );
	gnuWLabel->setMinimumSize( 410, 30 );
	gnuWLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "helvetica", 14, 50, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		gnuWLabel->setFont( font );
	}
	gnuWLabel->setFocusPolicy( QWidget::NoFocus );
	gnuWLabel->setBackgroundMode( QWidget::PaletteBackground );
	gnuWLabel->setFontPropagation( QWidget::NoChildren );
	gnuWLabel->setPalettePropagation( QWidget::NoChildren );
	gnuWLabel->setFrameStyle( 0 );
	gnuWLabel->setLineWidth( 1 );
	gnuWLabel->setMidLineWidth( 0 );
	gnuWLabel->QFrame::setMargin( 0 );
	gnuWLabel->setText( i18n("Published under the GNU Public License") );
	gnuWLabel->setAlignment( 292 );
	gnuWLabel->setMargin( -1 );

	QLabel* creditsWLabel;
	creditsWLabel = new QLabel( this, "creditsWLabel" );
	creditsWLabel->setMinimumSize( 410, 30 );
	creditsWLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "helvetica", 12, 50, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		creditsWLabel->setFont( font );
	}
	creditsWLabel->setFocusPolicy( QWidget::NoFocus );
	creditsWLabel->setBackgroundMode( QWidget::PaletteBackground );
	creditsWLabel->setFontPropagation( QWidget::NoChildren );
	creditsWLabel->setPalettePropagation( QWidget::NoChildren );
	creditsWLabel->setFrameStyle( 0 );
	creditsWLabel->setLineWidth( 1 );
	creditsWLabel->setMidLineWidth( 0 );
	creditsWLabel->QFrame::setMargin( 0 );
	creditsWLabel->setText( i18n("Many thanks to the following peoples for their suggestions") );
	creditsWLabel->setAlignment( 289 );
	creditsWLabel->setMargin( -1 );


	QMultiLineEdit* creditsMultiText = new QMultiLineEdit(this, "creditsWMultiText");
	creditsMultiText->setMinimumSize(410, 80);
	{
		QFont font( "courier", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		creditsMultiText->setFont( font );
	}
	creditsMultiText->setFocusPolicy( QWidget::StrongFocus );
	creditsMultiText->setBackgroundMode( QWidget::PaletteBase );
	creditsMultiText->setFontPropagation( QWidget::SameFont );
	creditsMultiText->setPalettePropagation( QWidget::SameFont );
	creditsMultiText->setFrameStyle( 51 );
	creditsMultiText->setLineWidth( 2 );
	creditsMultiText->setMidLineWidth( 0 );
	creditsMultiText->QFrame::setMargin( 0 );
	creditsMultiText->setReadOnly( TRUE );
	creditsMultiText->setOverwriteMode( FALSE );
	creditsMultiText->setAutoUpdate( TRUE );
	creditsMultiText->insertLine( "Nils Rossmann <nrossmann@averytower.rhein-neckar.de>" );
	creditsMultiText->insertLine( "Mathias Kettner <kettner@suse.de>" );

	

	closeButton = new QPushButton( this, "closeWButton" );
	closeButton->setGeometry( 190, 195, 100, 30 );
	closeButton->setMinimumSize( 100, 30 );
	closeButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		closeButton->setFont( font );
	}
	connect( closeButton, SIGNAL(clicked()), SLOT(closeButtonClickedCB()) );
	closeButton->setFocusPolicy( QWidget::TabFocus );
	closeButton->setBackgroundMode( QWidget::PaletteBackground );
	closeButton->setFontPropagation( QWidget::NoChildren );
	closeButton->setPalettePropagation( QWidget::NoChildren );
	closeButton->setText( i18n("Close") );
	closeButton->setAutoRepeat( FALSE );
	closeButton->setAutoResize( FALSE );
	closeButton->setToggleButton( FALSE );
	closeButton->setDefault( TRUE );
	closeButton->setAutoDefault( FALSE );
	closeButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "top" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 10 );
	QBoxLayout* layout2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "picture" );
	layout1->addLayout(layout2);
	layout2->addStrut(0);
	layout2->addSpacing(10);
	layout2->addWidget(pictureWLabel, 1);
	layout2->addStretch(10);
	layout1->addWidget( nameWLabel, 1, 36 );
	layout1->addSpacing( 5 );
	layout1->addWidget( writtenWLabel, 1, 36 );
	layout1->addSpacing( 5 );
	layout1->addWidget( emailWLabel, 1, 36 );
	layout1->addSpacing( 5 );
	layout1->addWidget( gnuWLabel, 1, 36 );
	layout1->addSpacing(5);
	layout1->addWidget( creditsWLabel, 1, 36);
	layout1->addWidget( creditsMultiText, 1, 36);
	layout1->addStretch( 10 );
	layout1->addSpacing( 5 );
	layout1->addWidget( closeButton, 1, 36 );
	layout1->addSpacing( 10 );
	resize( 480,240 );
	setMinimumSize( 480, 240 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("About KOra") );
}


KSqlAbout::~KSqlAbout()
{
}

void KSqlAbout::closeButtonClickedCB()
{
	this->close();
}
