#ifndef K_LIST_H
#define K_LIST_H


#include <list>

#define forIterator(i,list) for(i = list.begin(); i != list.end(); i++)

template <class Element>
class KList: public list<Element>
{
	public:
	KList(): list<Element>(){};
	KList(KList<Element> const& l): list<Element>(l){};
	KList(Element const& e): list<Element>() {this->push_back(e);};
	friend ostream & operator << (ostream &o, const KList<Element>& l)
	{
		o << "(";
		typename list<Element>::const_iterator i;

		forIterator(i,l)
		{
			if (i != l.begin())
			{ o << ','; }

			o << *i;
		}

		o << ")";
		return(o);
	}
};

#endif     // K_List_H

