
#include "SQL.h" 

// Getting data from a PGSQL DB
// gcc /usr/lib/libpq.so  -o postsample postsample.c 
        


         #include <stdio.h>
//         #include "/usr/include/pgsql/libpq-fe.h"  

         void
         exit_nicely(PGconn* conn)
         {
           PQfinish(conn);
        //   exit(1);
         }


  int SQLQuerier::ExecuteQuery(QString dbname,QString Query)
         {
    ErrorText="";  // clearing previous errors
    
           /* make a connection to the database */
           conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbname);

           /* check to see that the backend connection was successfully made */
           if (PQstatus(conn) == CONNECTION_BAD) {
             printf("%s",PQerrorMessage(conn));
             ErrorText=PQerrorMessage(conn);
             exit_nicely(conn);
             return ERRORS_RETURNED;
           }


           /* start a transaction block */

           res = PQexec(conn,"BEGIN");
           if (PQresultStatus(res) != PGRES_COMMAND_OK) {
             printf("BEGIN command failed");
             PQclear(res);
             ErrorText="Transaction couldn't begin";
             exit_nicely(conn);
             return ERRORS_RETURNED;
           }
           /* should PQclear PGresult whenever it is no longer needed to avoid
              memory leaks */
              PQclear(res);

            res = PQexec(conn,Query); // EXECUTING QUERY
  
       if (PQresultStatus(res) == PGRES_COMMAND_OK) 
          {
           // Query executed successfully, no results returned
           return SUCCESS_NO_RESULTS;  
          };



       if (PQresultStatus(res) == PGRES_TUPLES_OK) 
           {
           // Query executed successfully, results returned
            return SUCCESS_RESULTS;
           };
           
       switch(PQresultStatus(res))         // error handling
   {
    case PGRES_EMPTY_QUERY:
     ErrorText="Empty query";
     break;
    case PGRES_BAD_RESPONSE:
     ErrorText="An unexpected response was returned by postgres";
     break;
    case PGRES_NONFATAL_ERROR:
     ErrorText="Invalid query";
     break;
    case PGRES_FATAL_ERROR:
     ErrorText="Fatal error occured";
     break;
    default:
     ErrorText="Unknown error";
   };

 PQclear(res);
 exit_nicely(conn);
 return ERRORS_RETURNED;

/*
  USING FORMATTED OUTPUT  
   char bufx[20000];
   setbuffer(stdin, bufx,20000);    

char *buf;
buf=new char[res->tupArrSize+100];
PQdisplayTuples(res,stdout,TRUE," ",FALSE,FALSE);
printf("ddd%smmm",bufx);
delete buf;
ResultsMLE->setText(bufx);
fclose(stdin);
*/
         }


int SQLQuerier::CleanUp()
{
           PQclear(res);

           /* end the transaction */
           res = PQexec(conn, "END");
           PQclear(res);

           /* close the connection to the database and cleanup */
           PQfinish(conn);
return 0;
}


