/***************************************************************************
    klogindlg.cpp  -  Logon dialog implementation

    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

#include "klogindlg.h"

KLoginDlg::KLoginDlg(QWidget *parent, const char* name,
  const char* initialUsername = 0, const char* initialDatabase) :
  KDialog(parent, name, true),
  topLayout(this, 12, 12, "topLayout"),
  editLayout(3, 2, 6, "editLayout"),
  buttonLayout(6, "buttonLayout"),
  usrLabel(i18n("Username"), this, "usrLabel"),
  passLabel(i18n("Password"), this, "passLabel"),
  dbLabel(i18n("Database"), this, "dbLabel"),
  usrEdit(this, "usrEdit"),
  passEdit(this, "passEdit"),
  dbEdit(this, "dbEdit"),
  okButton(this, "okButton"),
  cancelButton(this, "cancelButton")
{
  // set dialog caption
  setCaption(i18n("Logon into ORACLE"));

  // calculate dialog and widgets size
  QFontMetrics metrics = fontMetrics();
  int h = metrics.height() + 8;
  int w = metrics.width(i18n("Username")) + 32;

  // set size
  setFixedSize(w * 2 + 32, (h + 6) * 4 + 32);

  // add layouts to top layout
  topLayout.addLayout(&editLayout);
  topLayout.addLayout(&buttonLayout);

  // setup components
  usrLabel.setMinimumSize(w, h);

  usrEdit.setMinimumSize(w, h);
  if( initialUsername ) usrEdit.setText(initialUsername);

  passLabel.setMinimumSize(w, h);

  passEdit.setMinimumSize(w, h);
  passEdit.setEchoMode(QLineEdit::Password);

  dbLabel.setMinimumSize(w, h);

  dbEdit.setMinimumSize(w, h);
  if( initialDatabase ) dbEdit.setText(initialDatabase);

  okButton.setText(i18n("Logon"));
  okButton.setMinimumSize(w + 6, h + 6);
  okButton.setDefault(TRUE);

  cancelButton.setText(i18n("Cancel"));
  cancelButton.setMinimumSize(w + 6, h + 6);

  // organize tab order
  setTabOrder(&usrEdit, &passEdit);
  setTabOrder(&passEdit, &dbEdit);
  setTabOrder(&dbEdit, &okButton);
  setTabOrder(&okButton, &cancelButton);
  setTabOrder(&cancelButton, &usrEdit);

  // add components
  editLayout.addWidget(&usrLabel, 0, 0, AlignLeft);
  editLayout.addWidget(&usrEdit, 0, 1, AlignCenter);
  editLayout.addWidget(&passLabel, 1, 0, AlignLeft);
  editLayout.addWidget(&passEdit, 1, 1, AlignCenter);
  editLayout.addWidget(&dbLabel, 2, 0, AlignLeft);
  editLayout.addWidget(&dbEdit, 2, 1, AlignCenter);

  buttonLayout.addWidget(&okButton);
  buttonLayout.addWidget(&cancelButton);

  // focus item
  usrEdit.setFocus();

  // center dialog inside parent
  if( parent )
    move(parent->x() + (parent->width() - width()) / 2,
      parent->y() + (parent->height() - height()) / 2);

  // setup slots
  connect(&cancelButton, SIGNAL(clicked()), SLOT(reject()));
  connect(&okButton, SIGNAL(clicked()), SLOT(slotLogon()));
}

KLoginDlg::~KLoginDlg()
{
}

void KLoginDlg::slotLogon()
{
  // get edit's values
  usr = usrEdit.text();
  pass = passEdit.text();
  db = dbEdit.text();

  if( usr.isEmpty() )
  {
    KMsgBox::message(this,
      i18n("Error"),
      i18n("You must specify ORACLE username."),
      KMsgBox::EXCLAMATION);
    usrEdit.setFocus();
    return;
  }

  // end dialog
  accept();
}

QString KLoginDlg::connectString()
{
  QString connect = usr;
  if( !pass.isEmpty() )
  {
    connect += '/';
    connect += pass;
  }
  if( !db.isEmpty() )
  {
    connect += '@';
    connect += db;
  }
  return connect;
}

QString KLoginDlg::identityString()
{
  QString connect = connectString();
  if( connect.isEmpty() ) return connect;
  QString ident;
  // cut 'username' field
  int i = connect.find('/');
  if( i == -1 ) i = connect.find('@');
  if( i != -1 ) ident = connect.left(i);
  else ident = connect;
  // add 'database' string
  i = connect.findRev('@');
  if( i != -1 ) ident += connect.right(connect.length() - i);
  else ident += "@LOCAL";
  return ident;
}
