/***************************************************************************
    ksqlplus.h  -  Application class interface

    begin                : Fri Dec 10 16:02:01 MSK 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSQLPLUS_H
#define KSQLPLUS_H
 

// platform configuration stuff
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qfont.h>
#include <qmultilinedit.h>

// include files for KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <keditcl.h>
#include <kprocess.h>

/**
  * The base class for KSqlPlus application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar.
  * KSqlPlusApp reimplements the methods that KTMainWindow provides for
  * main window handling and supports full session management as well
  * as keyboard accelerator configuration by using KAccel.
  * KSqlPlusApp uses KEdit widget for user input area and doesn't create
  * any self-handled documents and views.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  * @see KEdit
  *
  * @author Source framework automatically generated by KDevelop,
  *         (c) The KDevelop Team.
  * @author Yury Ledebev (yurylebedev@mail.ru).
  * @version KDevelop version 0.4 code generation
  */
class KSqlPlusApp : public KTMainWindow
{
  Q_OBJECT

  public:
    /** constructor of KSqlPlusApp, calls all init functions to create
      * the application. */
    KSqlPlusApp();
    /** empty destructor */
    ~KSqlPlusApp();
    /** enables menuentries/toolbar items */
    void enableCommand(int id);
    /** disables menuentries/toolbar items */
    void disableCommand(int id);
    /** add a opened file to the recent file list and
      * update recent file menu */
    void addRecentFile(const QString &file);
    /** remove a file from the recent file list by index and
      * update recent file menu */
    void removeRecentFile(int idx);
    /** opens a file specified by commandline option */
    void openDocumentFile(const char *cmdl);

  protected:
    /** saves general Options like all bar positions and status as well
      * as the geometry and the recent file list to the configuration file */
    void saveOptions();
    /** reads general Options again and initialize all variables like
      * the recent file list */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available
      * slots and changes the menu accelerators.
      * @see KAccel  */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups
      * as well as creating the helpMenu.
      * @see KApplication#getHelpMenu */
    void initMenuBar();
    /** creates the toolbars. */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing
      * a statuslabel. */
    void initStatusBar();
    /** creates views for user input and output */
    void initView();
    /** init SQL*Plus process */
    void initSqlplus();
    /** queryClose() is called by KTMainWindow on each closeEvent of a window.
      * Against the default implementation (only returns true),
      * this calles saveModified() on the document object to ask
      * if the document shall be saved if modified; on cancel
      * the closeEvent is rejected.
      * @see KTMainWindow#queryClose
      * @see KTMainWindow#closeEvent */
    virtual bool queryClose();
    /** queryExit() is called by KTMainWindow when the last window of
      * the application is going to be closed during the closeEvent().
      * Against the default implementation that just returns true,
      * this calls saveOptions() to save the settings of the last
      * window's	properties.
      * @see KTMainWindow#queryExit
      * @see KTMainWindow#closeEvent */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end
      * to the session config file, including saving the currently
      * opened file by a temporary filename provided by KApplication.
      * @see KTMainWindow#saveProperties */
    virtual void saveProperties(KConfig *cfg);
    /** reads the session config file and restores the application's state
      * including the last opened files and documents by reading the temporary
      * files saved by saveProperties()
      * @see KTMainWindow#readProperties */
    virtual void readProperties(KConfig *cfg);
    /** catches the starting application event to display Login dialog */
    virtual void timerEvent(QTimerEvent* e);
    /** reads last used ORACLE username from app config */
    const QString readUsername();
    /** reads last used ORACLE database from app config */
    const QString readDatabase();
    /** writes ORACLE username and database to app config */
    void saveUsernameAndDatabase(const char* username, const char* database);
    /** checks changes in user input area and
      * prompts saving changes if modified */
    bool saveModified();
    /** checks the document is only created */
    bool isNew();
    /** sets application's caption together with current script name */
    void updateCaption();
    /** appends text to output view and scrolls view down */
    void appendToOutputView(const char* text);
    /** executes command in SQL*Plus */
    void sqlplusExecute(const char* cmd, bool addToHistory = true);

  public slots:
    /** switches argument for slot selection by menu or toolbar ID */
    void commandCallback(int id);
    /** switches argument for Statusbar help entries on slot selection. */
    void statusCallback(int id);
    /** opens a new application window by creating a new instance
      * of KSqlPlusApp */
    void slotFileNewWindow();
    /** prompts ORACLE login parameters and login into ORACLE */
    void slotFileLogin();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** opens a file and load it into the document */
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(int id);
    /** saves a document */
    void slotFileSave();
    /** saves a document by a new filename*/
    void slotFileSaveAs();
    /** saves a output in a new file */
    void slotFileSaveOutput();
    /** asks for saving if the file is modified,
      * then closes the actual file and window */
    void slotFileClose();
    /** prints the actual input area */
    void slotFilePrint();
    /** prints the actual output area */
    void slotFilePrintOutput();
    /** closes all open windows by calling close() on each memberList item
      * until the list is empty, then quits the application.
      * If queryClose() returns false because the user canceled
      * the saveModified() dialog, the closing breaks. */
    void slotFileQuit();
    /** edits application accelerators */
    void slotEditKeys();
    /** toggles the toolbar */
    void slotViewToolBar();
    /** toggles the statusbar */
    void slotViewStatusBar();
    /** sets new font for views */
    void slotViewFont();
    /** slots for watch for cursor position on the input area.
      * Current cursor position is show on the status bar. */
    void slotInputViewCursorChanged();
    /** executes command from user input area in SQL*Plus */
    void slotCommandExecute();
    /** breaks command execution - kills SQL*Plus */
    void slotCommandBreak();
    /** gets previsious command from command history */
    void slotCommandPrev();
    /** gets next command from command history */
    void slotCommandNext();
    /** displays command history list in dialog */
    void slotCommandHistory();
    /** changes the statusbar contents for the standard label permanently,
      * used to indicate current actions.
      * @param text the text that is displayed in the statusbar */
    void slotStatusMsg(const char* text);
    /** changes the status message of the whole statusbar for two seconds,
      * then restores the last status. This is used to display statusbar
      * messages that give information about actions for toolbar icons and
      * menuentries.
      * @param text the text that is displayed in the statusbar */
    void slotStatusHelpMsg(const char* text);
    /** slot for SQL*Plus "received stdout" and "stderr" signals */
    void slotSqlplusStdout(KProcess *proc, char* buffer, int buflen);
    /** slot for SQL*Plus "exited" signal */
    void slotSqlplusExited(KProcess *proc);

  private:
    /** contains the recently used filenames */
    QStrList recentFiles;
    /** contains SQL*Plus command history */
    QStrList commandHistory;

		/** saved ORACLE 'username@database' parameters */
		QString lastOracleIdentity;

    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;

    /** contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** file menu containing the last five opened files */
    QPopupMenu *recentFilesMenu;
    /** contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** contains all items of the menubar entry "Command" */
    QPopupMenu *commandMenu;
    /** contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;

    /** view for SQL*Plus output */
    QMultiLineEdit *outputView;
    /** view for user input */
    KEdit *inputView;

    /** font used in views */
    QFont viewsFont;

    /** SQL*Plus as child process */
    KProcess sqlplus;
};
 
#endif // KSQLPLUS_H
