/***************************************************************************
    klogindlg.cpp  -  Logon dialog implementation

    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
    home page            : http://devel-home.kde.org/~ksqlplus
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

// include files for KDE
#include <kapp.h>
#include <kconfig.h>
#include <kmsgbox.h>

#include "klogindlg.h"

KLoginDlg::KLoginDlg(QWidget* parent, const char* name) :
  QDialog(parent, name, true)
{
  // set dialog caption
  setCaption(i18n("Logon into ORACLE"));

  // calculate widgets size
  QFontMetrics metrics = fontMetrics();
  int h = metrics.height() + 8;
  int w = metrics.width(i18n("Remote SQL*Plus")) + 20;

  // create layouts
  QVBoxLayout* topLayout = new QVBoxLayout(this, 12, 12);
  QGridLayout* editLayout = new QGridLayout(4, 2, 6);
  QHBoxLayout* buttonLayout = new QHBoxLayout(6);

  topLayout->addLayout(editLayout);
  topLayout->addLayout(buttonLayout);

  // setup components
  QLabel* usrLabel = new QLabel(i18n("Username"), this);
  usrLabel->setMinimumSize(w, h);

  usrEdit = new QLineEdit(this);
  usrEdit->setMinimumSize(w, h);

  QLabel* passLabel = new QLabel(i18n("Password"), this);
  passLabel->setMinimumSize(w, h);

  passEdit = new QLineEdit(this);
  passEdit->setMinimumSize(w, h);
  passEdit->setEchoMode(QLineEdit::Password);

  QLabel* dbLabel = new QLabel(i18n("Database"), this);
  dbLabel->setMinimumSize(w, h);

  dbEdit = new QLineEdit(this);
  dbEdit->setMinimumSize(w, h);

  QLabel* usingLabel = new QLabel(i18n("Using"), this);
  usingLabel->setMinimumSize(w, h);

  usingCombo = new QComboBox(this);
  usingCombo->setMinimumSize(w, h);
  usingCombo->insertItem(i18n("Local SQL*Plus"));
  usingCombo->insertItem(i18n("Remote SQL*Plus"));

  QPushButton* okButton = new QPushButton(this);
  okButton->setText(i18n("Logon"));
  okButton->setMinimumSize(w + 6, h + 6);
  okButton->setDefault(true);

  QPushButton* cancelButton = new QPushButton(this);
  cancelButton->setText(i18n("Cancel"));
  cancelButton->setMinimumSize(w + 6, h + 6);

  // add components
  editLayout->addWidget(usrLabel, 0, 0, AlignLeft);
  editLayout->addWidget(usrEdit, 0, 1, AlignLeft);
  editLayout->addWidget(passLabel, 1, 0, AlignLeft);
  editLayout->addWidget(passEdit, 1, 1, AlignLeft);
  editLayout->addWidget(dbLabel, 2, 0, AlignLeft);
  editLayout->addWidget(dbEdit, 2, 1, AlignLeft);
  editLayout->addWidget(usingLabel, 3, 0, AlignLeft);
  editLayout->addWidget(usingCombo, 3, 1, AlignCenter);

  buttonLayout->addWidget(okButton);
  buttonLayout->addWidget(cancelButton);

  // read stored parameters
  readOptions();

  // focus item
  usrEdit->setFocus();

  // center dialog inside parent
  if( parent )
    move(parent->x() + (parent->width() - width()) / 2,
      parent->y() + (parent->height() - height()) / 2);

  // create 'local/remote SQL*Plus' dialog
  sqlplusDlg = new KSqlPlusDlg(parent);
  // update choice by dialog data
  usingCombo->setCurrentItem(sqlplusDlg->localRemote());

  // setup slots
  connect(cancelButton, SIGNAL(clicked()), SLOT(reject()));
  connect(okButton, SIGNAL(clicked()), SLOT(logon()));
  connect(usingCombo, SIGNAL(activated(int)), SLOT(usingActivated(int)));
}

KLoginDlg::~KLoginDlg()
{
  if( sqlplusDlg ) delete sqlplusDlg;
}

void KLoginDlg::logon()
{
  // check 'username' field
  QString s(usrEdit->text());
  if( s.isEmpty() )
  {
    KMsgBox::message(this,
      i18n("Error"),
      i18n("You must set up ORACLE username."),
      KMsgBox::EXCLAMATION);
    usrEdit->setFocus();
    return;
  }

  // save parametes
  saveOptions();

  // end dialog
  accept();
}

QString KLoginDlg::connectString()
{
  QString connect(usrEdit->text());
  QString pass(passEdit->text());
  if( !pass.isEmpty() )
  {
    connect += '/';
    connect += pass;
  }
  QString db(dbEdit->text());
  if( !db.isEmpty() )
  {
    connect += '@';
    connect += db;
  }
  return connect;
}

QString KLoginDlg::identityString()
{
  QString connect = connectString();

  if( connect.isEmpty() ) return connect;

  QString ident;
  // cut 'username' field
  int i = connect.find('/');
  if( i == -1 ) i = connect.find('@');
  if( i != -1 ) ident = connect.left(i);
  else ident = connect;
  // add 'database' string
  i = connect.findRev('@');
  if( i != -1 ) ident += connect.right(connect.length() - i);
  else ident += "@LOCAL";

  // add host of remote SQL*Plus
  if( sqlplusDlg->localRemote() != 0 )
  {
    ident += '[';
    ident += sqlplusDlg->remoteHost();
    ident += ']';
  }

  return ident;
}

void KLoginDlg::setupSqlplus(KProcess& proc)
{
  // set new arguments for SQL*Plus process
  sqlplusDlg->setupSqlplus(proc, connectString());
}

void KLoginDlg::usingActivated(int index)
{
  // update local/remote SQL*Plus choice
  sqlplusDlg->setLocalRemote(index);

  // show dialog only for remote SQL*Plus
  if( index != 1 ) return;

  if( !sqlplusDlg->exec() )
  {
    // dialog was rejected - restore initial parameters
    sqlplusDlg->restore();
  }
  // update choice by dialog data
  usingCombo->setCurrentItem(sqlplusDlg->localRemote());
}

void KLoginDlg::readOptions()
{
  KConfig* config = kapp->getConfig();
  QString prev(config->group());
  config->setGroup("ORACLE Options");

  usrEdit->setText(config->readEntry("Username", ""));
  passEdit->setText(config->readEntry("Database", ""));

  config->setGroup(prev);
}

void KLoginDlg::saveOptions()
{
  KConfig* config = kapp->getConfig();
  QString prev(config->group());
  config->setGroup("ORACLE Options");

  config->writeEntry("Username", usrEdit->text());
  config->writeEntry("Database", passEdit->text());

  config->setGroup(prev);
}
